/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.utils.PasswordHash;
import com.gitblit.utils.SecureRandom;
import com.gitblit.utils.StringUtils;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PasswordHashPbkdf2
extends PasswordHash {
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordHashPbkdf2.class);
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final Configuration[] configurations = new Configuration[]{new Configuration("PBKDF2WithHmacSHA256", 10000, 256, 32)};

    PasswordHashPbkdf2() {
        super(PasswordHash.Type.PBKDF2);
    }

    @Override
    public String toHashedEntry(char[] password, String username) {
        if (password == null) {
            LOGGER.warn("The password argument may not be null when hashing a password.");
            throw new IllegalArgumentException("The password argument may not be null when hashing a password.");
        }
        int configId = this.getLatestConfigurationId();
        Configuration config = configurations[configId];
        byte[] salt = new byte[config.saltLen];
        RANDOM.nextBytes(salt);
        byte[] hash = PasswordHashPbkdf2.hash(password, salt, config);
        return this.type.name() + ":" + "$" + configId + "$" + StringUtils.toHex(salt) + StringUtils.toHex(hash);
    }

    @Override
    public boolean matches(String hashedEntry, char[] password, String username) {
        if (hashedEntry == null || this.type != PasswordHash.getEntryType(hashedEntry)) {
            return false;
        }
        if (password == null) {
            return false;
        }
        String hashedPart = PasswordHashPbkdf2.getEntryValue(hashedEntry);
        int configId = PasswordHashPbkdf2.getConfigIdFromStoredPassword(hashedPart);
        return PasswordHashPbkdf2.isPasswordCorrect(password, hashedPart, configurations[configId]);
    }

    private int getLatestConfigurationId() {
        return configurations.length - 1;
    }

    private static int getConfigIdFromStoredPassword(String hashPart) {
        String[] parts = hashPart.split("\\$", 3);
        if (parts.length <= 2) {
            return 0;
        }
        try {
            int configId = Integer.parseInt(parts[1]);
            if (configId < 0 || configId >= configurations.length) {
                LOGGER.warn("A user table password entry contains a configuration id that is not valid: {}.Assuming PBKDF configuration 0. This may fail to validate the password.", (Object)configId);
                return 0;
            }
            return configId;
        }
        catch (NumberFormatException e) {
            LOGGER.warn("A user table password entry contains a configuration id that is not a parsable number ({}${}$...).Assuming PBKDF configuration 0. This may fail to validate the password.", new Object[]{parts[0], parts[1], e});
            return 0;
        }
    }

    private static byte[] hash(char[] password, byte[] salt, Configuration config) {
        PBEKeySpec spec = new PBEKeySpec(password, salt, config.iterations, config.keyLen);
        Arrays.fill(password, '\u0000');
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance(config.algorithm);
            byte[] byArray = skf.generateSecret(spec).getEncoded();
            return byArray;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOGGER.warn("Error while hashing password.", (Throwable)e);
            throw new IllegalStateException("Error while hashing password", e);
        }
        finally {
            spec.clearPassword();
        }
    }

    private static boolean isPasswordCorrect(char[] passwordToCheck, byte[] salt, byte[] expectedHash, Configuration config) {
        byte[] hashToCheck = PasswordHashPbkdf2.hash(passwordToCheck, salt, config);
        Arrays.fill(passwordToCheck, '\u0000');
        if (hashToCheck.length != expectedHash.length) {
            return false;
        }
        for (int i = 0; i < hashToCheck.length; ++i) {
            if (hashToCheck[i] == expectedHash[i]) continue;
            return false;
        }
        return true;
    }

    private static byte[] getSaltFromStoredPassword(String storedPassword, Configuration config) {
        byte[] pw = PasswordHashPbkdf2.getStoredHashWithStrippedPrefix(storedPassword);
        return Arrays.copyOfRange(pw, 0, config.saltLen);
    }

    private static byte[] getHashFromStoredPassword(String storedPassword, Configuration config) {
        byte[] pw = PasswordHashPbkdf2.getStoredHashWithStrippedPrefix(storedPassword);
        return Arrays.copyOfRange(pw, config.saltLen, pw.length);
    }

    private static byte[] getStoredHashWithStrippedPrefix(String storedPassword) {
        String[] strings = storedPassword.split("\\$", 3);
        String saltAndHash = strings[strings.length - 1];
        try {
            return Hex.decodeHex((char[])saltAndHash.toCharArray());
        }
        catch (DecoderException e) {
            LOGGER.warn("Failed to decode stored password entry from hex to string.", (Throwable)e);
            throw new IllegalStateException("Error while reading stored credentials", e);
        }
    }

    private static boolean isPasswordCorrect(char[] password, String storedPassword, Configuration config) {
        byte[] storedSalt = PasswordHashPbkdf2.getSaltFromStoredPassword(storedPassword, config);
        byte[] storedHash = PasswordHashPbkdf2.getHashFromStoredPassword(storedPassword, config);
        return PasswordHashPbkdf2.isPasswordCorrect(password, storedSalt, storedHash, config);
    }

    private static class Configuration {
        private final String algorithm;
        private final int iterations;
        private final int keyLen;
        private final int saltLen;

        private Configuration(String algorithm, int iterations, int keyLen, int saltLen) {
            this.algorithm = algorithm;
            this.iterations = iterations;
            this.keyLen = keyLen;
            this.saltLen = saltLen;
        }
    }
}

