/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.Constants;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.revwalk.RevCommit;

public class PatchFormatter
extends DiffFormatter {
    private final OutputStream os;
    private Map<String, PatchTouple> changes = new HashMap<String, PatchTouple>();
    private PatchTouple currentTouple;

    public PatchFormatter(OutputStream os) {
        super(os);
        this.os = os;
    }

    public void format(DiffEntry entry) throws IOException {
        this.currentTouple = new PatchTouple();
        this.changes.put(entry.getNewPath(), this.currentTouple);
        super.format(entry);
    }

    protected void writeLine(char prefix, RawText text, int cur) throws IOException {
        switch (prefix) {
            case '+': {
                ++this.currentTouple.insertions;
                break;
            }
            case '-': {
                ++this.currentTouple.deletions;
            }
        }
        super.writeLine(prefix, text, cur);
    }

    public String getPatch(RevCommit commit) {
        StringBuilder patch = new StringBuilder();
        patch.append("From " + commit.getName() + " Mon Sep 17 00:00:00 2001" + "\n");
        patch.append("From: " + JGitUtils.getDisplayName(commit.getAuthorIdent()) + "\n");
        patch.append("Date: " + new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z").format(new Date((long)commit.getCommitTime() * 1000L)) + "\n");
        patch.append("Subject: [PATCH] " + commit.getShortMessage() + "\n");
        patch.append('\n');
        patch.append("---");
        int maxPathLen = 0;
        int files = 0;
        int insertions = 0;
        int deletions = 0;
        for (String path : this.changes.keySet()) {
            if (path.length() > maxPathLen) {
                maxPathLen = path.length();
            }
            PatchTouple touple = this.changes.get(path);
            ++files;
            insertions += touple.insertions;
            deletions += touple.deletions;
        }
        int total = insertions + deletions;
        int columns = 60;
        int unit = total / columns + (total % columns > 0 ? 1 : 0);
        if (unit == 0) {
            unit = 1;
        }
        for (String path : this.changes.keySet()) {
            PatchTouple touple = this.changes.get(path);
            patch.append("\n " + StringUtils.rightPad(path, maxPathLen, ' ') + " | " + StringUtils.leftPad("" + touple.total(), 4, ' ') + " " + touple.relativeScale(unit));
        }
        patch.append(MessageFormat.format("\n {0} files changed, {1} insertions(+), {2} deletions(-)\n\n", files, insertions, deletions));
        patch.append(this.os.toString());
        patch.append("\n--\n");
        patch.append(Constants.getGitBlitVersion());
        return patch.toString();
    }

    private static class PatchTouple {
        int insertions;
        int deletions;

        private PatchTouple() {
        }

        int total() {
            return this.insertions + this.deletions;
        }

        String relativeScale(int unit) {
            int i;
            int plus = this.insertions / unit;
            int minus = this.deletions / unit;
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < plus; ++i) {
                sb.append('+');
            }
            for (i = 0; i < minus; ++i) {
                sb.append('-');
            }
            return sb.toString();
        }
    }
}

