/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;

public class PathUtils {
    private PathUtils() {
    }

    public static List<String> compressPaths(Iterable<String> paths) {
        ArrayList<String> pathList = new ArrayList<String>();
        LinkedHashMap<String, ArrayList<String[]>> folderRoots = new LinkedHashMap<String, ArrayList<String[]>>();
        for (String s : paths) {
            String[] components = s.split("/");
            if (components.length == 1) {
                pathList.add(components[0]);
                continue;
            }
            ArrayList<String[]> rootedPaths = (ArrayList<String[]>)folderRoots.get(components[0]);
            if (rootedPaths == null) {
                rootedPaths = new ArrayList<String[]>();
            }
            rootedPaths.add(components);
            folderRoots.put(components[0], rootedPaths);
        }
        for (String folder : folderRoots.keySet()) {
            List matchingPaths = (List)folderRoots.get(folder);
            if (matchingPaths.size() == 1) {
                pathList.add(PathUtils.toStringPath((String[])matchingPaths.get(0)));
                continue;
            }
            pathList.add(PathUtils.longestCommonSequence(matchingPaths));
        }
        return pathList;
    }

    public static String getLastPathComponent(String path) {
        return (String)Iterables.getLast((Iterable)Splitter.on((String)"/").omitEmptyStrings().split((CharSequence)path), (Object)path);
    }

    private static String toStringPath(String[] pathComponents) {
        List<String> tmp = Arrays.asList(pathComponents);
        return Joiner.on((char)'/').join(tmp.subList(0, tmp.size() - 1)) + '/';
    }

    private static String longestCommonSequence(List<String[]> paths) {
        StringBuilder path = new StringBuilder();
        for (int i = 0; i < paths.get(0).length; ++i) {
            String current = paths.get(0)[i];
            for (int j = 1; j < paths.size(); ++j) {
                if (current.equals(paths.get(j)[i])) continue;
                return path.toString();
            }
            path.append(current);
            path.append('/');
        }
        return path.toString();
    }
}

