/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.utils.ArrayUtils;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class StringUtils {
    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean isEmpty(char[] value) {
        if (value == null || value.length == 0) {
            return true;
        }
        for (char c : value) {
            if (c <= ' ') continue;
            return false;
        }
        return true;
    }

    public static String breakLinesForHtml(String string) {
        return string.replace("\r\n", "<br/>").replace("\r", "<br/>").replace("\n", "<br/>");
    }

    public static String escapeForHtml(String inStr, boolean changeSpace) {
        return StringUtils.escapeForHtml(inStr, changeSpace, 4);
    }

    public static String escapeForHtml(String inStr, boolean changeSpace, int tabLength) {
        StringBuilder retStr = new StringBuilder();
        for (int i = 0; i < inStr.length(); ++i) {
            if (inStr.charAt(i) == '&') {
                retStr.append("&amp;");
                continue;
            }
            if (inStr.charAt(i) == '<') {
                retStr.append("&lt;");
                continue;
            }
            if (inStr.charAt(i) == '>') {
                retStr.append("&gt;");
                continue;
            }
            if (inStr.charAt(i) == '\"') {
                retStr.append("&quot;");
                continue;
            }
            if (changeSpace && inStr.charAt(i) == ' ') {
                retStr.append("&nbsp;");
                continue;
            }
            if (changeSpace && inStr.charAt(i) == '\t') {
                for (int j = 0; j < tabLength; ++j) {
                    retStr.append("&nbsp;");
                }
                continue;
            }
            retStr.append(inStr.charAt(i));
        }
        return retStr.toString();
    }

    public static String decodeFromHtml(String inStr) {
        return inStr.replace("&amp;", "&").replace("&lt;", "<").replace("&gt;", ">").replace("&quot;", "\"").replace("&nbsp;", " ");
    }

    public static String encodeURL(String inStr) {
        StringBuilder retStr = new StringBuilder();
        for (int i = 0; i < inStr.length(); ++i) {
            if (inStr.charAt(i) == '/') {
                retStr.append("%2F");
                continue;
            }
            if (inStr.charAt(i) == ' ') {
                retStr.append("%20");
                continue;
            }
            if (inStr.charAt(i) == '&') {
                retStr.append("%26");
                continue;
            }
            if (inStr.charAt(i) == '+') {
                retStr.append("%2B");
                continue;
            }
            retStr.append(inStr.charAt(i));
        }
        return retStr.toString();
    }

    public static String flattenStrings(String[] values, String separator) {
        return StringUtils.flattenStrings(Arrays.asList(values), separator);
    }

    public static String flattenStrings(Collection<String> values) {
        return StringUtils.flattenStrings(values, " ");
    }

    public static String flattenStrings(Collection<String> values, String separator) {
        StringBuilder sb = new StringBuilder();
        for (String value : values) {
            sb.append(value).append(separator);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - separator.length());
        }
        return sb.toString().trim();
    }

    public static String trimString(String value, int max) {
        if (value.length() <= max) {
            return value;
        }
        return value.substring(0, max - 3) + "...";
    }

    public static String leftPad(String input, int length, char pad) {
        if (input.length() < length) {
            StringBuilder sb = new StringBuilder();
            int len = length - input.length();
            for (int i = 0; i < len; ++i) {
                sb.append(pad);
            }
            sb.append(input);
            return sb.toString();
        }
        return input;
    }

    public static String rightPad(String input, int length, char pad) {
        if (input.length() < length) {
            StringBuilder sb = new StringBuilder();
            sb.append(input);
            int len = length - input.length();
            for (int i = 0; i < len; ++i) {
                sb.append(pad);
            }
            return sb.toString();
        }
        return input;
    }

    public static String getSHA1(String text) {
        try {
            byte[] bytes = text.getBytes("iso-8859-1");
            return StringUtils.getSHA1(bytes);
        }
        catch (UnsupportedEncodingException u) {
            throw new RuntimeException(u);
        }
    }

    public static String getSHA1(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(bytes, 0, bytes.length);
            byte[] digest = md.digest();
            return StringUtils.toHex(digest);
        }
        catch (NoSuchAlgorithmException t) {
            throw new RuntimeException(t);
        }
    }

    public static String getMD5(String string) {
        try {
            return StringUtils.getMD5(string.getBytes("iso-8859-1"));
        }
        catch (UnsupportedEncodingException u) {
            throw new RuntimeException(u);
        }
    }

    public static String getMD5(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(bytes);
            byte[] digest = md.digest();
            return StringUtils.toHex(digest);
        }
        catch (NoSuchAlgorithmException t) {
            throw new RuntimeException(t);
        }
    }

    public static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            if ((bytes[i] & 0xFF) < 16) {
                sb.append('0');
            }
            sb.append(Long.toString(bytes[i] & 0xFF, 16));
        }
        return sb.toString();
    }

    public static String getRootPath(String path) {
        if (path.indexOf(47) > -1) {
            return path.substring(0, path.lastIndexOf(47));
        }
        return "";
    }

    public static String getRelativePath(String basePath, String fullPath) {
        String bp = basePath.replace('\\', '/').toLowerCase();
        String fp = fullPath.replace('\\', '/').toLowerCase();
        if (fp.startsWith(bp)) {
            String relativePath = fullPath.substring(basePath.length()).replace('\\', '/');
            if (relativePath.length() > 0 && relativePath.charAt(0) == '/') {
                relativePath = relativePath.substring(1);
            }
            return relativePath;
        }
        return fullPath;
    }

    public static List<String> getStringsFromValue(String value) {
        return StringUtils.getStringsFromValue(value, " ");
    }

    public static List<String> getStringsFromValue(String value, String separator) {
        ArrayList<String> strings = new ArrayList<String>();
        try {
            String[] chunks;
            for (String chunk : chunks = value.split(separator + "(?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
                if ((chunk = chunk.trim()).length() <= 0) continue;
                if (chunk.charAt(0) == '\"' && chunk.charAt(chunk.length() - 1) == '\"') {
                    chunk = chunk.substring(1, chunk.length() - 1).trim();
                }
                strings.add(chunk);
            }
        }
        catch (PatternSyntaxException e) {
            throw new RuntimeException(e);
        }
        return strings;
    }

    public static Character findInvalidCharacter(String name) {
        char[] validChars = new char[]{'/', '.', '_', '-', '~', '+'};
        for (char c : name.toCharArray()) {
            if (Character.isLetterOrDigit(c)) continue;
            boolean ok = false;
            for (char vc : validChars) {
                ok |= c == vc;
            }
            if (ok) continue;
            return Character.valueOf(c);
        }
        return null;
    }

    public static boolean fuzzyMatch(String value, String pattern) {
        if (value.equalsIgnoreCase(pattern)) {
            return true;
        }
        if (pattern.contains("*")) {
            boolean prefixMatches = false;
            boolean suffixMatches = false;
            int wildcard = pattern.indexOf(42);
            String prefix = pattern.substring(0, wildcard).toLowerCase();
            prefixMatches = value.toLowerCase().startsWith(prefix);
            if (pattern.length() > wildcard + 1) {
                String suffix = pattern.substring(wildcard + 1).toLowerCase();
                suffixMatches = value.toLowerCase().endsWith(suffix);
                return prefixMatches && suffixMatches;
            }
            return prefixMatches || suffixMatches;
        }
        return false;
    }

    public static int compareRepositoryNames(String r1, String r2) {
        r1 = r1.toLowerCase();
        r2 = r2.toLowerCase();
        int s1 = r1.indexOf(47);
        int s2 = r2.indexOf(47);
        if (s1 == -1 && s2 == -1) {
            return r1.compareTo(r2);
        }
        if (s1 > -1 && s2 > -1) {
            return r1.compareTo(r2);
        }
        if (s1 == -1) {
            return -1;
        }
        if (s2 == -1) {
            return 1;
        }
        return 0;
    }

    public static void sortRepositorynames(List<String> list) {
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return StringUtils.compareRepositoryNames(o1, o2);
            }
        });
    }

    public static String getColor(String value) {
        int cs = 0;
        for (char c : StringUtils.getMD5(value.toLowerCase()).toCharArray()) {
            cs += c;
        }
        int n = cs % 360;
        float hue = (float)n / 360.0f;
        return StringUtils.hsvToRgb(hue, 0.9f, 0.65f);
    }

    public static String hsvToRgb(float hue, float saturation, float value) {
        int h = (int)(hue * 6.0f);
        float f = hue * 6.0f - (float)h;
        float p = value * (1.0f - saturation);
        float q = value * (1.0f - f * saturation);
        float t = value * (1.0f - (1.0f - f) * saturation);
        switch (h) {
            case 0: {
                return StringUtils.rgbToString(value, t, p);
            }
            case 1: {
                return StringUtils.rgbToString(q, value, p);
            }
            case 2: {
                return StringUtils.rgbToString(p, value, t);
            }
            case 3: {
                return StringUtils.rgbToString(p, q, value);
            }
            case 4: {
                return StringUtils.rgbToString(t, p, value);
            }
            case 5: {
                return StringUtils.rgbToString(value, p, q);
            }
        }
        throw new RuntimeException("Something went wrong when converting from HSV to RGB. Input was " + hue + ", " + saturation + ", " + value);
    }

    public static String rgbToString(float r, float g, float b) {
        String rs = Integer.toHexString((int)(r * 256.0f));
        String gs = Integer.toHexString((int)(g * 256.0f));
        String bs = Integer.toHexString((int)(b * 256.0f));
        return "#" + rs + gs + bs;
    }

    public static String stripDotGit(String value) {
        if (value.toLowerCase().endsWith(".git")) {
            return value.substring(0, value.length() - 4);
        }
        return value;
    }

    public static int countLines(String value) {
        if (StringUtils.isEmpty(value)) {
            return 0;
        }
        return value.split("\n").length;
    }

    public static String getFileExtension(String path) {
        int lastDot = path.lastIndexOf(46);
        if (lastDot > -1) {
            return path.substring(lastDot + 1);
        }
        return "";
    }

    public static String stripFileExtension(String path) {
        int lastDot = path.lastIndexOf(46);
        if (lastDot > -1) {
            return path.substring(0, lastDot);
        }
        return path;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static String decodeString(byte[] content, String ... charsets) {
        LinkedHashSet<String> sets = new LinkedHashSet<String>();
        if (!ArrayUtils.isEmpty(charsets)) {
            sets.addAll(Arrays.asList(charsets));
        }
        String value = null;
        sets.addAll(Arrays.asList("UTF-8", "ISO-8859-1", Charset.defaultCharset().name()));
        for (String charset : sets) {
            try {
                Charset cs = Charset.forName(charset);
                CharsetDecoder decoder = cs.newDecoder();
                CharBuffer buffer = decoder.decode(ByteBuffer.wrap(content));
                value = buffer.toString();
                break;
            }
            catch (CharacterCodingException characterCodingException) {
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
            }
        }
        if (value != null && value.startsWith("\ufeff")) {
            return value.substring(1);
        }
        return value;
    }

    public static String extractRepositoryPath(String url, String ... urlpatterns) {
        for (String urlPattern : urlpatterns) {
            Pattern p = Pattern.compile(urlPattern);
            Matcher m = p.matcher(url);
            if (!m.find()) continue;
            String repositoryPath = m.group(1);
            return repositoryPath;
        }
        if (url.lastIndexOf(47) > -1) {
            return url.substring(url.lastIndexOf(47) + 1);
        }
        return url;
    }

    public static String convertOctal(String input) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            Pattern p = Pattern.compile("(\\\\\\d{3})");
            Matcher m = p.matcher(input);
            int i = 0;
            while (m.find()) {
                bytes.write(input.substring(i, m.start()).getBytes("UTF-8"));
                String oct = m.group().substring(1);
                bytes.write(Integer.parseInt(oct, 8));
                i = m.end();
            }
            if (bytes.size() == 0) {
                return input;
            }
            if (i < input.length()) {
                bytes.write(input.substring(i).getBytes("UTF-8"));
            }
            return bytes.toString("UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return input;
        }
    }

    public static String getFirstPathElement(String path) {
        if (path.indexOf(47) > -1) {
            return path.substring(0, path.indexOf(47)).trim();
        }
        return "";
    }

    public static String getLastPathElement(String path) {
        if (path.indexOf(47) > -1) {
            return path.substring(path.lastIndexOf(47) + 1);
        }
        return path;
    }

    public static boolean matchesIgnoreCase(String input, String regex2) {
        Pattern p = Pattern.compile(regex2, 2);
        Matcher m = p.matcher(input);
        return m.matches();
    }

    public static String removeNewlines(String input) {
        if (input == null) {
            return "";
        }
        return input.replace('\n', ' ').replace('\r', ' ').trim();
    }

    public static String encodeUsername(String name) {
        return name.replace("@", "%40").replace(" ", "%20").replace("\\", "%5C");
    }

    public static String decodeUsername(String name) {
        return name.replace("%40", "@").replace("%20", " ").replace("%5C", "\\");
    }
}

