/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.Constants;
import com.gitblit.GitBlitException;
import com.gitblit.models.FeedEntryModel;
import com.gitblit.utils.ConnectionUtils;
import com.gitblit.utils.StringUtils;
import com.sun.syndication.feed.synd.SyndCategory;
import com.sun.syndication.feed.synd.SyndCategoryImpl;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.feed.synd.SyndImage;
import com.sun.syndication.feed.synd.SyndImageImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.SyndFeedOutput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class SyndicationUtils {
    public static void toRSS(String hostUrl, String feedLink, String title, String description, List<FeedEntryModel> entryModels, OutputStream os) throws IOException, FeedException {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType("rss_2.0");
        feed.setEncoding("UTF-8");
        feed.setTitle(title);
        feed.setLink(feedLink);
        if (StringUtils.isEmpty(description)) {
            feed.setDescription(title);
        } else {
            feed.setDescription(description);
        }
        SyndImageImpl image = new SyndImageImpl();
        image.setTitle("Gitblit");
        image.setUrl(hostUrl + "/gitblt_25.png");
        image.setLink(hostUrl);
        feed.setImage((SyndImage)image);
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        for (FeedEntryModel entryModel : entryModels) {
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(entryModel.title);
            entry.setAuthor(entryModel.author);
            entry.setLink(entryModel.link);
            entry.setPublishedDate(entryModel.published);
            if (entryModel.tags != null && entryModel.tags.size() > 0) {
                ArrayList<SyndCategoryImpl> tags = new ArrayList<SyndCategoryImpl>();
                for (String tag : entryModel.tags) {
                    SyndCategoryImpl cat = new SyndCategoryImpl();
                    cat.setName(tag);
                    tags.add(cat);
                }
                entry.setCategories(tags);
            }
            SyndContentImpl content = new SyndContentImpl();
            if (StringUtils.isEmpty(entryModel.contentType) || entryModel.contentType.equalsIgnoreCase("text/plain")) {
                content.setType("text/html");
                content.setValue(StringUtils.breakLinesForHtml(entryModel.content));
            } else {
                content.setType(entryModel.contentType);
                content.setValue(entryModel.content);
            }
            entry.setDescription((SyndContent)content);
            entries.add(entry);
        }
        feed.setEntries(entries);
        OutputStreamWriter writer = new OutputStreamWriter(os, "UTF-8");
        SyndFeedOutput output = new SyndFeedOutput();
        output.output((SyndFeed)feed, (Writer)writer);
        writer.close();
    }

    public static List<FeedEntryModel> readFeed(String url, String repository, String branch, int numberOfEntries, int page, String username, char[] password) throws IOException {
        return SyndicationUtils.readFeed(url, repository, branch, Constants.FeedObjectType.COMMIT, numberOfEntries, page, username, password);
    }

    public static List<FeedEntryModel> readTags(String url, String repository, int numberOfEntries, int page, String username, char[] password) throws IOException {
        return SyndicationUtils.readFeed(url, repository, null, Constants.FeedObjectType.TAG, numberOfEntries, page, username, password);
    }

    private static List<FeedEntryModel> readFeed(String url, String repository, String branch, Constants.FeedObjectType objectType, int numberOfEntries, int page, String username, char[] password) throws IOException {
        ArrayList<String> parameters = new ArrayList<String>();
        if (numberOfEntries > 0) {
            parameters.add("l=" + numberOfEntries);
        }
        if (page > 0) {
            parameters.add("pg=" + page);
        }
        if (!StringUtils.isEmpty(branch)) {
            parameters.add("h=" + branch);
        }
        if (objectType != null) {
            parameters.add("ot=" + objectType.name());
        }
        return SyndicationUtils.readFeed(url, parameters, repository, branch, username, password);
    }

    public static List<FeedEntryModel> readSearchFeed(String url, String repository, String branch, String fragment, Constants.SearchType searchType, int numberOfEntries, int page, String username, char[] password) throws IOException {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("s=" + StringUtils.encodeURL(fragment));
        if (numberOfEntries > 0) {
            parameters.add("l=" + numberOfEntries);
        }
        if (page > 0) {
            parameters.add("pg=" + page);
        }
        if (!StringUtils.isEmpty(branch)) {
            parameters.add("h=" + branch);
        }
        if (searchType != null) {
            parameters.add("st=" + searchType.name());
        }
        return SyndicationUtils.readFeed(url, parameters, repository, branch, username, password);
    }

    private static List<FeedEntryModel> readFeed(String url, List<String> parameters, String repository, String branch, String username, char[] password) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormat.format("{0}/feed/{1}", url, repository));
        if (parameters.size() > 0) {
            boolean first = true;
            for (String parameter : parameters) {
                if (first) {
                    sb.append('?');
                    first = false;
                } else {
                    sb.append('&');
                }
                sb.append(parameter);
            }
        }
        String feedUrl = sb.toString();
        URLConnection conn = ConnectionUtils.openReadConnection(feedUrl, username, password);
        InputStream is = conn.getInputStream();
        SyndFeedInput input = new SyndFeedInput();
        SyndFeed feed = null;
        try {
            feed = input.build((Reader)new XmlReader(is));
        }
        catch (FeedException f) {
            throw new GitBlitException(f);
        }
        is.close();
        ArrayList<FeedEntryModel> entries = new ArrayList<FeedEntryModel>();
        for (Object o : feed.getEntries()) {
            SyndEntryImpl entry = (SyndEntryImpl)o;
            FeedEntryModel model = new FeedEntryModel();
            model.repository = repository;
            model.branch = branch;
            model.title = entry.getTitle();
            model.author = entry.getAuthor();
            model.published = entry.getPublishedDate();
            model.link = entry.getLink();
            model.content = entry.getDescription().getValue();
            model.contentType = entry.getDescription().getType();
            if (entry.getCategories() != null && entry.getCategories().size() > 0) {
                ArrayList<String> tags = new ArrayList<String>();
                for (Object p : entry.getCategories()) {
                    SyndCategory cat = (SyndCategory)p;
                    tags.add(cat.getName());
                }
                model.tags = tags;
            }
            entries.add(model);
        }
        return entries;
    }
}

