/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.models.UserModel;
import com.gitblit.utils.FileUtils;
import com.gitblit.utils.HttpUtils;
import com.gitblit.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.naming.ldap.LdapName;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMEncryptor;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcePEMEncryptorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509Utils {
    public static final String SERVER_KEY_STORE = "serverKeyStore.jks";
    public static final String SERVER_TRUST_STORE = "serverTrustStore.jks";
    public static final String CERTS = "certs";
    public static final String CA_KEY_STORE = "certs/caKeyStore.p12";
    public static final String CA_REVOCATION_LIST = "certs/caRevocationList.crl";
    public static final String CA_CONFIG = "certs/authority.conf";
    public static final String CA_CN = "Gitblit Certificate Authority";
    public static final String CA_ALIAS = "Gitblit Certificate Authority";
    private static final String BC = "BC";
    private static final int KEY_LENGTH = 2048;
    private static final String KEY_ALGORITHM = "RSA";
    private static final String SIGNING_ALGORITHM = "SHA512withRSA";
    public static final boolean unlimitedStrength;
    private static final Logger logger;

    public static void prepareX509Infrastructure(X509Metadata metadata, File folder, X509Log x509log) {
        File serverTrustStore;
        X509Certificate caCert;
        File serverKeyStore;
        File oldKeyStore;
        File caRevocationList;
        folder.mkdirs();
        File caKeyStore = new File(folder, CA_KEY_STORE);
        if (!caKeyStore.exists()) {
            logger.info(MessageFormat.format("Generating {0} ({1})", "Gitblit Certificate Authority", caKeyStore.getAbsolutePath()));
            X509Certificate caCert2 = X509Utils.newCertificateAuthority(metadata, caKeyStore, x509log);
            X509Utils.saveCertificate(caCert2, new File(caKeyStore.getParentFile(), "ca.cer"));
        }
        if (!(caRevocationList = new File(folder, CA_REVOCATION_LIST)).exists()) {
            logger.info(MessageFormat.format("Generating {0} CRL ({1})", "Gitblit Certificate Authority", caRevocationList.getAbsolutePath()));
            X509Utils.newCertificateRevocationList(caRevocationList, caKeyStore, metadata.password);
            x509log.log("new certificate revocation list created");
        }
        if ((oldKeyStore = new File(folder, "keystore")).exists()) {
            oldKeyStore.renameTo(new File(folder, SERVER_KEY_STORE));
            logger.info(MessageFormat.format("Renaming {0} to {1}", oldKeyStore.getName(), SERVER_KEY_STORE));
        }
        if (!(serverKeyStore = new File(folder, SERVER_KEY_STORE)).exists()) {
            logger.info(MessageFormat.format("Generating SSL certificate for {0} signed by {1} ({2})", metadata.commonName, "Gitblit Certificate Authority", serverKeyStore.getAbsolutePath()));
            PrivateKey caPrivateKey = X509Utils.getPrivateKey("Gitblit Certificate Authority", caKeyStore, metadata.password);
            caCert = X509Utils.getCertificate("Gitblit Certificate Authority", caKeyStore, metadata.password);
            X509Utils.newSSLCertificate(metadata, caPrivateKey, caCert, serverKeyStore, x509log);
        }
        if (!(serverTrustStore = new File(folder, SERVER_TRUST_STORE)).exists()) {
            logger.info(MessageFormat.format("Importing {0} into trust store ({1})", "Gitblit Certificate Authority", serverTrustStore.getAbsolutePath()));
            caCert = X509Utils.getCertificate("Gitblit Certificate Authority", caKeyStore, metadata.password);
            X509Utils.addTrustedCertificate("Gitblit Certificate Authority", caCert, serverTrustStore, metadata.password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore openKeyStore(File storeFile, String storePassword) {
        String lc = storeFile.getName().toLowerCase();
        String type = "JKS";
        String provider = null;
        if (lc.endsWith(".p12") || lc.endsWith(".pfx")) {
            type = "PKCS12";
            provider = BC;
        }
        try {
            KeyStore store = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
            if (storeFile.exists()) {
                try (FileInputStream fis = null;){
                    fis = new FileInputStream(storeFile);
                    store.load(fis, storePassword.toCharArray());
                }
            } else {
                store.load(null);
            }
            return store;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not open keystore " + storeFile, e);
        }
    }

    public static void saveKeyStore(File targetStoreFile, KeyStore store, String password) {
        File folder = targetStoreFile.getAbsoluteFile().getParentFile();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File tmpFile = new File(folder, Long.toHexString(System.currentTimeMillis()) + ".tmp");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(tmpFile);
            store.store(fos, password.toCharArray());
            fos.flush();
            fos.close();
            if (targetStoreFile.exists()) {
                targetStoreFile.delete();
            }
            tmpFile.renameTo(targetStoreFile);
        }
        catch (IOException e) {
            String message = e.getMessage().toLowerCase();
            if (message.contains("illegal key size")) {
                throw new RuntimeException("Illegal Key Size! You might consider installing the JCE Unlimited Strength Jurisdiction Policy files for your JVM.");
            }
            throw new RuntimeException("Could not save keystore " + targetStoreFile, e);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not save keystore " + targetStoreFile, e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
    }

    public static X509Certificate getCertificate(String alias, File storeFile, String storePassword) {
        try {
            KeyStore store = X509Utils.openKeyStore(storeFile, storePassword);
            X509Certificate caCert = (X509Certificate)store.getCertificate(alias);
            return caCert;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PrivateKey getPrivateKey(String alias, File storeFile, String storePassword) {
        try {
            KeyStore store = X509Utils.openKeyStore(storeFile, storePassword);
            PrivateKey key = (PrivateKey)store.getKey(alias, storePassword.toCharArray());
            return key;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCertificate(X509Certificate cert, File targetFile) {
        File folder = targetFile.getAbsoluteFile().getParentFile();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File tmpFile = new File(folder, Long.toHexString(System.currentTimeMillis()) + ".tmp");
        try {
            boolean asPem = targetFile.getName().toLowerCase().endsWith(".pem");
            if (asPem) {
                try (PEMWriter pemWriter = null;){
                    pemWriter = new PEMWriter((Writer)new FileWriter(tmpFile));
                    pemWriter.writeObject((Object)cert);
                    pemWriter.flush();
                }
            }
            try (FileOutputStream fos = null;){
                fos = new FileOutputStream(tmpFile);
                fos.write(cert.getEncoded());
                fos.flush();
            }
            if (targetFile.exists()) {
                targetFile.delete();
            }
            tmpFile.renameTo(targetFile);
        }
        catch (Exception e) {
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
            throw new RuntimeException("Failed to save certificate " + cert.getSubjectX500Principal().getName(), e);
        }
    }

    private static KeyPair newKeyPair() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance(KEY_ALGORITHM, BC);
        kpGen.initialize(2048, new SecureRandom());
        return kpGen.generateKeyPair();
    }

    private static X500Name buildDistinguishedName(X509Metadata metadata) {
        X500NameBuilder dnBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        X509Utils.setOID(dnBuilder, metadata, "C", null);
        X509Utils.setOID(dnBuilder, metadata, "ST", null);
        X509Utils.setOID(dnBuilder, metadata, "L", null);
        X509Utils.setOID(dnBuilder, metadata, "O", "Gitblit");
        X509Utils.setOID(dnBuilder, metadata, "OU", "Gitblit");
        X509Utils.setOID(dnBuilder, metadata, "E", metadata.emailAddress);
        X509Utils.setOID(dnBuilder, metadata, "CN", metadata.commonName);
        X500Name dn = dnBuilder.build();
        return dn;
    }

    private static void setOID(X500NameBuilder dnBuilder, X509Metadata metadata, String oid, String defaultValue) {
        String value = null;
        if (metadata.oids != null && metadata.oids.containsKey(oid)) {
            value = metadata.oids.get(oid);
        }
        if (StringUtils.isEmpty(value)) {
            value = defaultValue;
        }
        if (!StringUtils.isEmpty(value)) {
            try {
                Field field = BCStyle.class.getField(oid);
                ASN1ObjectIdentifier objectId = (ASN1ObjectIdentifier)field.get(null);
                dnBuilder.addRDN(objectId, value);
            }
            catch (Exception e) {
                logger.error(MessageFormat.format("Failed to set OID \"{0}\"!", oid), (Throwable)e);
            }
        }
    }

    public static X509Certificate newSSLCertificate(X509Metadata sslMetadata, PrivateKey caPrivateKey, X509Certificate caCert, File targetStoreFile, X509Log x509log) {
        try {
            KeyPair pair = X509Utils.newKeyPair();
            X500Name webDN = X509Utils.buildDistinguishedName(sslMetadata);
            X500Name issuerDN = new X500Name(PrincipalUtil.getIssuerX509Principal((X509Certificate)caCert).getName());
            JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(issuerDN, BigInteger.valueOf(System.currentTimeMillis()), sslMetadata.notBefore, sslMetadata.notAfter, webDN, pair.getPublic());
            JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
            certBuilder.addExtension(X509Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(pair.getPublic()));
            certBuilder.addExtension(X509Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
            certBuilder.addExtension(X509Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(caCert.getPublicKey()));
            ArrayList<GeneralName> altNames = new ArrayList<GeneralName>();
            if (HttpUtils.isIpAddress(sslMetadata.commonName)) {
                altNames.add(new GeneralName(7, sslMetadata.commonName));
            }
            if (altNames.size() > 0) {
                GeneralNames subjectAltName = new GeneralNames(altNames.toArray(new GeneralName[altNames.size()]));
                certBuilder.addExtension(X509Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltName);
            }
            ContentSigner caSigner = new JcaContentSignerBuilder(SIGNING_ALGORITHM).setProvider(BC).build(caPrivateKey);
            X509Certificate cert = new JcaX509CertificateConverter().setProvider(BC).getCertificate(certBuilder.build(caSigner));
            cert.checkValidity(new Date());
            cert.verify(caCert.getPublicKey());
            KeyStore serverStore = X509Utils.openKeyStore(targetStoreFile, sslMetadata.password);
            serverStore.setKeyEntry(sslMetadata.commonName, pair.getPrivate(), sslMetadata.password.toCharArray(), new Certificate[]{cert, caCert});
            X509Utils.saveKeyStore(targetStoreFile, serverStore, sslMetadata.password);
            x509log.log(MessageFormat.format("New SSL certificate {0,number,0} [{1}]", cert.getSerialNumber(), cert.getSubjectDN().getName()));
            sslMetadata.serialNumber = cert.getSerialNumber().toString();
            return cert;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to generate SSL certificate!", t);
        }
    }

    public static X509Certificate newCertificateAuthority(X509Metadata metadata, File storeFile, X509Log x509log) {
        try {
            KeyPair caPair = X509Utils.newKeyPair();
            ContentSigner caSigner = new JcaContentSignerBuilder(SIGNING_ALGORITHM).setProvider(BC).build(caPair.getPrivate());
            X509Metadata caMetadata = metadata.clone("Gitblit Certificate Authority", metadata.password);
            X500Name issuerDN = X509Utils.buildDistinguishedName(caMetadata);
            JcaX509v3CertificateBuilder caBuilder = new JcaX509v3CertificateBuilder(issuerDN, BigInteger.valueOf(System.currentTimeMillis()), caMetadata.notBefore, caMetadata.notAfter, issuerDN, caPair.getPublic());
            JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
            caBuilder.addExtension(X509Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(caPair.getPublic()));
            caBuilder.addExtension(X509Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(caPair.getPublic()));
            caBuilder.addExtension(X509Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(true));
            caBuilder.addExtension(X509Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(134));
            JcaX509CertificateConverter converter = new JcaX509CertificateConverter().setProvider(BC);
            X509Certificate cert = converter.getCertificate(caBuilder.build(caSigner));
            cert.checkValidity(new Date());
            cert.verify(cert.getPublicKey());
            if (storeFile.exists()) {
                storeFile.delete();
            }
            KeyStore store = X509Utils.openKeyStore(storeFile, caMetadata.password);
            store.setKeyEntry("Gitblit Certificate Authority", caPair.getPrivate(), caMetadata.password.toCharArray(), new Certificate[]{cert});
            X509Utils.saveKeyStore(storeFile, store, caMetadata.password);
            x509log.log(MessageFormat.format("New CA certificate {0,number,0} [{1}]", cert.getSerialNumber(), cert.getIssuerDN().getName()));
            caMetadata.serialNumber = cert.getSerialNumber().toString();
            return cert;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to generate Gitblit CA certificate!", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void newCertificateRevocationList(File caRevocationList, File caKeystoreFile, String caKeystorePassword) {
        try {
            KeyStore store = X509Utils.openKeyStore(caKeystoreFile, caKeystorePassword);
            PrivateKey caPrivateKey = (PrivateKey)store.getKey("Gitblit Certificate Authority", caKeystorePassword.toCharArray());
            X509Certificate caCert = (X509Certificate)store.getCertificate("Gitblit Certificate Authority");
            X500Name issuerDN = new X500Name(PrincipalUtil.getIssuerX509Principal((X509Certificate)caCert).getName());
            X509v2CRLBuilder crlBuilder = new X509v2CRLBuilder(issuerDN, new Date());
            ContentSigner signer = new JcaContentSignerBuilder(SIGNING_ALGORITHM).setProvider(BC).build(caPrivateKey);
            X509CRLHolder crl = crlBuilder.build(signer);
            File tmpFile = new File(caRevocationList.getParentFile(), Long.toHexString(System.currentTimeMillis()) + ".tmp");
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(tmpFile);
                fos.write(crl.getEncoded());
                fos.flush();
                fos.close();
                if (caRevocationList.exists()) {
                    caRevocationList.delete();
                }
                tmpFile.renameTo(caRevocationList);
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
                if (tmpFile.exists()) {
                    tmpFile.delete();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create new certificate revocation list " + caRevocationList, e);
        }
    }

    public static void addTrustedCertificate(String alias, X509Certificate cert, File storeFile, String storePassword) {
        try {
            KeyStore store = X509Utils.openKeyStore(storeFile, storePassword);
            store.setCertificateEntry(alias, cert);
            X509Utils.saveKeyStore(storeFile, store, storePassword);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to import certificate into trust store " + storeFile, e);
        }
    }

    public static File newClientBundle(X509Metadata clientMetadata, File caKeystoreFile, String caKeystorePassword, X509Log x509log) {
        return X509Utils.newClientBundle(null, clientMetadata, caKeystoreFile, caKeystorePassword, x509log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File newClientBundle(UserModel user, X509Metadata clientMetadata, File caKeystoreFile, String caKeystorePassword, X509Log x509log) {
        try {
            KeyStore store = X509Utils.openKeyStore(caKeystoreFile, caKeystorePassword);
            PrivateKey caPrivateKey = (PrivateKey)store.getKey("Gitblit Certificate Authority", caKeystorePassword.toCharArray());
            X509Certificate caCert = (X509Certificate)store.getCertificate("Gitblit Certificate Authority");
            File targetFolder = new File(caKeystoreFile.getParentFile(), clientMetadata.commonName);
            X509Certificate cert = X509Utils.newClientCertificate(clientMetadata, caPrivateKey, caCert, targetFolder);
            x509log.log(MessageFormat.format("New client certificate {0,number,0} [{1}]", cert.getSerialNumber(), cert.getSubjectDN().getName()));
            String readme = null;
            String sInstructionsFileName = "instructions.tmpl";
            if (user == null) {
                readme = X509Utils.processTemplate(new File(caKeystoreFile.getParentFile(), sInstructionsFileName), clientMetadata);
            } else {
                File fileInstructionsTmp = null;
                fileInstructionsTmp = new File(caKeystoreFile.getParentFile(), sInstructionsFileName + "_" + user.getPreferences().getLocale());
                readme = fileInstructionsTmp.exists() ? X509Utils.processTemplate(fileInstructionsTmp, clientMetadata) : X509Utils.processTemplate(new File(caKeystoreFile.getParentFile(), sInstructionsFileName), clientMetadata);
            }
            File zipFile = new File(targetFolder, clientMetadata.commonName + ".zip");
            if (zipFile.exists()) {
                zipFile.delete();
            }
            try (ZipOutputStream zos = null;){
                File pemFile;
                zos = new ZipOutputStream(new FileOutputStream(zipFile));
                File p12File = new File(targetFolder, clientMetadata.commonName + ".p12");
                if (p12File.exists()) {
                    zos.putNextEntry(new ZipEntry(p12File.getName()));
                    zos.write(FileUtils.readContent(p12File));
                    zos.closeEntry();
                }
                if ((pemFile = new File(targetFolder, clientMetadata.commonName + ".pem")).exists()) {
                    zos.putNextEntry(new ZipEntry(pemFile.getName()));
                    zos.write(FileUtils.readContent(pemFile));
                    zos.closeEntry();
                }
                zos.putNextEntry(new ZipEntry(clientMetadata.commonName + ".cer"));
                zos.write(cert.getEncoded());
                zos.closeEntry();
                zos.putNextEntry(new ZipEntry("ca.cer"));
                zos.write(caCert.getEncoded());
                zos.closeEntry();
                if (readme != null) {
                    zos.putNextEntry(new ZipEntry("README.TXT"));
                    zos.write(readme.getBytes("UTF-8"));
                    zos.closeEntry();
                }
                zos.flush();
            }
            return zipFile;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to generate client bundle!", t);
        }
    }

    public static X509Certificate newClientCertificate(X509Metadata clientMetadata, PrivateKey caPrivateKey, X509Certificate caCert, File targetFolder) {
        try {
            String date;
            KeyPair pair = X509Utils.newKeyPair();
            X500Name userDN = X509Utils.buildDistinguishedName(clientMetadata);
            X500Name issuerDN = new X500Name(PrincipalUtil.getIssuerX509Principal((X509Certificate)caCert).getName());
            JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(issuerDN, BigInteger.valueOf(System.currentTimeMillis()), clientMetadata.notBefore, clientMetadata.notAfter, userDN, pair.getPublic());
            JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
            certBuilder.addExtension(X509Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(pair.getPublic()));
            certBuilder.addExtension(X509Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
            certBuilder.addExtension(X509Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(caCert.getPublicKey()));
            certBuilder.addExtension(X509Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(160));
            if (!StringUtils.isEmpty(clientMetadata.emailAddress)) {
                GeneralNames subjectAltName = new GeneralNames(new GeneralName(1, clientMetadata.emailAddress));
                certBuilder.addExtension(X509Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltName);
            }
            ContentSigner signer = new JcaContentSignerBuilder(SIGNING_ALGORITHM).setProvider(BC).build(caPrivateKey);
            X509Certificate userCert = new JcaX509CertificateConverter().setProvider(BC).getCertificate(certBuilder.build(signer));
            PKCS12BagAttributeCarrier bagAttr = (PKCS12BagAttributeCarrier)pair.getPrivate();
            bagAttr.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(pair.getPublic()));
            userCert.checkValidity();
            userCert.verify(caCert.getPublicKey());
            userCert.getIssuerDN().equals(caCert.getSubjectDN());
            X509Utils.verifyChain(userCert, caCert);
            targetFolder.mkdirs();
            String id = date = new SimpleDateFormat("yyyyMMdd").format(new Date());
            File certFile = new File(targetFolder, id + ".cer");
            int count = 0;
            while (certFile.exists()) {
                id = date + "_" + Character.toString((char)(97 + count));
                certFile = new File(targetFolder, id + ".cer");
                ++count;
            }
            File p12File = new File(targetFolder, clientMetadata.commonName + ".p12");
            if (p12File.exists()) {
                p12File.delete();
            }
            KeyStore userStore = X509Utils.openKeyStore(p12File, clientMetadata.password);
            userStore.setKeyEntry(MessageFormat.format("Gitblit ({0}) {1} {2}", clientMetadata.serverHostname, clientMetadata.userDisplayname, id), pair.getPrivate(), null, new Certificate[]{userCert});
            userStore.setCertificateEntry(MessageFormat.format("Gitblit ({0}) Certificate Authority", clientMetadata.serverHostname), caCert);
            X509Utils.saveKeyStore(p12File, userStore, clientMetadata.password);
            File pemFile = new File(targetFolder, clientMetadata.commonName + ".pem");
            if (pemFile.exists()) {
                pemFile.delete();
            }
            JcePEMEncryptorBuilder builder = new JcePEMEncryptorBuilder("DES-EDE3-CBC");
            builder.setSecureRandom(new SecureRandom());
            PEMEncryptor pemEncryptor = builder.build(clientMetadata.password.toCharArray());
            JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)new FileWriter(pemFile));
            pemWriter.writeObject((Object)pair.getPrivate(), pemEncryptor);
            pemWriter.writeObject((Object)userCert);
            pemWriter.writeObject((Object)caCert);
            pemWriter.flush();
            pemWriter.close();
            X509Utils.saveCertificate(userCert, certFile);
            clientMetadata.serialNumber = userCert.getSerialNumber().toString();
            return userCert;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to generate client certificate!", t);
        }
    }

    public static PKIXCertPathBuilderResult verifyChain(X509Certificate testCert, X509Certificate ... additionalCerts) {
        try {
            if (X509Utils.isSelfSigned(testCert)) {
                throw new RuntimeException("The certificate is self-signed.  Nothing to verify.");
            }
            HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
            certs.add(testCert);
            certs.addAll(Arrays.asList(additionalCerts));
            X509CertSelector selector = new X509CertSelector();
            selector.setCertificate(testCert);
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            for (X509Certificate cert : additionalCerts) {
                if (!X509Utils.isSelfSigned(cert)) continue;
                trustAnchors.add(new TrustAnchor(cert, null));
            }
            PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
            pkixParams.setRevocationEnabled(false);
            pkixParams.addCertStore(CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certs), BC));
            CertPathBuilder builder = CertPathBuilder.getInstance("PKIX", BC);
            PKIXCertPathBuilderResult verifiedCertChain = (PKIXCertPathBuilderResult)builder.build(pkixParams);
            return verifiedCertChain;
        }
        catch (CertPathBuilderException e) {
            throw new RuntimeException("Error building certification path: " + testCert.getSubjectX500Principal(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Error verifying the certificate: " + testCert.getSubjectX500Principal(), e);
        }
    }

    public static boolean isSelfSigned(X509Certificate cert) {
        try {
            cert.verify(cert.getPublicKey());
            return true;
        }
        catch (SignatureException e) {
            return false;
        }
        catch (InvalidKeyException e) {
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String processTemplate(File template, X509Metadata metadata) {
        String message;
        String content = null;
        if (template.exists() && !StringUtils.isEmpty(message = FileUtils.readContent(template, "\n"))) {
            content = message;
            if (!StringUtils.isEmpty(metadata.serverHostname)) {
                content = content.replace("$serverHostname", metadata.serverHostname);
            }
            if (!StringUtils.isEmpty(metadata.commonName)) {
                content = content.replace("$username", metadata.commonName);
            }
            if (!StringUtils.isEmpty(metadata.userDisplayname)) {
                content = content.replace("$userDisplayname", metadata.userDisplayname);
            }
            if (!StringUtils.isEmpty(metadata.passwordHint)) {
                content = content.replace("$storePasswordHint", metadata.passwordHint);
            }
        }
        return content;
    }

    public static boolean revoke(X509Certificate cert, RevocationReason reason, File caRevocationList, File caKeystoreFile, String caKeystorePassword, X509Log x509log) {
        try {
            KeyStore store = X509Utils.openKeyStore(caKeystoreFile, caKeystorePassword);
            PrivateKey caPrivateKey = (PrivateKey)store.getKey("Gitblit Certificate Authority", caKeystorePassword.toCharArray());
            return X509Utils.revoke(cert, reason, caRevocationList, caPrivateKey, x509log);
        }
        catch (Exception e) {
            logger.error(MessageFormat.format("Failed to revoke certificate {0,number,0} [{1}] in {2}", cert.getSerialNumber(), cert.getSubjectDN().getName(), caRevocationList));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean revoke(X509Certificate cert, RevocationReason reason, File caRevocationList, PrivateKey caPrivateKey, X509Log x509log) {
        try {
            X509CRLHolder crl;
            X500Name issuerDN = new X500Name(PrincipalUtil.getIssuerX509Principal((X509Certificate)cert).getName());
            X509v2CRLBuilder crlBuilder = new X509v2CRLBuilder(issuerDN, new Date());
            if (caRevocationList.exists()) {
                byte[] data = FileUtils.readContent(caRevocationList);
                crl = new X509CRLHolder(data);
                crlBuilder.addCRL(crl);
            }
            crlBuilder.addCRLEntry(cert.getSerialNumber(), new Date(), reason.ordinal());
            ContentSigner signer = new JcaContentSignerBuilder("SHA1WithRSA").setProvider(BC).build(caPrivateKey);
            crl = crlBuilder.build(signer);
            File tmpFile = new File(caRevocationList.getParentFile(), Long.toHexString(System.currentTimeMillis()) + ".tmp");
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(tmpFile);
                fos.write(crl.getEncoded());
                fos.flush();
                fos.close();
                if (caRevocationList.exists()) {
                    caRevocationList.delete();
                }
                tmpFile.renameTo(caRevocationList);
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
                if (tmpFile.exists()) {
                    tmpFile.delete();
                }
            }
            x509log.log(MessageFormat.format("Revoked certificate {0,number,0} reason: {1} [{2}]", cert.getSerialNumber(), reason.toString(), cert.getSubjectDN().getName()));
            return true;
        }
        catch (IOException | CertificateEncodingException | OperatorCreationException e) {
            logger.error(MessageFormat.format("Failed to revoke certificate {0,number,0} [{1}] in {2}", cert.getSerialNumber(), cert.getSubjectDN().getName(), caRevocationList));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRevoked(X509Certificate cert, File caRevocationList) {
        if (!caRevocationList.exists()) {
            return false;
        }
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(caRevocationList);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509CRL crl = (X509CRL)cf.generateCRL(inStream);
            boolean bl = crl.isRevoked(cert);
            return bl;
        }
        catch (Exception e) {
            logger.error(MessageFormat.format("Failed to check revocation status for certificate {0,number,0} [{1}] in {2}", cert.getSerialNumber(), cert.getSubjectDN().getName(), caRevocationList));
        }
        finally {
            if (inStream != null) {
                try {
                    ((InputStream)inStream).close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static X509Metadata getMetadata(X509Certificate cert) {
        HashMap<String, String> oids = new HashMap<String, String>();
        try {
            String dn = cert.getSubjectDN().getName();
            LdapName ldapName = new LdapName(dn);
            for (int i = 0; i < ldapName.size(); ++i) {
                String[] val = ldapName.get(i).trim().split("=", 2);
                String oid = val[0].toUpperCase().trim();
                String data = val[1].trim();
                oids.put(oid, data);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        X509Metadata metadata = new X509Metadata((String)oids.get("CN"), "whocares");
        metadata.oids.putAll(oids);
        metadata.serialNumber = cert.getSerialNumber().toString();
        metadata.notAfter = cert.getNotAfter();
        metadata.notBefore = cert.getNotBefore();
        metadata.emailAddress = metadata.getOID("E", null);
        if (metadata.emailAddress == null) {
            metadata.emailAddress = metadata.getOID("EMAILADDRESS", null);
        }
        return metadata;
    }

    static {
        logger = LoggerFactory.getLogger(X509Utils.class);
        Security.addProvider((Provider)new BouncyCastleProvider());
        int maxKeyLen = 0;
        try {
            maxKeyLen = Cipher.getMaxAllowedKeyLength("AES");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        boolean bl = unlimitedStrength = maxKeyLen > 128;
        if (unlimitedStrength) {
            logger.info("Using JCE Unlimited Strength Jurisdiction Policy files");
        } else {
            logger.info("Using JCE Standard Encryption Policy files, encryption key lengths will be limited");
        }
    }

    public static class X509Metadata {
        public final Map<String, String> oids;
        public final String commonName;
        public final String password;
        public String passwordHint;
        public String emailAddress;
        public Date notBefore;
        public Date notAfter;
        public String serverHostname;
        public String userDisplayname;
        public String serialNumber;

        public X509Metadata(String cn, String pwd) {
            if (StringUtils.isEmpty(cn)) {
                throw new RuntimeException("Common name required!");
            }
            if (StringUtils.isEmpty(pwd)) {
                throw new RuntimeException("Password required!");
            }
            this.commonName = cn;
            this.password = pwd;
            Calendar c = Calendar.getInstance(TimeZone.getDefault());
            c.set(13, 0);
            c.set(14, 0);
            this.notBefore = c.getTime();
            c.add(1, 1);
            c.add(5, 1);
            this.notAfter = c.getTime();
            this.oids = new HashMap<String, String>();
        }

        public X509Metadata clone(String commonName, String password) {
            X509Metadata clone = new X509Metadata(commonName, password);
            clone.emailAddress = this.emailAddress;
            clone.notBefore = this.notBefore;
            clone.notAfter = this.notAfter;
            clone.oids.putAll(this.oids);
            clone.passwordHint = this.passwordHint;
            clone.serverHostname = this.serverHostname;
            clone.userDisplayname = this.userDisplayname;
            return clone;
        }

        public String getOID(String oid, String defaultValue) {
            if (this.oids.containsKey(oid)) {
                return this.oids.get(oid);
            }
            return defaultValue;
        }

        public void setOID(String oid, String value) {
            if (StringUtils.isEmpty(value)) {
                this.oids.remove(oid);
            } else {
                this.oids.put(oid, value);
            }
        }
    }

    public static interface X509Log {
        public void log(String var1);
    }

    public static enum RevocationReason {
        unspecified,
        keyCompromise,
        caCompromise,
        affiliationChanged,
        superseded,
        cessationOfOperation,
        certificateHold,
        unused,
        removeFromCRL,
        privilegeWithdrawn,
        ACompromise;

        public static RevocationReason[] reasons;

        public String toString() {
            return this.name() + " (" + this.ordinal() + ")";
        }

        static {
            reasons = new RevocationReason[]{unspecified, keyCompromise, caCompromise, affiliationChanged, superseded, cessationOfOperation, privilegeWithdrawn};
        }
    }
}

