/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils.cli;

import com.google.common.base.Strings;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.IllegalAnnotationError;
import org.kohsuke.args4j.NamedOptionDef;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.BooleanOptionHandler;
import org.kohsuke.args4j.spi.EnumOptionHandler;
import org.kohsuke.args4j.spi.FieldSetter;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Setter;

public class CmdLineParser {
    private final MyParser parser;
    private Map<String, OptionHandler> options;

    public CmdLineParser(Object bean) throws IllegalAnnotationError {
        this.parser = new MyParser(bean);
    }

    public void addArgument(Setter<?> setter, Argument a) {
        this.parser.addArgument(setter, a);
    }

    public void addOption(Setter<?> setter, Option o) {
        this.parser.addOption(setter, o);
    }

    public void printSingleLineUsage(Writer w, ResourceBundle rb) {
        this.parser.printSingleLineUsage(w, rb);
    }

    public void printUsage(Writer out, ResourceBundle rb) {
        this.parser.printUsage(out, rb);
    }

    public void printDetailedUsage(String name, StringWriter out) {
        out.write(name);
        this.printSingleLineUsage(out, null);
        out.write(10);
        out.write(10);
        this.printUsage(out, null);
        out.write(10);
    }

    public void printQueryStringUsage(String name, StringWriter out) {
        out.write(name);
        int next = 63;
        ArrayList<NamedOptionDef> booleans = new ArrayList<NamedOptionDef>();
        for (OptionHandler handler : this.parser.options) {
            if (!(handler.option instanceof NamedOptionDef)) continue;
            NamedOptionDef n = (NamedOptionDef)handler.option;
            if (handler instanceof BooleanOptionHandler) {
                booleans.add(n);
                continue;
            }
            if (!n.required()) {
                out.write(91);
            }
            out.write(next);
            next = 38;
            if (n.name().startsWith("--")) {
                out.write(n.name().substring(2));
            } else if (n.name().startsWith("-")) {
                out.write(n.name().substring(1));
            } else {
                out.write(n.name());
            }
            out.write(61);
            out.write(CmdLineParser.metaVar(handler, n));
            if (!n.required()) {
                out.write(93);
            }
            if (!n.isMultiValued()) continue;
            out.write(42);
        }
        for (NamedOptionDef n : booleans) {
            if (!n.required()) {
                out.write(91);
            }
            out.write(next);
            next = 38;
            if (n.name().startsWith("--")) {
                out.write(n.name().substring(2));
            } else if (n.name().startsWith("-")) {
                out.write(n.name().substring(1));
            } else {
                out.write(n.name());
            }
            if (n.required()) continue;
            out.write(93);
        }
    }

    private static String metaVar(OptionHandler<?> handler, NamedOptionDef n) {
        String var = n.metaVar();
        if (Strings.isNullOrEmpty((String)var)) {
            var = handler.getDefaultMetaVariable();
            if (handler instanceof EnumOptionHandler) {
                var = var.substring(1, var.length() - 1).replace(" ", "");
            }
        }
        return var;
    }

    public boolean wasHelpRequestedByOption() {
        return this.parser.help.value;
    }

    public void parseArgument(String ... args) throws CmdLineException {
        ArrayList tmp = Lists.newArrayListWithCapacity((int)args.length);
        for (int argi = 0; argi < args.length; ++argi) {
            int eq;
            String str = args[argi];
            if (str.equals("--")) {
                while (argi < args.length) {
                    tmp.add(args[argi++]);
                }
                break;
            }
            if (str.startsWith("--") && (eq = str.indexOf(61)) > 0) {
                tmp.add(str.substring(0, eq));
                tmp.add(str.substring(eq + 1));
                continue;
            }
            tmp.add(str);
        }
        this.parser.parseArgument(tmp.toArray(new String[tmp.size()]));
    }

    public void parseOptionMap(Map<String, String[]> parameters) throws CmdLineException {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        for (Map.Entry<String, String[]> ent : parameters.entrySet()) {
            for (String val : ent.getValue()) {
                map.put((Object)ent.getKey(), (Object)val);
            }
        }
        this.parseOptionMap((Multimap<String, String>)map);
    }

    public void parseOptionMap(Multimap<String, String> params) throws CmdLineException {
        ArrayList tmp = Lists.newArrayListWithCapacity((int)(2 * params.size()));
        for (String key : params.keySet()) {
            String name = this.makeOption(key);
            if (this.isBoolean(name)) {
                boolean on = false;
                for (String value : params.get((Object)key)) {
                    on = this.toBoolean(key, value);
                }
                if (!on) continue;
                tmp.add(name);
                continue;
            }
            for (String value : params.get((Object)key)) {
                tmp.add(name);
                tmp.add(value);
            }
        }
        this.parser.parseArgument(tmp.toArray(new String[tmp.size()]));
    }

    public boolean isBoolean(String name) {
        return this.findHandler(this.makeOption(name)) instanceof BooleanOptionHandler;
    }

    private String makeOption(String name) {
        if (!name.startsWith("-")) {
            name = name.length() == 1 ? "-" + name : "--" + name;
        }
        return name;
    }

    private OptionHandler findHandler(String name) {
        if (this.options == null) {
            this.options = CmdLineParser.index(this.parser.options);
        }
        return this.options.get(name);
    }

    private static Map<String, OptionHandler> index(List<OptionHandler> in) {
        HashMap m = Maps.newHashMap();
        for (OptionHandler handler : in) {
            NamedOptionDef def;
            if (!(handler.option instanceof NamedOptionDef) || (def = (NamedOptionDef)handler.option).isArgument()) continue;
            m.put(def.name(), handler);
            for (String alias : def.aliases()) {
                m.put(alias, handler);
            }
        }
        return m;
    }

    private boolean toBoolean(String name, String value) throws CmdLineException {
        if ("true".equals(value) || "t".equals(value) || "yes".equals(value) || "y".equals(value) || "on".equals(value) || "1".equals(value) || value == null || "".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "f".equals(value) || "no".equals(value) || "n".equals(value) || "off".equals(value) || "0".equals(value)) {
            return false;
        }
        throw new CmdLineException((org.kohsuke.args4j.CmdLineParser)this.parser, String.format("invalid boolean \"%s=%s\"", name, value));
    }

    private static class HelpOption
    implements Option,
    Setter<Boolean> {
        private boolean value;

        private HelpOption() {
        }

        public String name() {
            return "--help";
        }

        public String[] aliases() {
            return new String[]{"-h"};
        }

        public String[] depends() {
            return new String[0];
        }

        public boolean hidden() {
            return false;
        }

        public String usage() {
            return "display this help text";
        }

        public void addValue(Boolean val) {
            this.value = val;
        }

        public Class<? extends OptionHandler<Boolean>> handler() {
            return BooleanOptionHandler.class;
        }

        public String metaVar() {
            return "";
        }

        public boolean required() {
            return false;
        }

        public Class<? extends Annotation> annotationType() {
            return Option.class;
        }

        public FieldSetter asFieldSetter() {
            throw new UnsupportedOperationException();
        }

        public AnnotatedElement asAnnotatedElement() {
            throw new UnsupportedOperationException();
        }

        public Class<Boolean> getType() {
            return Boolean.class;
        }

        public boolean isMultiValued() {
            return false;
        }

        public boolean help() {
            return true;
        }

        public String[] forbids() {
            return new String[0];
        }
    }

    private class MyParser
    extends org.kohsuke.args4j.CmdLineParser {
        private List<OptionHandler> options;
        private HelpOption help;

        MyParser(Object bean) {
            super(bean);
            this.ensureOptionsInitialized();
        }

        protected OptionHandler createOptionHandler(OptionDef option, Setter setter) {
            if (this.isHandlerSpecified(option) || this.isEnum(setter) || this.isPrimitive(setter)) {
                return this.add(super.createOptionHandler(option, setter));
            }
            return this.add(super.createOptionHandler(option, setter));
        }

        private OptionHandler add(OptionHandler handler) {
            this.ensureOptionsInitialized();
            this.options.add(handler);
            return handler;
        }

        private void ensureOptionsInitialized() {
            if (this.options == null) {
                this.help = new HelpOption();
                this.options = Lists.newArrayList();
                this.addOption(this.help, this.help);
            }
        }

        private boolean isHandlerSpecified(OptionDef option) {
            return option.handler() != OptionHandler.class;
        }

        private <T> boolean isEnum(Setter<T> setter) {
            return Enum.class.isAssignableFrom(setter.getType());
        }

        private <T> boolean isPrimitive(Setter<T> setter) {
            return setter.getType().isPrimitive();
        }
    }

    public static interface Factory {
        public CmdLineParser create(Object var1);
    }
}

