/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket;

import com.gitblit.IStoredSettings;
import com.gitblit.models.UserModel;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.RequiresAdminRole;
import com.gitblit.wicket.pages.BasePage;
import org.apache.wicket.Component;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.authorization.strategies.page.AbstractPageAuthorizationStrategy;
import org.apache.wicket.markup.html.WebPage;

public class AuthorizationStrategy
extends AbstractPageAuthorizationStrategy
implements IUnauthorizedComponentInstantiationListener {
    IStoredSettings settings;
    Class<? extends WebPage> homepageClass;

    public AuthorizationStrategy(IStoredSettings settings, Class<? extends WebPage> homepageClass) {
        this.settings = settings;
        this.homepageClass = homepageClass;
    }

    protected boolean isPageAuthorized(Class pageClass) {
        if (this.homepageClass.equals(pageClass)) {
            return true;
        }
        if (BasePage.class.isAssignableFrom(pageClass)) {
            boolean authenticateView = this.settings.getBoolean("web.authenticateViewPages", true);
            boolean authenticateAdmin = this.settings.getBoolean("web.authenticateAdminPages", true);
            boolean allowAdmin = this.settings.getBoolean("web.allowAdministration", true);
            GitBlitWebSession session = GitBlitWebSession.get();
            if (authenticateView && !session.isLoggedIn()) {
                session.cacheRequest(pageClass);
                return false;
            }
            UserModel user = session.getUser();
            if (pageClass.isAnnotationPresent(RequiresAdminRole.class)) {
                if (allowAdmin) {
                    if (authenticateAdmin) {
                        if (user != null) {
                            return user.canAdmin();
                        }
                        return false;
                    }
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public void onUnauthorizedInstantiation(Component component) {
        if (component instanceof BasePage) {
            throw new RestartResponseException(this.homepageClass);
        }
    }
}

