/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket;

import com.gitblit.models.FilestoreModel;
import com.gitblit.wicket.WicketUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;

public class FilestoreUI {
    public static Label getStatusIcon(String wicketId, FilestoreModel item) {
        return FilestoreUI.getStatusIcon(wicketId, item.getStatus());
    }

    public static Label getStatusIcon(String wicketId, FilestoreModel.Status status) {
        Label label = new Label(wicketId);
        switch (status) {
            case Upload_Pending: {
                WicketUtils.setCssClass((Component)label, "fa fa-spinner fa-fw file-negative");
                break;
            }
            case Upload_In_Progress: {
                WicketUtils.setCssClass((Component)label, "fa fa-spinner fa-spin fa-fw file-positive");
                break;
            }
            case Available: {
                WicketUtils.setCssClass((Component)label, "fa fa-check fa-fw file-positive");
                break;
            }
            case Deleted: {
                WicketUtils.setCssClass((Component)label, "fa fa-ban fa-fw file-negative");
                break;
            }
            case Unavailable: {
                WicketUtils.setCssClass((Component)label, "fa fa-times fa-fw file-negative");
                break;
            }
            default: {
                WicketUtils.setCssClass((Component)label, "fa fa-exclamation-triangle fa-fw file-negative");
            }
        }
        WicketUtils.setHtmlTooltip((Component)label, status.toString());
        return label;
    }
}

