/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket;

import com.gitblit.IStoredSettings;
import com.gitblit.extensions.GitblitWicketPlugin;
import com.gitblit.manager.IAuthenticationManager;
import com.gitblit.manager.IFederationManager;
import com.gitblit.manager.IFilestoreManager;
import com.gitblit.manager.IGitblit;
import com.gitblit.manager.INotificationManager;
import com.gitblit.manager.IPluginManager;
import com.gitblit.manager.IProjectManager;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.manager.IServicesManager;
import com.gitblit.manager.IUserManager;
import com.gitblit.tickets.ITicketService;
import com.gitblit.transport.ssh.IPublicKeyManager;
import com.gitblit.utils.XssFilter;
import com.gitblit.wicket.AuthorizationStrategy;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.GitblitParamUrlCodingStrategy;
import com.gitblit.wicket.GitblitWicketApp;
import com.gitblit.wicket.PluginClassResolver;
import com.gitblit.wicket.pages.ActivityPage;
import com.gitblit.wicket.pages.BlamePage;
import com.gitblit.wicket.pages.BlobDiffPage;
import com.gitblit.wicket.pages.BlobPage;
import com.gitblit.wicket.pages.BranchesPage;
import com.gitblit.wicket.pages.CommitDiffPage;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.ComparePage;
import com.gitblit.wicket.pages.DocPage;
import com.gitblit.wicket.pages.DocsPage;
import com.gitblit.wicket.pages.EditFilePage;
import com.gitblit.wicket.pages.EditMilestonePage;
import com.gitblit.wicket.pages.EditRepositoryPage;
import com.gitblit.wicket.pages.EditTicketPage;
import com.gitblit.wicket.pages.ExportTicketPage;
import com.gitblit.wicket.pages.FederationRegistrationPage;
import com.gitblit.wicket.pages.FilestorePage;
import com.gitblit.wicket.pages.ForkPage;
import com.gitblit.wicket.pages.ForksPage;
import com.gitblit.wicket.pages.GitSearchPage;
import com.gitblit.wicket.pages.HistoryPage;
import com.gitblit.wicket.pages.LogPage;
import com.gitblit.wicket.pages.LogoutPage;
import com.gitblit.wicket.pages.LuceneSearchPage;
import com.gitblit.wicket.pages.MetricsPage;
import com.gitblit.wicket.pages.MyDashboardPage;
import com.gitblit.wicket.pages.MyTicketsPage;
import com.gitblit.wicket.pages.NewMilestonePage;
import com.gitblit.wicket.pages.NewRepositoryPage;
import com.gitblit.wicket.pages.NewTicketPage;
import com.gitblit.wicket.pages.OverviewPage;
import com.gitblit.wicket.pages.PatchPage;
import com.gitblit.wicket.pages.ProjectPage;
import com.gitblit.wicket.pages.ProjectsPage;
import com.gitblit.wicket.pages.ReflogPage;
import com.gitblit.wicket.pages.RepositoriesPage;
import com.gitblit.wicket.pages.ReviewProposalPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.pages.TagPage;
import com.gitblit.wicket.pages.TagsPage;
import com.gitblit.wicket.pages.TeamsPage;
import com.gitblit.wicket.pages.TicketsPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.pages.UserPage;
import com.gitblit.wicket.pages.UsersPage;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.wicket.Application;
import org.apache.wicket.Request;
import org.apache.wicket.Response;
import org.apache.wicket.Session;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.target.coding.IRequestTargetUrlCodingStrategy;
import ro.fortsoft.pf4j.PluginState;
import ro.fortsoft.pf4j.PluginWrapper;

@Singleton
public class GitBlitWebApp
extends WebApplication
implements GitblitWicketApp {
    private final Class<? extends WebPage> homePageClass = MyDashboardPage.class;
    private final Class<? extends WebPage> newRepositoryPageClass = NewRepositoryPage.class;
    private final Map<String, CacheControl> cacheablePages = new HashMap<String, CacheControl>();
    private final Provider<IPublicKeyManager> publicKeyManagerProvider;
    private final Provider<ITicketService> ticketServiceProvider;
    private final IStoredSettings settings;
    private final XssFilter xssFilter;
    private final IRuntimeManager runtimeManager;
    private final IPluginManager pluginManager;
    private final INotificationManager notificationManager;
    private final IUserManager userManager;
    private final IAuthenticationManager authenticationManager;
    private final IRepositoryManager repositoryManager;
    private final IProjectManager projectManager;
    private final IFederationManager federationManager;
    private final IGitblit gitblit;
    private final IServicesManager services;
    private final IFilestoreManager filestoreManager;

    @Inject
    public GitBlitWebApp(Provider<IPublicKeyManager> publicKeyManagerProvider, Provider<ITicketService> ticketServiceProvider, IRuntimeManager runtimeManager, IPluginManager pluginManager, INotificationManager notificationManager, IUserManager userManager, IAuthenticationManager authenticationManager, IRepositoryManager repositoryManager, IProjectManager projectManager, IFederationManager federationManager, IGitblit gitblit, IServicesManager services, IFilestoreManager filestoreManager) {
        this.publicKeyManagerProvider = publicKeyManagerProvider;
        this.ticketServiceProvider = ticketServiceProvider;
        this.settings = runtimeManager.getSettings();
        this.xssFilter = runtimeManager.getXssFilter();
        this.runtimeManager = runtimeManager;
        this.pluginManager = pluginManager;
        this.notificationManager = notificationManager;
        this.userManager = userManager;
        this.authenticationManager = authenticationManager;
        this.repositoryManager = repositoryManager;
        this.projectManager = projectManager;
        this.federationManager = federationManager;
        this.gitblit = gitblit;
        this.services = services;
        this.filestoreManager = filestoreManager;
    }

    public void init() {
        boolean useAuthentication;
        super.init();
        boolean bl = useAuthentication = this.settings.getBoolean("web.authenticateViewPages", false) || this.settings.getBoolean("web.authenticateAdminPages", false);
        if (useAuthentication) {
            AuthorizationStrategy authStrategy = new AuthorizationStrategy(this.settings, this.homePageClass);
            this.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)authStrategy);
            this.getSecuritySettings().setUnauthorizedComponentInstantiationListener((IUnauthorizedComponentInstantiationListener)authStrategy);
        }
        if (this.settings.getBoolean("web.useClientTimezone", false)) {
            this.getRequestCycleSettings().setGatherExtendedBrowserInfo(true);
        }
        if (!this.isDebugMode()) {
            this.getResourceSettings().setDefaultCacheDuration(7776000);
        }
        this.mount("/repositories", RepositoriesPage.class, new String[0]);
        this.mount("/overview", OverviewPage.class, "r");
        this.mount("/summary", SummaryPage.class, "r");
        this.mount("/reflog", ReflogPage.class, "r");
        this.mount("/commits", LogPage.class, "r", "h");
        this.mount("/log", LogPage.class, "r", "h");
        this.mount("/tags", TagsPage.class, "r");
        this.mount("/branches", BranchesPage.class, "r");
        this.mount("/commit", CommitPage.class, "r", "h");
        this.mount("/tag", TagPage.class, "r", "h");
        this.mount("/tree", TreePage.class, "r", "h", "f");
        this.mount("/blob", BlobPage.class, "r", "h", "f");
        this.mount("/blobdiff", BlobDiffPage.class, "r", "h", "f");
        this.mount("/commitdiff", CommitDiffPage.class, "r", "h");
        this.mount("/compare", ComparePage.class, "r", "h");
        this.mount("/patch", PatchPage.class, "r", "h", "f");
        this.mount("/history", HistoryPage.class, "r", "h", "f");
        this.mount("/search", GitSearchPage.class, new String[0]);
        this.mount("/metrics", MetricsPage.class, "r");
        this.mount("/blame", BlamePage.class, "r", "h", "f");
        this.mount("/users", UsersPage.class, new String[0]);
        this.mount("/teams", TeamsPage.class, new String[0]);
        this.mount("/logout", LogoutPage.class, new String[0]);
        this.mount("/tickets", TicketsPage.class, "r", "h");
        this.mount("/tickets/new", NewTicketPage.class, "r");
        this.mount("/tickets/edit", EditTicketPage.class, "r", "h");
        this.mount("/tickets/export", ExportTicketPage.class, "r", "h");
        this.mount("/milestones/new", NewMilestonePage.class, "r");
        this.mount("/milestones/edit", EditMilestonePage.class, "r", "h");
        this.mount("/mytickets", MyTicketsPage.class, "r", "h");
        this.mount("/docs", DocsPage.class, "r", "h");
        this.mount("/doc", DocPage.class, "r", "h", "f");
        this.mount("/editfile", EditFilePage.class, "r", "h", "f");
        this.mount("/proposal", ReviewProposalPage.class, "t");
        this.mount("/registration", FederationRegistrationPage.class, "u", "n");
        this.mount("/new", NewRepositoryPage.class, new String[0]);
        this.mount("/edit", EditRepositoryPage.class, "r");
        this.mount("/activity", ActivityPage.class, "r", "h");
        this.mount("/lucene", LuceneSearchPage.class, new String[0]);
        this.mount("/project", ProjectPage.class, "p");
        this.mount("/projects", ProjectsPage.class, new String[0]);
        this.mount("/user", UserPage.class, "user");
        this.mount("/forks", ForksPage.class, "r");
        this.mount("/fork", ForkPage.class, "r");
        this.mount("/filestore", FilestorePage.class, new String[0]);
        for (PluginWrapper pluginWrapper : this.pluginManager.getPlugins()) {
            if (PluginState.STARTED != pluginWrapper.getPluginState() || !(pluginWrapper.getPlugin() instanceof GitblitWicketPlugin)) continue;
            GitblitWicketPlugin wicketPlugin = (GitblitWicketPlugin)pluginWrapper.getPlugin();
            wicketPlugin.init((Application)this);
        }
        IClassResolver coreResolver = this.getApplicationSettings().getClassResolver();
        PluginClassResolver classResolver = new PluginClassResolver(coreResolver, this.pluginManager);
        this.getApplicationSettings().setClassResolver((IClassResolver)classResolver);
        this.getMarkupSettings().setDefaultMarkupEncoding("UTF-8");
    }

    @Override
    public void mount(String location, Class<? extends WebPage> clazz, String ... parameters) {
        if (parameters == null) {
            parameters = new String[]{};
        }
        if (!this.settings.getBoolean("web.mountParameters", true)) {
            parameters = new String[]{};
        }
        this.mount((IRequestTargetUrlCodingStrategy)new GitblitParamUrlCodingStrategy(this.settings, this.xssFilter, location, clazz, parameters));
        if (clazz.isAnnotationPresent(CacheControl.class)) {
            CacheControl cacheControl = clazz.getAnnotation(CacheControl.class);
            this.cacheablePages.put(location.substring(1), cacheControl);
        }
    }

    @Override
    public Class<? extends WebPage> getHomePage() {
        return this.homePageClass;
    }

    public Class<? extends WebPage> getNewRepositoryPage() {
        return this.newRepositoryPageClass;
    }

    @Override
    public boolean isCacheablePage(String mountPoint) {
        return this.cacheablePages.containsKey(mountPoint);
    }

    @Override
    public CacheControl getCacheControl(String mountPoint) {
        return this.cacheablePages.get(mountPoint);
    }

    public final Session newSession(Request request, Response response) {
        GitBlitWebSession gitBlitWebSession = new GitBlitWebSession(request);
        Locale forcedLocale = this.runtime().getLocale();
        if (forcedLocale != null) {
            gitBlitWebSession.setLocale(forcedLocale);
        }
        return gitBlitWebSession;
    }

    @Override
    public IStoredSettings settings() {
        return this.settings;
    }

    @Override
    public XssFilter xssFilter() {
        return this.xssFilter;
    }

    @Override
    public boolean isDebugMode() {
        return this.runtimeManager.isDebugMode();
    }

    @Override
    public Date getBootDate() {
        return this.runtimeManager.getBootDate();
    }

    @Override
    public Date getLastActivityDate() {
        return this.repositoryManager.getLastActivityDate();
    }

    @Override
    public IRuntimeManager runtime() {
        return this.runtimeManager;
    }

    @Override
    public IPluginManager plugins() {
        return this.pluginManager;
    }

    @Override
    public INotificationManager notifier() {
        return this.notificationManager;
    }

    @Override
    public IUserManager users() {
        return this.userManager;
    }

    @Override
    public IAuthenticationManager authentication() {
        return this.authenticationManager;
    }

    @Override
    public IPublicKeyManager keys() {
        return (IPublicKeyManager)this.publicKeyManagerProvider.get();
    }

    @Override
    public IRepositoryManager repositories() {
        return this.repositoryManager;
    }

    @Override
    public IProjectManager projects() {
        return this.projectManager;
    }

    @Override
    public IFederationManager federation() {
        return this.federationManager;
    }

    @Override
    public IGitblit gitblit() {
        return this.gitblit;
    }

    @Override
    public IServicesManager services() {
        return this.services;
    }

    @Override
    public ITicketService tickets() {
        return (ITicketService)this.ticketServiceProvider.get();
    }

    @Override
    public TimeZone getTimezone() {
        return this.runtimeManager.getTimezone();
    }

    public final String getConfigurationType() {
        if (this.runtimeManager.isDebugMode()) {
            return "development";
        }
        return "deployment";
    }

    public static GitBlitWebApp get() {
        return (GitBlitWebApp)WebApplication.get();
    }

    @Override
    public IFilestoreManager filestore() {
        return this.filestoreManager;
    }
}

