/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket;

import com.gitblit.IStoredSettings;
import com.gitblit.manager.IProjectManager;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.models.ProjectModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.GitBlitWebApp;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.protocol.http.IWebApplicationFactory;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.util.string.Strings;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

@Singleton
public class GitblitWicketFilter
extends WicketFilter {
    private IStoredSettings settings;
    private IRuntimeManager runtimeManager;
    private IRepositoryManager repositoryManager;
    private IProjectManager projectManager;
    private GitBlitWebApp webapp;

    @Inject
    public GitblitWicketFilter(IStoredSettings settings, IRuntimeManager runtimeManager, IRepositoryManager repositoryManager, IProjectManager projectManager, GitBlitWebApp webapp) {
        this.settings = settings;
        this.runtimeManager = runtimeManager;
        this.repositoryManager = repositoryManager;
        this.projectManager = projectManager;
        this.webapp = webapp;
    }

    protected IWebApplicationFactory getApplicationFactory() {
        return new IWebApplicationFactory(){

            public WebApplication createApplication(WicketFilter filter) {
                return GitblitWicketFilter.this.webapp;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLastModified(HttpServletRequest servletRequest) {
        String pathInfo = this.getRelativePath(servletRequest);
        if (Strings.isEmpty((CharSequence)pathInfo)) {
            return -1L;
        }
        long lastModified = super.getLastModified(servletRequest);
        if (lastModified > -1L) {
            return lastModified;
        }
        String[] paths = pathInfo.split("/");
        String page = paths[0];
        String repo = "";
        String commitId = "";
        if (paths.length >= 2) {
            repo = paths[1];
        }
        if (paths.length >= 3) {
            commitId = paths[2];
        }
        if (!StringUtils.isEmpty(servletRequest.getParameter("r"))) {
            repo = servletRequest.getParameter("r");
        }
        if (!StringUtils.isEmpty(servletRequest.getParameter("h"))) {
            commitId = servletRequest.getParameter("h");
        }
        repo = repo.replace("%2f", "/").replace("%2F", "/").replace(this.settings.getChar("web.forwardSlashCharacter", '/'), '/');
        GitBlitWebApp app = (GitBlitWebApp)this.getWebApplication();
        int expires = this.settings.getInteger("web.pageCacheExpires", 0);
        if (!StringUtils.isEmpty(page) && app.isCacheablePage(page) && expires > 0) {
            CacheControl cacheControl = app.getCacheControl(page);
            Date bootDate = this.runtimeManager.getBootDate();
            switch (cacheControl.value()) {
                case ACTIVITY: {
                    Date activityDate = this.repositoryManager.getLastActivityDate();
                    if (activityDate != null) {
                        return activityDate.after(bootDate) ? activityDate.getTime() : bootDate.getTime();
                    }
                    return bootDate.getTime();
                }
                case BOOT: {
                    return bootDate.getTime();
                }
                case PROJECT: {
                    ProjectModel project = this.projectManager.getProjectModel(StringUtils.getRootPath(repo));
                    if (project == null) break;
                    return project.lastChange.after(bootDate) ? project.lastChange.getTime() : bootDate.getTime();
                }
                case REPOSITORY: {
                    RepositoryModel repository = this.repositoryManager.getRepositoryModel(repo);
                    if (repository == null || repository.lastChange == null) break;
                    return repository.lastChange.after(bootDate) ? repository.lastChange.getTime() : bootDate.getTime();
                }
                case COMMIT: {
                    if (StringUtils.isEmpty(commitId)) {
                        return bootDate.getTime();
                    }
                    try (Repository r = null;){
                        RevCommit commit;
                        r = this.repositoryManager.getRepository(repo);
                        if (r != null && (commit = JGitUtils.getCommit(r, commitId)) != null) {
                            Date date = JGitUtils.getCommitDate(commit);
                            long l = date.after(bootDate) ? date.getTime() : bootDate.getTime();
                            return l;
                        }
                        break;
                    }
                }
            }
        }
        return -1L;
    }
}

