/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket;

import com.gitblit.IStoredSettings;
import com.gitblit.models.PathModel;
import com.gitblit.servlet.RawServlet;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.MarkdownUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.XssFilter;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.DocPage;
import com.google.common.base.Joiner;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.mylyn.wikitext.confluence.core.ConfluenceLanguage;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.mediawiki.core.MediaWikiLanguage;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;
import org.eclipse.mylyn.wikitext.tracwiki.core.TracWikiLanguage;
import org.eclipse.mylyn.wikitext.twiki.core.TWikiLanguage;
import org.pegdown.DefaultVerbatimSerializer;
import org.pegdown.FastEncoder;
import org.pegdown.LinkRenderer;
import org.pegdown.ToHtmlSerializer;
import org.pegdown.ast.ExpImageNode;
import org.pegdown.ast.RefImageNode;
import org.pegdown.ast.WikiLinkNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkupProcessor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IStoredSettings settings;
    private final XssFilter xssFilter;

    public static List<String> getMarkupExtensions(IStoredSettings settings) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(settings.getStrings("web.confluenceExtensions"));
        list.addAll(settings.getStrings("web.markdownExtensions"));
        list.addAll(settings.getStrings("web.mediawikiExtensions"));
        list.addAll(settings.getStrings("web.textileExtensions"));
        list.addAll(settings.getStrings("web.tracwikiExtensions"));
        list.addAll(settings.getStrings("web.twikiExtensions"));
        return list;
    }

    public MarkupProcessor(IStoredSettings settings, XssFilter xssFilter) {
        this.settings = settings;
        this.xssFilter = xssFilter;
    }

    public List<String> getMarkupExtensions() {
        return MarkupProcessor.getMarkupExtensions(this.settings);
    }

    public List<String> getAllExtensions() {
        List<String> list = MarkupProcessor.getMarkupExtensions(this.settings);
        list.add("txt");
        list.add("TXT");
        return list;
    }

    private List<String> getRoots() {
        return this.settings.getStrings("web.documents");
    }

    private String[] getEncodings() {
        return this.settings.getStrings("web.blobEncodings").toArray(new String[0]);
    }

    private MarkupSyntax determineSyntax(String documentPath) {
        String ext = StringUtils.getFileExtension(documentPath).toLowerCase();
        if (StringUtils.isEmpty(ext)) {
            return MarkupSyntax.PLAIN;
        }
        if (this.settings.getStrings("web.confluenceExtensions").contains(ext)) {
            return MarkupSyntax.CONFLUENCE;
        }
        if (this.settings.getStrings("web.markdownExtensions").contains(ext)) {
            return MarkupSyntax.MARKDOWN;
        }
        if (this.settings.getStrings("web.mediawikiExtensions").contains(ext)) {
            return MarkupSyntax.MEDIAWIKI;
        }
        if (this.settings.getStrings("web.textileExtensions").contains(ext)) {
            return MarkupSyntax.TEXTILE;
        }
        if (this.settings.getStrings("web.tracwikiExtensions").contains(ext)) {
            return MarkupSyntax.TRACWIKI;
        }
        if (this.settings.getStrings("web.twikiExtensions").contains(ext)) {
            return MarkupSyntax.TWIKI;
        }
        return MarkupSyntax.PLAIN;
    }

    public boolean hasRootDocs(Repository r) {
        List<String> roots = this.getRoots();
        List<String> extensions = this.getAllExtensions();
        List<PathModel> paths = JGitUtils.getFilesInPath(r, null, null);
        for (PathModel path : paths) {
            if (path.isTree()) continue;
            String ext = StringUtils.getFileExtension(path.name).toLowerCase();
            String name = StringUtils.stripFileExtension(path.name).toLowerCase();
            if (!roots.contains(name) || !StringUtils.isEmpty(ext) && !extensions.contains(ext)) continue;
            return true;
        }
        return false;
    }

    public List<MarkupDocument> getRootDocs(Repository r, String repositoryName, String commitId) {
        List<String> roots = this.getRoots();
        List<MarkupDocument> list = this.getDocs(r, repositoryName, commitId, roots);
        return list;
    }

    public MarkupDocument getReadme(Repository r, String repositoryName, String commitId) {
        List<MarkupDocument> list = this.getDocs(r, repositoryName, commitId, Arrays.asList("readme"));
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private List<MarkupDocument> getDocs(Repository r, String repositoryName, String commitId, List<String> names) {
        List<String> extensions = this.getAllExtensions();
        String[] encodings = this.getEncodings();
        HashMap<String, MarkupDocument> map = new HashMap<String, MarkupDocument>();
        RevCommit commit = JGitUtils.getCommit(r, commitId);
        List<PathModel> paths = JGitUtils.getFilesInPath(r, null, commit);
        for (PathModel path : paths) {
            if (path.isTree()) continue;
            String ext = StringUtils.getFileExtension(path.name).toLowerCase();
            String name = StringUtils.stripFileExtension(path.name).toLowerCase();
            if (!names.contains(name) || !StringUtils.isEmpty(ext) && !extensions.contains(ext)) continue;
            String markup = JGitUtils.getStringContent(r, commit.getTree(), path.name, encodings);
            MarkupDocument doc = this.parse(repositoryName, commitId, path.name, markup);
            map.put(name, doc);
        }
        ArrayList<MarkupDocument> list = new ArrayList<MarkupDocument>();
        for (String name : names) {
            if (!map.containsKey(name)) continue;
            list.add((MarkupDocument)map.get(name));
        }
        return list;
    }

    public MarkupDocument parse(String repositoryName, String commitId, String documentPath, String markupText) {
        MarkupSyntax syntax = this.determineSyntax(documentPath);
        MarkupDocument doc = new MarkupDocument(documentPath, markupText, syntax);
        if (markupText != null) {
            try {
                switch (syntax) {
                    case CONFLUENCE: {
                        this.parse(doc, repositoryName, commitId, (MarkupLanguage)new ConfluenceLanguage());
                        break;
                    }
                    case MARKDOWN: {
                        this.parse(doc, repositoryName, commitId);
                        break;
                    }
                    case MEDIAWIKI: {
                        this.parse(doc, repositoryName, commitId, (MarkupLanguage)new MediaWikiLanguage());
                        break;
                    }
                    case TEXTILE: {
                        this.parse(doc, repositoryName, commitId, (MarkupLanguage)new TextileLanguage());
                        break;
                    }
                    case TRACWIKI: {
                        this.parse(doc, repositoryName, commitId, (MarkupLanguage)new TracWikiLanguage());
                        break;
                    }
                    case TWIKI: {
                        this.parse(doc, repositoryName, commitId, (MarkupLanguage)new TWikiLanguage());
                        break;
                    }
                    default: {
                        doc.html = MarkdownUtils.transformPlainText(markupText);
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("failed to transform " + (Object)((Object)syntax), (Throwable)e);
            }
        }
        if (doc.html == null) {
            if (markupText == null) {
                markupText = String.format("Document <b>%1$s</b> not found in <em>%2$s</em>", documentPath, repositoryName);
            }
            markupText = MessageFormat.format("<div class=\"alert alert-error\"><strong>{0}:</strong> {1}</div>{2}", "Error", "failed to parse markup", markupText);
            doc.html = StringUtils.breakLinesForHtml(markupText);
        }
        return doc;
    }

    private void parse(final MarkupDocument doc, final String repositoryName, final String commitId, MarkupLanguage lang) {
        String safeContent;
        StringWriter writer = new StringWriter();
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder(writer){

            public void image(Attributes attributes, String imagePath) {
                String url;
                if (imagePath.indexOf("://") == -1) {
                    String path = doc.getRelativePath(imagePath);
                    String contextUrl = RequestCycle.get().getRequest().getRelativePathPrefixToContextRoot();
                    url = RawServlet.asLink(contextUrl, repositoryName, commitId, path);
                } else {
                    url = imagePath;
                }
                super.image(attributes, url);
            }

            public void link(Attributes attributes, String hrefOrHashName, String text) {
                String url;
                if (hrefOrHashName.charAt(0) != '#') {
                    if (hrefOrHashName.indexOf("://") == -1) {
                        String path = doc.getRelativePath(hrefOrHashName);
                        url = MarkupProcessor.this.getWicketUrl(DocPage.class, repositoryName, commitId, path);
                    } else {
                        url = hrefOrHashName;
                    }
                } else {
                    url = hrefOrHashName;
                }
                super.link(attributes, url, text);
            }
        };
        builder.setEmitAsDocument(false);
        MarkupParser parser = new MarkupParser(lang);
        parser.setBuilder((DocumentBuilder)builder);
        parser.parse(doc.markup);
        String content = writer.toString();
        doc.html = safeContent = this.xssFilter.relaxed(content);
    }

    private void parse(final MarkupDocument doc, final String repositoryName, final String commitId) {
        String safeContent;
        LinkRenderer renderer = new LinkRenderer(){

            public LinkRenderer.Rendering render(ExpImageNode node, String text) {
                if (node.url.indexOf("://") == -1) {
                    String path = doc.getRelativePath(node.url);
                    String contextUrl = RequestCycle.get().getRequest().getRelativePathPrefixToContextRoot();
                    String url = RawServlet.asLink(contextUrl, repositoryName, commitId, path);
                    return new LinkRenderer.Rendering(url, text);
                }
                return new LinkRenderer.Rendering(node.url, text);
            }

            public LinkRenderer.Rendering render(RefImageNode node, String url, String title, String alt) {
                LinkRenderer.Rendering rendering;
                if (url.indexOf("://") == -1) {
                    String path = doc.getRelativePath(url);
                    String contextUrl = RequestCycle.get().getRequest().getRelativePathPrefixToContextRoot();
                    String wurl = RawServlet.asLink(contextUrl, repositoryName, commitId, path);
                    rendering = new LinkRenderer.Rendering(wurl, alt);
                } else {
                    rendering = new LinkRenderer.Rendering(url, alt);
                }
                return StringUtils.isEmpty(title) ? rendering : rendering.withAttribute("title", FastEncoder.encode((String)title));
            }

            public LinkRenderer.Rendering render(WikiLinkNode node) {
                String path = doc.getRelativePath(node.getText());
                String name = MarkupProcessor.this.getDocumentName(path);
                String url = MarkupProcessor.this.getWicketUrl(DocPage.class, repositoryName, commitId, path);
                return new LinkRenderer.Rendering(url, name);
            }
        };
        String content = MarkdownUtils.transformMarkdown(doc.markup, renderer);
        doc.html = safeContent = this.xssFilter.relaxed(content);
    }

    private String getWicketUrl(Class<? extends Page> pageClass, String repositoryName, String commitId, String document) {
        String fsc = this.settings.getString("web.forwardSlashCharacter", "/");
        String encodedPath = document.replace(' ', '-');
        try {
            encodedPath = URLEncoder.encode(encodedPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error(null, (Throwable)e);
        }
        encodedPath = encodedPath.replace("/", fsc).replace("%2F", fsc);
        String url = RequestCycle.get().urlFor(pageClass, WicketUtils.newPathParameter(repositoryName, commitId, encodedPath)).toString();
        return url;
    }

    private String getDocumentName(String document) {
        String name = StringUtils.stripFileExtension(document);
        if ((name = name.replace('_', ' ')).indexOf(47) > -1) {
            name = name.substring(name.lastIndexOf(47) + 1);
        }
        return name;
    }

    public static class WorkaroundHtmlSerializer
    extends ToHtmlSerializer {
        public WorkaroundHtmlSerializer(LinkRenderer linkRenderer) {
            super(linkRenderer, Collections.singletonMap("DEFAULT", DefaultVerbatimSerializer.INSTANCE), Collections.emptyList());
        }

        private void printAttribute(String name, String value) {
            this.printer.print(' ').print(name).print('=').print('\"').print(value).print('\"');
        }

        protected void printImageTag(LinkRenderer.Rendering rendering) {
            this.printer.print("<img");
            this.printAttribute("src", rendering.href);
            this.printAttribute("alt", rendering.text);
            for (LinkRenderer.Attribute attr : rendering.attributes) {
                this.printAttribute(attr.name, attr.value);
            }
            this.printer.print("/>");
        }
    }

    public static class MarkupDocument
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String documentPath;
        public final String markup;
        public final MarkupSyntax syntax;
        public String html;

        MarkupDocument(String documentPath, String markup, MarkupSyntax syntax) {
            this.documentPath = documentPath;
            this.markup = markup;
            this.syntax = syntax;
        }

        String getCurrentPath() {
            String basePath = "";
            if (this.documentPath.indexOf(47) > -1 && (basePath = this.documentPath.substring(0, this.documentPath.lastIndexOf(47) + 1)).charAt(0) == '/') {
                return basePath.substring(1);
            }
            return basePath;
        }

        String getRelativePath(String ref) {
            if (ref.charAt(0) == '/') {
                return ref.substring(1);
            }
            String cp = this.getCurrentPath();
            if (StringUtils.isEmpty(cp)) {
                return ref;
            }
            ArrayList<String> currPathStrings = new ArrayList<String>(Arrays.asList(cp.split("/")));
            String file = ref;
            while (file.startsWith("../")) {
                file = file.substring(3);
                currPathStrings.remove(currPathStrings.size() - 1);
            }
            currPathStrings.add(file);
            String path = Joiner.on((String)"/").join(currPathStrings);
            return path;
        }
    }

    public static enum MarkupSyntax {
        PLAIN,
        MARKDOWN,
        TWIKI,
        TRACWIKI,
        TEXTILE,
        MEDIAWIKI,
        CONFLUENCE;

    }
}

