/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket;

import com.gitblit.wicket.pages.BasePage;
import java.text.MessageFormat;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.protocol.http.WicketURLDecoder;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionlessForm<T>
extends StatelessForm<T> {
    private static final long serialVersionUID = 1L;
    private static final String HIDDEN_DIV_START = "<div style=\"width:0px;height:0px;position:absolute;left:-100px;top:-100px;overflow:hidden\">";
    protected final Class<? extends BasePage> pageClass;
    protected final PageParameters pageParameters;
    private final Logger log = LoggerFactory.getLogger(SessionlessForm.class);

    public SessionlessForm(String id, Class<? extends BasePage> bookmarkablePageClass) {
        this(id, bookmarkablePageClass, null);
    }

    public SessionlessForm(String id, Class<? extends BasePage> bookmarkablePageClass, PageParameters pageParameters) {
        super(id);
        this.pageClass = bookmarkablePageClass;
        this.pageParameters = pageParameters;
    }

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        AppendingStringBuffer buffer = new AppendingStringBuffer((CharSequence)HIDDEN_DIV_START);
        buffer.append("<input type=\"hidden\" name=\"").append("wicket:bookmarkablePage").append("\" value=\":").append(this.pageClass.getName()).append("\" />");
        if (this.pageParameters != null) {
            for (String key : this.pageParameters.keySet()) {
                Component c = this.get(key);
                if (c != null) {
                    this.log.warn(MessageFormat.format("Skipping page parameter \"{0}\" from sessionless form hidden fields because it collides with a form child wicket:id", key));
                    continue;
                }
                String value = this.pageParameters.getString(key);
                buffer.append("<input type=\"hidden\" name=\"").append(this.recode(key)).append("\" value=\"").append(this.recode(value)).append("\" />");
            }
        }
        buffer.append("</div>");
        this.getResponse().write((CharSequence)buffer);
        super.onComponentTagBody(markupStream, openTag);
    }

    private String recode(String s) {
        String un = WicketURLDecoder.QUERY_INSTANCE.decode(s);
        return Strings.escapeMarkup((String)un).toString();
    }

    protected String getAbsoluteUrl() {
        return this.getAbsoluteUrl(this.pageClass, this.pageParameters);
    }

    protected String getAbsoluteUrl(Class<? extends BasePage> pageClass, PageParameters pageParameters) {
        String relativeUrl = this.urlFor(pageClass, pageParameters).toString();
        String absoluteUrl = RequestUtils.toAbsolutePath((String)relativeUrl);
        return absoluteUrl;
    }
}

