/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.charting;

import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebApp;
import com.gitblit.wicket.GitBlitWebSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public abstract class Chart
implements Serializable {
    private static final long serialVersionUID = 1L;
    final String tagId;
    final String dataName;
    final String title;
    final String keyName;
    final String valueName;
    final List<ChartValue> values;
    final List<ChartValue> highlights;
    int width;
    int height;
    boolean showLegend;
    String dateFormat = "MMM dd";
    String clickUrl = null;

    public Chart(String tagId, String title, String keyName, String valueName) {
        this.tagId = tagId;
        this.dataName = StringUtils.getSHA1(tagId).substring(0, 8);
        this.title = title;
        this.keyName = keyName;
        this.valueName = valueName;
        this.values = new ArrayList<ChartValue>();
        this.highlights = new ArrayList<ChartValue>();
        this.showLegend = true;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setShowLegend(boolean val) {
        this.showLegend = val;
    }

    public void addValue(String name, int value) {
        this.values.add(new ChartValue(name, value));
    }

    public void addValue(String name, float value) {
        this.values.add(new ChartValue(name, value));
    }

    public void addValue(String name, double value) {
        this.values.add(new ChartValue(name, (float)value));
    }

    public void addValue(Date date, int value) {
        this.values.add(new ChartValue(String.valueOf(date.getTime()), value));
    }

    public void addHighlight(Date date, int value) {
        this.highlights.add(new ChartValue(String.valueOf(date.getTime()), value));
    }

    protected abstract void appendChart(StringBuilder var1);

    protected void line(StringBuilder sb, String line) {
        sb.append(line);
        sb.append('\n');
    }

    protected TimeZone getTimeZone() {
        return GitBlitWebApp.get().settings().getBoolean("web.useClientTimezone", false) ? GitBlitWebSession.get().getTimezone() : GitBlitWebApp.get().getTimezone();
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getClickUrl() {
        return this.clickUrl;
    }

    public void setClickUrl(String clickUrl) {
        this.clickUrl = clickUrl;
    }

    protected class ChartValue
    implements Serializable,
    Comparable<ChartValue> {
        private static final long serialVersionUID = 1L;
        final String name;
        final float value;

        ChartValue(String name, float value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public int compareTo(ChartValue o) {
            if (this.value > o.value) {
                return -1;
            }
            if (this.value < o.value) {
                return 1;
            }
            return 0;
        }
    }
}

