/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.charting;

import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.charting.Chart;
import java.text.MessageFormat;

public class Flotr2PieChart
extends Chart {
    private static final long serialVersionUID = 1L;

    public Flotr2PieChart(String tagId, String title, String keyName, String valueName) {
        super(tagId, title, keyName, valueName);
    }

    @Override
    protected void appendChart(StringBuilder sb) {
        String dName = "data_" + this.dataName;
        this.line(sb, "var selected_" + this.dataName + " = null;");
        this.line(sb, MessageFormat.format("var {0} = Flotr.draw(document.getElementById(''{1}''),", dName, this.tagId));
        this.line(sb, "[");
        for (int i = 0; i < this.values.size(); ++i) {
            Chart.ChartValue value = (Chart.ChartValue)this.values.get(i);
            if (i > 0) {
                sb.append(",");
            }
            this.line(sb, MessageFormat.format("'{'data : [ [0, {0}] ], label : \"{1}\", color: ''{2}'' '}'", Float.toString(value.value), value.name, StringUtils.getColor(value.name)));
        }
        this.line(sb, "]");
        this.line(sb, ", {");
        this.line(sb, MessageFormat.format("title : \"{0}\",", this.title));
        this.line(sb, "fontSize : 2,");
        this.line(sb, "pie : {");
        this.line(sb, "  show : true,");
        this.line(sb, "  labelFormatter : function (pie, slice) {");
        this.line(sb, "    if(slice / pie > .05)");
        this.line(sb, "      return Math.round(slice / pie * 100).toString() + \"%\";");
        this.line(sb, "  }");
        this.line(sb, "}");
        this.line(sb, ", mouse: {");
        this.line(sb, "  track: true,");
        this.line(sb, "  lineColor: '#002060',");
        this.line(sb, "  trackFormatter: function (obj)");
        this.line(sb, "  {");
        this.line(sb, "    selected_" + this.dataName + " = obj.series.label;");
        this.line(sb, "    return obj.series.label + \": \" + parseInt(obj.y) + \" (\" + Math.round(obj.fraction * 100) + \"%)\";");
        this.line(sb, "  }");
        this.line(sb, "}");
        this.line(sb, ", xaxis: {");
        this.line(sb, "  margin: false,");
        this.line(sb, "  showLabels: false,");
        this.line(sb, "  showMinorLabels: false");
        this.line(sb, "}");
        this.line(sb, ", yaxis: {");
        this.line(sb, "  margin: false,");
        this.line(sb, "  min: 20,");
        this.line(sb, "  showLabels: false,");
        this.line(sb, "  showMinorLabels: false");
        this.line(sb, "}");
        this.line(sb, ", grid: {");
        this.line(sb, "  verticalLines: false,");
        this.line(sb, "  minorVerticalLines: null,");
        this.line(sb, "  horizontalLines: false,");
        this.line(sb, "  minorHorizontalLines: null,");
        this.line(sb, "  outlineWidth: 0");
        this.line(sb, "}");
        this.line(sb, ", legend: {");
        if (this.showLegend) {
            this.line(sb, "  show: true");
        } else {
            this.line(sb, "  show: false");
        }
        this.line(sb, "}");
        this.line(sb, "});");
        if (this.clickUrl != null && !this.clickUrl.isEmpty()) {
            this.line(sb, MessageFormat.format("Flotr.EventAdapter.observe(document.getElementById(''{0}''), ''flotr:click'', function (mouse, a, b, c) '{'", this.tagId));
            this.line(sb, "  window.location.href = \"" + this.clickUrl + "\" + selected_" + this.dataName + ";");
            this.line(sb, "});");
        }
    }
}

