/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.freemarker;

import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.freemarker.Freemarker;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupCacheKeyProvider;
import org.apache.wicket.markup.IMarkupResourceStreamProvider;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.StringResourceStream;
import org.apache.wicket.util.string.Strings;

public class FreemarkerPanel
extends Panel
implements IMarkupResourceStreamProvider,
IMarkupCacheKeyProvider {
    private static final long serialVersionUID = 1L;
    private final String template;
    private boolean parseGeneratedMarkup;
    private boolean escapeHtml;
    private boolean throwFreemarkerExceptions;
    private transient String stackTraceAsString;
    private transient String evaluatedTemplate;

    public FreemarkerPanel(String id, String template, Map<String, Object> values) {
        this(id, template, (IModel<? extends Map<String, Object>>)Model.ofMap(values));
    }

    public FreemarkerPanel(String id, String template, IModel<? extends Map<String, Object>> model) {
        super(id, model);
        this.template = template;
    }

    private Template getTemplate() {
        if (StringUtils.isEmpty(this.template)) {
            throw new IllegalArgumentException("Template not specified!");
        }
        try {
            return Freemarker.getTemplate(this.template);
        }
        catch (IOException e) {
            this.onException(e);
            return null;
        }
    }

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        if (!Strings.isEmpty((CharSequence)this.stackTraceAsString)) {
            this.replaceComponentTagBody(markupStream, openTag, Strings.toMultilineMarkup((CharSequence)this.stackTraceAsString));
        } else if (!this.parseGeneratedMarkup) {
            if (this.size() > 0) {
                throw new WicketRuntimeException("Components cannot be added if the generated markup should not be parsed.");
            }
            if (this.evaluatedTemplate == null) {
                this.getMarkupResourceStream(null, null);
            }
            this.replaceComponentTagBody(markupStream, openTag, this.evaluatedTemplate);
        } else {
            super.onComponentTagBody(markupStream, openTag);
        }
    }

    private void onException(Exception exception) {
        if (this.throwFreemarkerExceptions) {
            throw new WicketRuntimeException((Throwable)exception);
        }
        this.stackTraceAsString = Strings.toString((Throwable)exception);
    }

    public void setEscapeHtml(boolean value) {
        this.escapeHtml = value;
    }

    private String evaluateFreemarkerTemplate(Template template) {
        if (this.evaluatedTemplate == null) {
            Map map = (Map)this.getDefaultModelObject();
            StringWriter writer = new StringWriter();
            try {
                Freemarker.evaluate(template, map, writer);
                this.evaluatedTemplate = writer.toString();
                if (this.escapeHtml) {
                    this.evaluatedTemplate = Strings.escapeMarkup((String)this.evaluatedTemplate).toString();
                }
                return this.evaluatedTemplate;
            }
            catch (IOException e) {
                this.onException(e);
            }
            catch (TemplateException e) {
                this.onException((Exception)((Object)e));
            }
            return null;
        }
        return this.evaluatedTemplate;
    }

    public void setParseGeneratedMarkup(boolean value) {
        this.parseGeneratedMarkup = value;
    }

    public void setThrowFreemarkerExceptions(boolean value) {
        this.throwFreemarkerExceptions = value;
    }

    public final IResourceStream getMarkupResourceStream(MarkupContainer container2, Class<?> containerClass) {
        Template template = this.getTemplate();
        if (template == null) {
            throw new WicketRuntimeException("could not find Freemarker template for panel: " + (Object)((Object)this));
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<wicket:panel>");
        sb.append(this.evaluateFreemarkerTemplate(template));
        sb.append("</wicket:panel>");
        return new StringResourceStream((CharSequence)sb.toString());
    }

    public final String getCacheKey(MarkupContainer container2, Class<?> containerClass) {
        return null;
    }

    protected void onDetach() {
        super.onDetach();
        this.stackTraceAsString = null;
        this.evaluatedTemplate = null;
    }
}

