/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.ng;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;

public class NgController
implements IHeaderContributor {
    private static final long serialVersionUID = 1L;
    final String name;
    final Map<String, Object> variables;

    public NgController(String name) {
        this.name = name;
        this.variables = new HashMap<String, Object>();
    }

    public void addVariable(String name, Object o) {
        this.variables.put(name, o);
    }

    public void renderHead(IHeaderResponse response) {
        response.renderJavascriptReference(new ResourceReference(NgController.class, "angular.js"));
        Gson gson = new GsonBuilder().create();
        StringBuilder sb = new StringBuilder();
        this.line(sb, MessageFormat.format("<!-- AngularJS {0} data controller -->", this.name));
        this.line(sb, MessageFormat.format("function {0}($scope) '{'", this.name));
        for (Map.Entry<String, Object> entry : this.variables.entrySet()) {
            String var = entry.getKey();
            Object o = entry.getValue();
            String json = gson.toJson(o);
            this.line(sb, MessageFormat.format("\t$scope.{0} = {1};", var, json));
        }
        this.line(sb, "}");
        response.renderJavascript((CharSequence)sb.toString(), null);
    }

    private void line(StringBuilder sb, String line) {
        sb.append(line);
        sb.append('\n');
    }
}

