/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.Activity;
import com.gitblit.models.Menu;
import com.gitblit.models.Metric;
import com.gitblit.models.NavLink;
import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.ActivityUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.charting.Chart;
import com.gitblit.wicket.charting.Charts;
import com.gitblit.wicket.charting.Flotr2Charts;
import com.gitblit.wicket.pages.RootPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.panels.ActivityPanel;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;

@CacheControl(value=CacheControl.LastModified.ACTIVITY)
public class ActivityPage
extends RootPage {
    public ActivityPage(PageParameters params) {
        super(params);
        this.setupPage("", "");
        int daysBack = WicketUtils.getDaysBack(params);
        if (daysBack < 1) {
            daysBack = this.app().settings().getInteger("web.activityDuration", 7);
        }
        String objectId = WicketUtils.getObject(params);
        List<RepositoryModel> models = this.getRepositories(params);
        List<Activity> recentActivity = ActivityUtils.getRecentActivity(this.app().settings(), this.app().repositories(), models, daysBack, objectId, this.getTimeZone());
        String headerPattern = daysBack == 1 ? (recentActivity.size() == 0 ? this.getString("gb.todaysActivityNone") : this.getString("gb.todaysActivityStats")) : (recentActivity.size() == 0 ? this.getString("gb.recentActivityNone") : this.getString("gb.recentActivityStats"));
        if (recentActivity.size() == 0) {
            this.add(new Component[]{new Label("subheader", MessageFormat.format(headerPattern, daysBack))});
            this.add(new Component[]{new Label("chartsPanel").setVisible(false)});
            this.add(new Component[]{new Label("activityPanel")});
        } else {
            int totalCommits = 0;
            HashSet<String> uniqueAuthors = new HashSet<String>();
            for (Activity activity : recentActivity) {
                totalCommits += activity.getCommitCount();
                uniqueAuthors.addAll(activity.getAuthorMetrics().keySet());
            }
            int totalAuthors = uniqueAuthors.size();
            this.add(new Component[]{new Label("subheader", MessageFormat.format(headerPattern, daysBack, totalCommits, totalAuthors))});
            if (this.app().settings().getBoolean("web.generateActivityGraph", true)) {
                Charts charts = this.createCharts(recentActivity);
                this.add(new IBehavior[]{new HeaderContributor((IHeaderContributor)charts)});
                this.add(new Component[]{new Fragment("chartsPanel", "chartsFragment", (MarkupContainer)this)});
            } else {
                this.add(new Component[]{new Label("chartsPanel").setVisible(false)});
            }
            this.add(new Component[]{new ActivityPanel("activityPanel", recentActivity)});
        }
    }

    @Override
    protected boolean reusePageParameters() {
        return true;
    }

    @Override
    protected void addDropDownMenus(List<NavLink> navLinks) {
        NavLink.DropDownPageMenuNavLink filters = new NavLink.DropDownPageMenuNavLink("gb.filters", ActivityPage.class);
        PageParameters currentParameters = this.getPageParameters();
        int daysBack = this.app().settings().getInteger("web.activityDuration", 7);
        if (currentParameters != null && !currentParameters.containsKey((Object)"db")) {
            currentParameters.put("db", (Object)daysBack);
        }
        filters.menuItems.addAll(this.getRepositoryFilterItems(currentParameters));
        filters.menuItems.addAll(this.getTimeFilterItems(currentParameters));
        if (filters.menuItems.size() > 0) {
            filters.menuItems.add(new Menu.ParameterMenuItem(this.getString("gb.reset")));
        }
        navLinks.add(filters);
    }

    private Charts createCharts(List<Activity> recentActivity) {
        HashMap<String, Metric> repositoryMetrics = new HashMap<String, Metric>();
        HashMap<String, Metric> authorMetrics = new HashMap<String, Metric>();
        for (Activity activity : recentActivity) {
            for (Map.Entry<String, Metric> entry : activity.getAuthorMetrics().entrySet()) {
                String author = entry.getKey();
                if (!authorMetrics.containsKey(author)) {
                    authorMetrics.put(author, new Metric(author));
                }
                ((Metric)authorMetrics.get((Object)author)).count += entry.getValue().count;
            }
            for (Map.Entry<String, Metric> entry : activity.getRepositoryMetrics().entrySet()) {
                String repository = StringUtils.stripDotGit(entry.getKey());
                if (!repositoryMetrics.containsKey(repository)) {
                    repositoryMetrics.put(repository, new Metric(repository));
                }
                ((Metric)repositoryMetrics.get((Object)repository)).count += entry.getValue().count;
            }
        }
        Flotr2Charts charts = new Flotr2Charts();
        Collections.sort(recentActivity);
        Collections.reverse(recentActivity);
        Chart chart = ((Charts)charts).createLineChart("chartDaily", this.getString("gb.dailyActivity"), "day", this.getString("gb.commits"));
        SimpleDateFormat df = new SimpleDateFormat("MMM dd");
        df.setTimeZone(this.getTimeZone());
        for (Comparable<Activity> metric : recentActivity) {
            chart.addValue(metric.startDate, metric.getCommitCount());
        }
        charts.addChart(chart);
        chart = ((Charts)charts).createPieChart("chartRepositories", this.getString("gb.activeRepositories"), this.getString("gb.repository"), this.getString("gb.commits"));
        for (Comparable<Activity> metric : repositoryMetrics.values()) {
            chart.addValue(((Metric)metric).name, ((Metric)metric).count);
        }
        chart.setShowLegend(false);
        String url = this.urlFor(SummaryPage.class, null).toString() + "?r=";
        chart.setClickUrl(url);
        charts.addChart(chart);
        chart = ((Charts)charts).createPieChart("chartAuthors", this.getString("gb.activeAuthors"), this.getString("gb.author"), this.getString("gb.commits"));
        for (Metric metric : authorMetrics.values()) {
            chart.addValue(metric.name, metric.count);
        }
        chart.setShowLegend(false);
        charts.addChart(chart);
        return charts;
    }
}

