/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.models.ProjectModel;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.TimeUtils;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.GitBlitWebApp;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.SessionPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RedirectToUrlException;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.target.basic.RedirectRequestTarget;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePage
extends SessionPage {
    private transient Logger logger;
    private transient TimeUtils timeUtils;

    public BasePage() {
        this.customizeHeader();
    }

    public BasePage(PageParameters params) {
        super(params);
        this.customizeHeader();
    }

    protected Logger logger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        }
        return this.logger;
    }

    private void customizeHeader() {
        if (this.app().settings().getBoolean("web.useResponsiveLayout", true)) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((String)"bootstrap/css/bootstrap-responsive.css")});
        }
        if (this.app().settings().getBoolean("web.hideHeader", false)) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((String)"hideheader.css")});
        }
    }

    protected String getContextUrl() {
        return this.getRequest().getRelativePathPrefixToContextRoot();
    }

    protected String getCanonicalUrl() {
        return this.getCanonicalUrl(((Object)((Object)this)).getClass(), this.getPageParameters());
    }

    protected String getCanonicalUrl(Class<? extends BasePage> clazz, PageParameters params) {
        String relativeUrl = this.urlFor(clazz, params).toString();
        String canonicalUrl = RequestUtils.toAbsolutePath((String)relativeUrl);
        return canonicalUrl;
    }

    protected void redirectTo(Class<? extends BasePage> pageClass) {
        this.redirectTo(pageClass, null);
    }

    protected void redirectTo(Class<? extends BasePage> pageClass, PageParameters parameters) {
        String absoluteUrl = this.getCanonicalUrl(pageClass, parameters);
        this.getRequestCycle().setRequestTarget((IRequestTarget)new RedirectRequestTarget(absoluteUrl));
    }

    protected String getLanguageCode() {
        return GitBlitWebSession.get().getLocale().getLanguage();
    }

    protected String getCountryCode() {
        return GitBlitWebSession.get().getLocale().getCountry().toLowerCase();
    }

    protected TimeUtils getTimeUtils() {
        if (this.timeUtils == null) {
            ResourceBundle bundle;
            try {
                bundle = ResourceBundle.getBundle("com.gitblit.wicket.GitBlitWebApp", GitBlitWebSession.get().getLocale());
            }
            catch (Throwable t) {
                bundle = ResourceBundle.getBundle("com.gitblit.wicket.GitBlitWebApp");
            }
            this.timeUtils = new TimeUtils(bundle, this.getTimeZone());
        }
        return this.timeUtils;
    }

    protected void onBeforeRender() {
        if (this.app().isDebugMode()) {
            Application.get().getMarkupSettings().setStripWicketTags(true);
        }
        super.onBeforeRender();
    }

    protected void onAfterRender() {
        if (this.app().isDebugMode()) {
            Application.get().getMarkupSettings().setStripWicketTags(false);
        }
        super.onAfterRender();
    }

    protected void setHeaders(WebResponse response) {
        response.setHeader("Link", MessageFormat.format("<{0}>; rel=\"canonical\"", this.getCanonicalUrl()));
        int expires = this.app().settings().getInteger("web.pageCacheExpires", 0);
        if (expires > 0) {
            response.setHeader("Cache-Control", "private, must-revalidate");
            this.setLastModified();
        } else {
            super.setHeaders(response);
        }
        response.setHeader("X-Frame-Options", "SAMEORIGIN");
    }

    protected void setLastModified() {
        if (((Object)((Object)this)).getClass().isAnnotationPresent(CacheControl.class)) {
            CacheControl cacheControl = ((Object)((Object)this)).getClass().getAnnotation(CacheControl.class);
            switch (cacheControl.value()) {
                case ACTIVITY: {
                    this.setLastModified(this.app().getLastActivityDate());
                    break;
                }
                case BOOT: {
                    this.setLastModified(this.app().getBootDate());
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    this.logger().warn(((Object)((Object)this)).getClass().getSimpleName() + ": unhandled LastModified type " + (Object)((Object)cacheControl.value()));
                }
            }
        }
    }

    protected final void setLastModified(Date when) {
        if (when == null) {
            return;
        }
        if (when.before(this.app().getBootDate())) {
            when = this.app().getBootDate();
        }
        int expires = this.app().settings().getInteger("web.pageCacheExpires", 0);
        WebResponse response = (WebResponse)this.getResponse();
        response.setLastModifiedTime(Time.valueOf((Date)when));
        response.setDateHeader("Expires", System.currentTimeMillis() + Duration.minutes((int)expires).getMilliseconds());
    }

    protected String getPageTitle(String repositoryName) {
        String siteName = this.app().settings().getString("web.siteName", "Gitblit");
        if (StringUtils.isEmpty(siteName)) {
            siteName = "Gitblit";
        }
        if (repositoryName != null && repositoryName.trim().length() > 0) {
            return repositoryName + " - " + siteName;
        }
        return siteName;
    }

    protected void setupPage(String repositoryName, String pageName) {
        this.add(new Component[]{new Label("title", this.getPageTitle(repositoryName))});
        this.getBottomScriptContainer();
        String rootLinkUrl = this.app().settings().getString("web.rootLink", this.urlFor(GitBlitWebApp.get().getHomePage(), null).toString());
        ExternalLink rootLink = new ExternalLink("rootLink", rootLinkUrl);
        WicketUtils.setHtmlTooltip((Component)rootLink, this.app().settings().getString("web.siteName", "Gitblit"));
        this.add(new Component[]{rootLink});
        this.add(new Component[]{new FeedbackPanel("feedback")});
        this.add(new Component[]{new Label("gbVersion", "v" + Constants.getVersion())});
        if (this.app().settings().getBoolean("web.aggressiveHeapManagement", false)) {
            System.gc();
        }
    }

    protected Map<Constants.AccessRestrictionType, String> getAccessRestrictions() {
        LinkedHashMap<Constants.AccessRestrictionType, String> map = new LinkedHashMap<Constants.AccessRestrictionType, String>();
        block6: for (Constants.AccessRestrictionType type : Constants.AccessRestrictionType.values()) {
            switch (type) {
                case NONE: {
                    map.put(type, this.getString("gb.notRestricted"));
                    continue block6;
                }
                case PUSH: {
                    map.put(type, this.getString("gb.pushRestricted"));
                    continue block6;
                }
                case CLONE: {
                    map.put(type, this.getString("gb.cloneRestricted"));
                    continue block6;
                }
                case VIEW: {
                    map.put(type, this.getString("gb.viewRestricted"));
                }
            }
        }
        return map;
    }

    protected Map<Constants.AccessPermission, String> getAccessPermissions() {
        LinkedHashMap<Constants.AccessPermission, String> map = new LinkedHashMap<Constants.AccessPermission, String>();
        block10: for (Constants.AccessPermission type : Constants.AccessPermission.values()) {
            switch (type) {
                case NONE: {
                    map.put(type, MessageFormat.format(this.getString("gb.noPermission"), type.code));
                    continue block10;
                }
                case EXCLUDE: {
                    map.put(type, MessageFormat.format(this.getString("gb.excludePermission"), type.code));
                    continue block10;
                }
                case VIEW: {
                    map.put(type, MessageFormat.format(this.getString("gb.viewPermission"), type.code));
                    continue block10;
                }
                case CLONE: {
                    map.put(type, MessageFormat.format(this.getString("gb.clonePermission"), type.code));
                    continue block10;
                }
                case PUSH: {
                    map.put(type, MessageFormat.format(this.getString("gb.pushPermission"), type.code));
                    continue block10;
                }
                case CREATE: {
                    map.put(type, MessageFormat.format(this.getString("gb.createPermission"), type.code));
                    continue block10;
                }
                case DELETE: {
                    map.put(type, MessageFormat.format(this.getString("gb.deletePermission"), type.code));
                    continue block10;
                }
                case REWIND: {
                    map.put(type, MessageFormat.format(this.getString("gb.rewindPermission"), type.code));
                }
            }
        }
        return map;
    }

    protected Map<Constants.FederationStrategy, String> getFederationTypes() {
        LinkedHashMap<Constants.FederationStrategy, String> map = new LinkedHashMap<Constants.FederationStrategy, String>();
        block5: for (Constants.FederationStrategy type : Constants.FederationStrategy.values()) {
            switch (type) {
                case EXCLUDE: {
                    map.put(type, this.getString("gb.excludeFromFederation"));
                    continue block5;
                }
                case FEDERATE_THIS: {
                    map.put(type, this.getString("gb.federateThis"));
                    continue block5;
                }
                case FEDERATE_ORIGIN: {
                    map.put(type, this.getString("gb.federateOrigin"));
                }
            }
        }
        return map;
    }

    protected Map<Constants.AuthorizationControl, String> getAuthorizationControls() {
        LinkedHashMap<Constants.AuthorizationControl, String> map = new LinkedHashMap<Constants.AuthorizationControl, String>();
        block4: for (Constants.AuthorizationControl type : Constants.AuthorizationControl.values()) {
            switch (type) {
                case AUTHENTICATED: {
                    map.put(type, this.getString("gb.allowAuthenticatedDescription"));
                    continue block4;
                }
                case NAMED: {
                    map.put(type, this.getString("gb.allowNamedDescription"));
                }
            }
        }
        return map;
    }

    protected TimeZone getTimeZone() {
        return this.app().settings().getBoolean("web.useClientTimezone", false) ? GitBlitWebSession.get().getTimezone() : this.app().getTimezone();
    }

    protected String getServerName() {
        ServletWebRequest servletWebRequest = (ServletWebRequest)this.getRequest();
        HttpServletRequest req = servletWebRequest.getHttpServletRequest();
        return req.getServerName();
    }

    protected List<ProjectModel> getProjectModels() {
        UserModel user = GitBlitWebSession.get().getUser();
        List<ProjectModel> projects = this.app().projects().getProjectModels(user, true);
        return projects;
    }

    protected List<ProjectModel> getProjects(PageParameters params) {
        if (params == null) {
            return this.getProjectModels();
        }
        boolean hasParameter = false;
        String regex2 = WicketUtils.getRegEx(params);
        String team = WicketUtils.getTeam(params);
        int daysBack = params.getInt("db", 0);
        int maxDaysBack = this.app().settings().getInteger("web.activityDurationMaximum", 30);
        List<ProjectModel> availableModels = this.getProjectModels();
        HashSet<ProjectModel> models = new HashSet<ProjectModel>();
        if (!StringUtils.isEmpty(regex2)) {
            hasParameter = true;
            Pattern pattern = Pattern.compile(regex2);
            for (ProjectModel model : availableModels) {
                if (!pattern.matcher(model.name).find()) continue;
                models.add(model);
            }
        }
        if (!StringUtils.isEmpty(team)) {
            hasParameter = true;
            List<String> teams = StringUtils.getStringsFromValue(team, ",");
            ArrayList<TeamModel> teamModels = new ArrayList<TeamModel>();
            for (String name : teams) {
                TeamModel teamModel = this.app().users().getTeamModel(name);
                if (teamModel == null) continue;
                teamModels.add(teamModel);
            }
            for (ProjectModel projectModel : availableModels) {
                for (String repositoryName : projectModel.repositories) {
                    for (TeamModel teamModel : teamModels) {
                        if (!teamModel.hasRepositoryPermission(repositoryName)) continue;
                        models.add(projectModel);
                    }
                }
            }
        }
        if (!hasParameter) {
            models.addAll(availableModels);
        }
        if (daysBack > 0) {
            if (maxDaysBack > 0 && daysBack > maxDaysBack) {
                daysBack = maxDaysBack;
            }
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, -1 * daysBack);
            Date threshold = cal.getTime();
            HashSet<ProjectModel> timeFiltered = new HashSet<ProjectModel>();
            for (ProjectModel model : models) {
                if (!model.lastChange.after(threshold)) continue;
                timeFiltered.add(model);
            }
            models = timeFiltered;
        }
        ArrayList<ProjectModel> list = new ArrayList<ProjectModel>(models);
        Collections.sort(list);
        return list;
    }

    public void warn(String message, Throwable t) {
        this.logger().warn(message, t);
    }

    public void error(String message, boolean redirect) {
        this.error(message, null, redirect ? this.getApplication().getHomePage() : null);
    }

    public void error(String message, Throwable t, boolean redirect) {
        this.error(message, t, this.getApplication().getHomePage());
    }

    public void error(String message, Throwable t, Class<? extends Page> toPage) {
        this.error(message, t, toPage, null);
    }

    public void error(String message, Throwable t, Class<? extends Page> toPage, PageParameters params) {
        if (t == null) {
            this.logger().error(message + " for " + GitBlitWebSession.get().getUsername());
        } else {
            this.logger().error(message + " for " + GitBlitWebSession.get().getUsername(), t);
        }
        if (toPage != null) {
            GitBlitWebSession.get().cacheErrorMessage(message);
            String relativeUrl = this.urlFor(toPage, params).toString();
            String absoluteUrl = RequestUtils.toAbsolutePath((String)relativeUrl);
            throw new RedirectToUrlException(absoluteUrl);
        }
        super.error((Serializable)((Object)message));
    }

    public void authenticationError(String message) {
        this.logger().error(this.getRequest().getURL() + " for " + GitBlitWebSession.get().getUsername());
        if (!GitBlitWebSession.get().isLoggedIn()) {
            GitBlitWebSession.get().cacheRequest(((Object)((Object)this)).getClass());
        }
        this.error(message, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readResource(String resource) {
        StringBuilder sb = new StringBuilder();
        InputStream is = null;
        try {
            is = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
            List lines = IOUtils.readLines((InputStream)is);
            for (String line : lines) {
                sb.append(line).append('\n');
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    private RepeatingView getBottomScriptContainer() {
        RepeatingView bottomScriptContainer = (RepeatingView)this.get("bottomScripts");
        if (bottomScriptContainer == null) {
            bottomScriptContainer = new RepeatingView("bottomScripts");
            bottomScriptContainer.setRenderBodyOnly(true);
            this.add(new Component[]{bottomScriptContainer});
        }
        return bottomScriptContainer;
    }

    protected void addBottomScript(String scriptPath) {
        RepeatingView bottomScripts = this.getBottomScriptContainer();
        Label script = new Label(bottomScripts.newChildId(), "<script type='text/javascript' src='" + this.urlFor((ResourceReference)new JavascriptResourceReference(((Object)((Object)this)).getClass(), scriptPath)) + "'></script>\n");
        bottomScripts.add(new Component[]{script.setEscapeModelStrings(false).setRenderBodyOnly(true)});
    }

    protected void addBottomScriptInline(String code) {
        RepeatingView bottomScripts = this.getBottomScriptContainer();
        Label script = new Label(bottomScripts.newChildId(), "<script type='text/javascript'>/*<![CDATA[*/\n" + code + "\n//]]>\n</script>\n");
        bottomScripts.add(new Component[]{script.setEscapeModelStrings(false).setRenderBodyOnly(true)});
    }
}

