/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.AnnotatedLine;
import com.gitblit.models.PathModel;
import com.gitblit.utils.ColorFactory;
import com.gitblit.utils.DiffUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.BlobPage;
import com.gitblit.wicket.pages.CommitDiffPage;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.HistoryPage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.panels.CommitHeaderPanel;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.PathBreadcrumbsPanel;
import java.awt.Color;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;

@CacheControl(value=CacheControl.LastModified.BOOT)
public class BlamePage
extends RepositoryPage {
    public BlamePage(PageParameters params) {
        super(params);
        String blobPath = WicketUtils.getPath(params);
        String blameTypeParam = params.getString("blametype", BlameType.COMMIT.toString());
        final BlameType activeBlameType = BlameType.get(blameTypeParam);
        RevCommit commit = this.getCommit();
        PathModel pathModel = null;
        List<PathModel> paths = JGitUtils.getFilesInPath(this.getRepository(), StringUtils.getRootPath(blobPath), commit);
        for (PathModel path : paths) {
            if (!path.path.equals(blobPath)) continue;
            pathModel = path;
            break;
        }
        if (pathModel == null) {
            String notFound = MessageFormat.format("Blame page failed to find {0} in {1} @ {2}", blobPath, this.repositoryName, this.objectId);
            this.logger.error(notFound);
            this.add(new Component[]{new Label("annotation").setVisible(false)});
            this.add(new Component[]{new Label("missingBlob", this.missingBlob(blobPath, commit)).setEscapeModelStrings(false)});
            return;
        }
        if (pathModel.isFilestoreItem()) {
            String rawUrl = JGitUtils.getLfsRepositoryUrl(this.getContextUrl(), this.repositoryName, pathModel.getFilestoreOid());
            this.add(new Component[]{new ExternalLink("blobLink", rawUrl)});
        } else {
            this.add(new Component[]{new BookmarkablePageLink("blobLink", BlobPage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, blobPath))});
        }
        this.add(new Component[]{new BookmarkablePageLink("commitLink", CommitPage.class, WicketUtils.newObjectParameter(this.repositoryName, this.objectId))});
        this.add(new Component[]{new BookmarkablePageLink("commitDiffLink", CommitDiffPage.class, WicketUtils.newObjectParameter(this.repositoryName, this.objectId))});
        this.add(new Component[]{new BookmarkablePageLink("historyLink", HistoryPage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, blobPath))});
        for (BlameType type : BlameType.values()) {
            String typeString = type.toString();
            PageParameters blameTypePageParam = WicketUtils.newBlameTypeParameter(this.repositoryName, commit.getName(), WicketUtils.getPath(params), typeString);
            String blameByLinkText = "blameBy" + Character.toUpperCase(typeString.charAt(0)) + typeString.substring(1) + "Link";
            BookmarkablePageLink blameByPageLink = new BookmarkablePageLink(blameByLinkText, BlamePage.class, blameTypePageParam);
            if (activeBlameType == type) {
                blameByPageLink.add(new IBehavior[]{new SimpleAttributeModifier("style", (CharSequence)"font-weight:bold;")});
            }
            this.add(new Component[]{blameByPageLink});
        }
        this.add(new Component[]{new CommitHeaderPanel("commitHeader", this.repositoryName, commit)});
        this.add(new Component[]{new PathBreadcrumbsPanel("breadcrumbs", this.repositoryName, blobPath, this.objectId)});
        String format = this.app().settings().getString("web.datetimestampLongFormat", "EEEE, MMMM d, yyyy HH:mm Z");
        final SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(this.getTimeZone());
        this.add(new Component[]{new Label("missingBlob").setVisible(false)});
        final int tabLength = this.app().settings().getInteger("web.tabLength", 4);
        List<AnnotatedLine> lines = DiffUtils.blame(this.getRepository(), blobPath, this.objectId);
        final Map<?, String> colorMap = this.initializeColors(activeBlameType, lines);
        ListDataProvider blameDp = new ListDataProvider(lines);
        DataView<AnnotatedLine> blameView = new DataView<AnnotatedLine>("annotation", (IDataProvider)blameDp){
            private static final long serialVersionUID = 1L;
            private String lastCommitId;
            private boolean showInitials;
            private String zeroId;
            {
                super(x0, x1);
                this.lastCommitId = "";
                this.showInitials = true;
                this.zeroId = ObjectId.zeroId().getName();
            }

            public void populateItem(Item<AnnotatedLine> item) {
                String color;
                AnnotatedLine entry = (AnnotatedLine)item.getModelObject();
                if (!this.lastCommitId.equals(entry.commitId)) {
                    this.lastCommitId = entry.commitId;
                    if (this.zeroId.equals(entry.commitId)) {
                        item.add(new Component[]{new Label("commit", "<?>")});
                        this.showInitials = false;
                    } else {
                        LinkPanel commitLink = new LinkPanel("commit", null, BlamePage.this.getShortObjectId(entry.commitId), CommitPage.class, BlamePage.this.newCommitParameter(entry.commitId));
                        WicketUtils.setHtmlTooltip((Component)commitLink, MessageFormat.format("{0}, {1}", entry.author, df.format(entry.when)));
                        item.add(new Component[]{commitLink});
                        WicketUtils.setCssStyle(item, "border-top: 1px solid #ddd;");
                        this.showInitials = true;
                    }
                } else if (this.showInitials) {
                    this.showInitials = false;
                    item.add(new Component[]{new Label("commit", BlamePage.this.getInitials(entry.author))});
                } else {
                    item.add(new Component[]{new Label("commit").setVisible(false)});
                }
                item.add(new Component[]{new Label("line", "" + entry.lineNumber)});
                switch (activeBlameType) {
                    case AGE: {
                        color = (String)colorMap.get(entry.when);
                        break;
                    }
                    case AUTHOR: {
                        color = (String)colorMap.get(entry.author);
                        break;
                    }
                    default: {
                        color = (String)colorMap.get(entry.commitId);
                    }
                }
                Component data = new Label("data", StringUtils.escapeForHtml(entry.data, true, tabLength)).setEscapeModelStrings(false);
                data.add(new IBehavior[]{new SimpleAttributeModifier("style", (CharSequence)("background-color: " + color + ";"))});
                item.add(new Component[]{data});
            }
        };
        this.add(new Component[]{blameView});
    }

    private String getInitials(String author) {
        String[] chunks;
        StringBuilder sb = new StringBuilder();
        for (String chunk : chunks = author.split(" ")) {
            sb.append(chunk.charAt(0));
        }
        return sb.toString().toUpperCase();
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.blame");
    }

    @Override
    protected boolean isCommitPage() {
        return true;
    }

    @Override
    protected Class<? extends BasePage> getRepoNavPageClass() {
        return TreePage.class;
    }

    protected String missingBlob(String blobPath, RevCommit commit) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"alert alert-error\">");
        String pattern = this.getString("gb.doesNotExistInTree").replace("{0}", "<b>{0}</b>").replace("{1}", "<b>{1}</b>");
        sb.append(MessageFormat.format(pattern, blobPath, commit.getTree().getId().getName()));
        sb.append("</div>");
        return sb.toString();
    }

    private Map<?, String> initializeColors(BlameType blameType, List<AnnotatedLine> lines) {
        Map<Object, String> colorMap;
        ColorFactory colorFactory = new ColorFactory();
        if (BlameType.AGE == blameType) {
            TreeSet<Date> keys = new TreeSet<Date>(new Comparator<Date>(){

                @Override
                public int compare(Date o1, Date o2) {
                    return o1.compareTo(o2);
                }
            });
            for (AnnotatedLine line : lines) {
                keys.add(line.when);
            }
            colorMap = colorFactory.getGraduatedColorMap(keys, Color.decode("#FFA63A"));
        } else {
            HashSet<String> keys = new HashSet<String>();
            for (AnnotatedLine line : lines) {
                if (blameType == BlameType.AUTHOR) {
                    keys.add(line.author);
                    continue;
                }
                keys.add(line.commitId);
            }
            colorMap = colorFactory.getRandomColorMap(keys);
        }
        return colorMap;
    }

    private static enum BlameType {
        COMMIT,
        AUTHOR,
        AGE;


        public static BlameType get(String name) {
            for (BlameType blameType : BlameType.values()) {
                if (!blameType.name().equalsIgnoreCase(name)) continue;
                return blameType;
            }
            throw new IllegalArgumentException("Unknown Blame Type [" + name + "]");
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

