/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.utils.DiffUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.BlamePage;
import com.gitblit.wicket.pages.CommitDiffPage;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.HistoryPage;
import com.gitblit.wicket.pages.ImageDiffHandler;
import com.gitblit.wicket.pages.PatchPage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.panels.CommitHeaderPanel;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.PathBreadcrumbsPanel;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

@CacheControl(value=CacheControl.LastModified.BOOT)
public class BlobDiffPage
extends RepositoryPage {
    public BlobDiffPage(PageParameters params) {
        super(params);
        String diff;
        String blobPath = WicketUtils.getPath(params);
        String baseObjectId = WicketUtils.getBaseObjectId(params);
        DiffUtils.DiffComparator diffComparator = WicketUtils.getDiffComparator(params);
        Repository r = this.getRepository();
        RevCommit commit = this.getCommit();
        List<String> imageExtensions = this.app().settings().getStrings("web.imageExtensions");
        if (StringUtils.isEmpty(baseObjectId)) {
            RevCommit parent = commit.getParentCount() == 0 ? null : commit.getParent(0);
            ImageDiffHandler handler = new ImageDiffHandler(this, this.repositoryName, parent.getName(), commit.getName(), imageExtensions);
            diff = DiffUtils.getDiff((Repository)r, (RevCommit)commit, (String)blobPath, (DiffUtils.DiffComparator)diffComparator, (DiffUtils.DiffOutputType)DiffUtils.DiffOutputType.HTML, (DiffUtils.BinaryDiffHandler)handler, (int)3).content;
            if (handler.getImgDiffCount() > 0) {
                this.addBottomScript("scripts/imgdiff.js");
            }
            this.add(new Component[]{new BookmarkablePageLink("patchLink", PatchPage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, blobPath))});
        } else {
            RevCommit baseCommit = JGitUtils.getCommit(r, baseObjectId);
            ImageDiffHandler handler = new ImageDiffHandler(this, this.repositoryName, baseCommit.getName(), commit.getName(), imageExtensions);
            diff = DiffUtils.getDiff((Repository)r, (RevCommit)baseCommit, (RevCommit)commit, (String)blobPath, (DiffUtils.DiffComparator)diffComparator, (DiffUtils.DiffOutputType)DiffUtils.DiffOutputType.HTML, (DiffUtils.BinaryDiffHandler)handler, (int)3).content;
            if (handler.getImgDiffCount() > 0) {
                this.addBottomScript("scripts/imgdiff.js");
            }
            this.add(new Component[]{new BookmarkablePageLink("patchLink", PatchPage.class, WicketUtils.newBlobDiffParameter(this.repositoryName, baseObjectId, this.objectId, blobPath))});
        }
        this.add(new Component[]{new BookmarkablePageLink("commitLink", CommitPage.class, WicketUtils.newObjectParameter(this.repositoryName, this.objectId))});
        this.add(new Component[]{new BookmarkablePageLink("commitDiffLink", CommitDiffPage.class, WicketUtils.newObjectParameter(this.repositoryName, this.objectId))});
        this.add(new Component[]{new LinkPanel("whitespaceLink", null, this.getString(diffComparator.getOpposite().getTranslationKey()), BlobDiffPage.class, WicketUtils.newDiffParameter(this.repositoryName, this.objectId, diffComparator.getOpposite(), blobPath))});
        this.add(new Component[]{new BookmarkablePageLink("blameLink", BlamePage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, blobPath))});
        this.add(new Component[]{new BookmarkablePageLink("historyLink", HistoryPage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, blobPath))});
        this.add(new Component[]{new CommitHeaderPanel("commitHeader", this.repositoryName, commit)});
        this.add(new Component[]{new PathBreadcrumbsPanel("breadcrumbs", this.repositoryName, blobPath, this.objectId)});
        this.add(new Component[]{new Label("diffText", diff).setEscapeModelStrings(false)});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.diff");
    }

    @Override
    protected boolean isCommitPage() {
        return true;
    }

    @Override
    protected Class<? extends BasePage> getRepoNavPageClass() {
        return TreePage.class;
    }
}

