/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.GitBlitException;
import com.gitblit.models.UserModel;
import com.gitblit.utils.PasswordHash;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.NonTrimmedPasswordTextField;
import com.gitblit.wicket.pages.RepositoriesPage;
import com.gitblit.wicket.pages.RootSubPage;
import java.io.Serializable;
import java.text.MessageFormat;
import org.apache.wicket.Component;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;

public class ChangePasswordPage
extends RootSubPage {
    private IModel<String> password = new Model((Serializable)((Object)""));
    private IModel<String> confirmPassword = new Model((Serializable)((Object)""));

    public ChangePasswordPage() {
        if (!GitBlitWebSession.get().isLoggedIn()) {
            throw new RestartResponseException(this.getApplication().getHomePage());
        }
        if (!this.app().settings().getBoolean("web.authenticateAdminPages", true) && !this.app().settings().getBoolean("web.authenticateViewPages", false)) {
            throw new RestartResponseException(this.getApplication().getHomePage());
        }
        UserModel user = GitBlitWebSession.get().getUser();
        if (!this.app().authentication().supportsCredentialChanges(user)) {
            this.error(MessageFormat.format(this.getString("gb.userServiceDoesNotPermitPasswordChanges"), this.app().settings().getString("realm.userService", "${baseFolder}/users.conf")), true);
        }
        this.setupPage(this.getString("gb.changePassword"), user.username);
        StatelessForm<Void> form = new StatelessForm<Void>("passwordForm"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                String confirmPassword;
                String password = (String)ChangePasswordPage.this.password.getObject();
                if (!password.equals(confirmPassword = (String)ChangePasswordPage.this.confirmPassword.getObject())) {
                    this.error((Serializable)((Object)this.getString("gb.passwordsDoNotMatch")));
                    return;
                }
                int minLength = ChangePasswordPage.this.app().settings().getInteger("realm.minPasswordLength", 5);
                if (minLength < 4) {
                    minLength = 4;
                }
                if (password.length() < minLength) {
                    this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.passwordTooShort"), minLength)));
                    return;
                }
                UserModel user = GitBlitWebSession.get().getUser();
                String type = ChangePasswordPage.this.app().settings().getString("realm.passwordStorage", PasswordHash.getDefaultType().name());
                PasswordHash pwdHash = PasswordHash.instanceOf(type);
                if (pwdHash != null) {
                    password = pwdHash.toHashedEntry(password, user.username);
                }
                user.password = password;
                try {
                    ChangePasswordPage.this.app().gitblit().reviseUser(user.username, user);
                    if (ChangePasswordPage.this.app().settings().getBoolean("web.allowCookieAuthentication", false)) {
                        WebRequest request = (WebRequest)this.getRequestCycle().getRequest();
                        WebResponse response = (WebResponse)this.getRequestCycle().getResponse();
                        ChangePasswordPage.this.app().authentication().setCookie(request.getHttpServletRequest(), response.getHttpServletResponse(), user);
                    }
                }
                catch (GitBlitException e) {
                    this.error((Serializable)((Object)e.getMessage()));
                    return;
                }
                this.setRedirect(false);
                this.info(this.getString("gb.passwordChanged"));
                this.setResponsePage(RepositoriesPage.class);
            }
        };
        NonTrimmedPasswordTextField passwordField = new NonTrimmedPasswordTextField("password", this.password);
        passwordField.setResetPassword(false);
        form.add(new Component[]{passwordField});
        NonTrimmedPasswordTextField confirmPasswordField = new NonTrimmedPasswordTextField("confirmPassword", this.confirmPassword);
        confirmPasswordField.setResetPassword(false);
        form.add(new Component[]{confirmPasswordField});
        form.add(new Component[]{new Button("save")});
        Button cancel = new Button("cancel"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                this.setRedirect(false);
                this.error((Serializable)((Object)this.getString("gb.passwordChangeAborted")));
                this.setResponsePage(RepositoriesPage.class);
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
        this.add(new Component[]{form});
    }
}

