/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.models.GitNote;
import com.gitblit.models.PathModel;
import com.gitblit.models.SubmoduleModel;
import com.gitblit.models.UserModel;
import com.gitblit.servlet.RawServlet;
import com.gitblit.utils.DiffUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.BlamePage;
import com.gitblit.wicket.pages.BlobPage;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.HistoryPage;
import com.gitblit.wicket.pages.ImageDiffHandler;
import com.gitblit.wicket.pages.LogPage;
import com.gitblit.wicket.pages.PatchPage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.panels.AvatarImage;
import com.gitblit.wicket.panels.CommitHeaderPanel;
import com.gitblit.wicket.panels.CommitLegendPanel;
import com.gitblit.wicket.panels.DiffStatPanel;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.RefsPanel;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.request.target.resource.ResourceStreamRequestTarget;
import org.apache.wicket.util.resource.AbstractResourceStreamWriter;
import org.apache.wicket.util.resource.IResourceStream;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

@CacheControl(value=CacheControl.LastModified.BOOT)
public class CommitDiffPage
extends RepositoryPage {
    public CommitDiffPage(PageParameters params) {
        super(params);
        Repository r = this.getRepository();
        RevCommit commit = this.getCommit();
        DiffUtils.DiffComparator diffComparator = WicketUtils.getDiffComparator(params);
        ArrayList<String> parents = new ArrayList<String>();
        if (commit.getParentCount() > 0) {
            for (RevCommit parent : commit.getParents()) {
                parents.add(parent.name());
            }
        }
        if (parents.size() == 0) {
            this.add(new Component[]{new Label("parentLink", this.getString("gb.none"))});
        } else {
            this.add(new Component[]{new LinkPanel("parentLink", null, ((String)parents.get(0)).substring(0, 8), CommitDiffPage.class, this.newCommitParameter((String)parents.get(0)))});
        }
        this.add(new Component[]{new BookmarkablePageLink("patchLink", PatchPage.class, WicketUtils.newObjectParameter(this.repositoryName, this.objectId))});
        this.add(new Component[]{new BookmarkablePageLink("commitLink", CommitPage.class, WicketUtils.newObjectParameter(this.repositoryName, this.objectId))});
        this.add(new Component[]{new LinkPanel("whitespaceLink", null, this.getString(diffComparator.getOpposite().getTranslationKey()), CommitDiffPage.class, WicketUtils.newDiffParameter(this.repositoryName, this.objectId, diffComparator.getOpposite()))});
        this.add(new Component[]{new CommitHeaderPanel("commitHeader", this.repositoryName, commit)});
        List<String> imageExtensions = this.app().settings().getStrings("web.imageExtensions");
        ImageDiffHandler handler = new ImageDiffHandler(this, this.repositoryName, parents.isEmpty() ? null : (String)parents.get(0), commit.getName(), imageExtensions);
        int tabLength = this.app().settings().getInteger("web.tabLength", 4);
        DiffUtils.DiffOutput diff = DiffUtils.getCommitDiff(r, commit, diffComparator, DiffUtils.DiffOutputType.HTML, handler, tabLength);
        if (handler.getImgDiffCount() > 0) {
            this.addBottomScript("scripts/imgdiff.js");
        }
        int insertions = 0;
        int deletions = 0;
        for (PathModel.PathChangeModel pcm : diff.stat.paths) {
            insertions += pcm.insertions;
            deletions += pcm.deletions;
        }
        this.add(new Component[]{new DiffStatPanel("diffStat", insertions, deletions)});
        this.addFullText("fullMessage", commit.getFullMessage());
        List<GitNote> notes = JGitUtils.getNotesOnCommit(r, commit);
        ListDataProvider notesDp = new ListDataProvider(notes);
        DataView<GitNote> notesView = new DataView<GitNote>("notes", (IDataProvider)notesDp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<GitNote> item) {
                GitNote entry = (GitNote)item.getModelObject();
                item.add(new Component[]{new RefsPanel("refName", CommitDiffPage.this.repositoryName, Arrays.asList(entry.notesRef))});
                item.add(new Component[]{CommitDiffPage.this.createPersonPanel("authorName", entry.notesRef.getAuthorIdent(), Constants.SearchType.AUTHOR)});
                item.add(new Component[]{new AvatarImage("noteAuthorAvatar", entry.notesRef.getAuthorIdent())});
                item.add(new Component[]{WicketUtils.createTimestampLabel("authorDate", entry.notesRef.getAuthorIdent().getWhen(), CommitDiffPage.this.getTimeZone(), CommitDiffPage.this.getTimeUtils())});
                item.add(new Component[]{new Label("noteContent", CommitDiffPage.this.bugtraqProcessor().processPlainCommitMessage(CommitDiffPage.this.getRepository(), CommitDiffPage.this.repositoryName, entry.content)).setEscapeModelStrings(false)});
            }
        };
        this.add(new Component[]{notesView.setVisible(notes.size() > 0)});
        this.add(new Component[]{new CommitLegendPanel("commitLegend", diff.stat.paths)});
        ListDataProvider pathsDp = new ListDataProvider(diff.stat.paths);
        DataView<PathModel.PathChangeModel> pathsView = new DataView<PathModel.PathChangeModel>("changedPath", (IDataProvider)pathsDp){
            private static final long serialVersionUID = 1L;
            int counter;

            public void populateItem(Item<PathModel.PathChangeModel> item) {
                final PathModel.PathChangeModel entry = (PathModel.PathChangeModel)item.getModelObject();
                Label changeType = new Label("changeType", "");
                WicketUtils.setChangeTypeCssClass((Component)changeType, entry.changeType);
                CommitDiffPage.this.setChangeTypeTooltip((Component)changeType, entry.changeType);
                item.add(new Component[]{changeType});
                item.add(new Component[]{new DiffStatPanel("diffStat", entry.insertions, entry.deletions, true)});
                item.add(new Component[]{WicketUtils.setHtmlTooltip((Component)new Label("filestore", ""), this.getString("gb.filestore")).setVisible(entry.isFilestoreItem())});
                boolean hasSubmodule = false;
                String submodulePath = null;
                if (entry.isTree()) {
                    item.add(new Component[]{new LinkPanel("pathName", null, entry.path, TreePage.class, WicketUtils.newPathParameter(CommitDiffPage.this.repositoryName, entry.commitId, entry.path))});
                } else if (entry.isSubmodule()) {
                    String submoduleId = entry.objectId;
                    SubmoduleModel submodule = CommitDiffPage.this.getSubmodule(entry.path);
                    submodulePath = submodule.gitblitPath;
                    hasSubmodule = submodule.hasSubmodule;
                    item.add(new Component[]{new LinkPanel("pathName", "list", entry.path + " @ " + CommitDiffPage.this.getShortObjectId(submoduleId), "#n" + entry.objectId)});
                } else if (entry.isFilestoreItem()) {
                    item.add(new Component[]{new LinkPanel("pathName", "list", entry.path, new Link<Object>("link", null){
                        private static final long serialVersionUID = 1L;

                        public void onClick() {
                            AbstractResourceStreamWriter resourceStream = new AbstractResourceStreamWriter(){
                                private static final long serialVersionUID = 1L;

                                public void write(OutputStream output) {
                                    UserModel user = GitBlitWebSession.get().getUser();
                                    user = user == null ? UserModel.ANONYMOUS : user;
                                    CommitDiffPage.this.app().filestore().downloadBlob(entry.getFilestoreOid(), user, CommitDiffPage.this.getRepositoryModel(), output);
                                }
                            };
                            this.getRequestCycle().setRequestTarget((IRequestTarget)new ResourceStreamRequestTarget((IResourceStream)resourceStream, entry.path));
                        }
                    })});
                } else {
                    item.add(new Component[]{new LinkPanel("pathName", "list", entry.path, "#n" + entry.objectId)});
                }
                if (entry.isSubmodule()) {
                    item.add(new Component[]{new ExternalLink("raw", "").setEnabled(false)});
                    item.add(new Component[]{new ExternalLink("patch", "").setEnabled(false)});
                    item.add(new Component[]{new BookmarkablePageLink("view", CommitPage.class, WicketUtils.newObjectParameter(submodulePath, entry.objectId)).setEnabled(hasSubmodule)});
                    item.add(new Component[]{new ExternalLink("blame", "").setEnabled(false)});
                    item.add(new Component[]{new BookmarkablePageLink("history", HistoryPage.class, WicketUtils.newPathParameter(CommitDiffPage.this.repositoryName, entry.commitId, entry.path)).setEnabled(!entry.changeType.equals((Object)DiffEntry.ChangeType.ADD))});
                } else {
                    item.add(new Component[]{new BookmarkablePageLink("patch", PatchPage.class, WicketUtils.newPathParameter(CommitDiffPage.this.repositoryName, entry.commitId, entry.path)).setEnabled(!entry.changeType.equals((Object)DiffEntry.ChangeType.ADD) && !entry.changeType.equals((Object)DiffEntry.ChangeType.DELETE))});
                    if (entry.isFilestoreItem()) {
                        item.add(new Component[]{new Link<Object>("view", null){
                            private static final long serialVersionUID = 1L;

                            public void onClick() {
                                AbstractResourceStreamWriter resourceStream = new AbstractResourceStreamWriter(){
                                    private static final long serialVersionUID = 1L;

                                    public void write(OutputStream output) {
                                        UserModel user = GitBlitWebSession.get().getUser();
                                        user = user == null ? UserModel.ANONYMOUS : user;
                                        CommitDiffPage.this.app().filestore().downloadBlob(entry.getFilestoreOid(), user, CommitDiffPage.this.getRepositoryModel(), output);
                                    }
                                };
                                this.getRequestCycle().setRequestTarget((IRequestTarget)new ResourceStreamRequestTarget((IResourceStream)resourceStream, entry.path));
                            }
                        }});
                        item.add(new Component[]{new Link<Object>("raw", null){
                            private static final long serialVersionUID = 1L;

                            public void onClick() {
                                AbstractResourceStreamWriter resourceStream = new AbstractResourceStreamWriter(){
                                    private static final long serialVersionUID = 1L;

                                    public void write(OutputStream output) {
                                        UserModel user = GitBlitWebSession.get().getUser();
                                        user = user == null ? UserModel.ANONYMOUS : user;
                                        CommitDiffPage.this.app().filestore().downloadBlob(entry.getFilestoreOid(), user, CommitDiffPage.this.getRepositoryModel(), output);
                                    }
                                };
                                this.getRequestCycle().setRequestTarget((IRequestTarget)new ResourceStreamRequestTarget((IResourceStream)resourceStream, entry.path));
                            }
                        }});
                    } else {
                        item.add(new Component[]{new BookmarkablePageLink("view", BlobPage.class, WicketUtils.newPathParameter(CommitDiffPage.this.repositoryName, entry.commitId, entry.path)).setEnabled(!entry.changeType.equals((Object)DiffEntry.ChangeType.DELETE))});
                        item.add(new Component[]{new ExternalLink("raw", RawServlet.asLink(CommitDiffPage.this.getContextUrl(), CommitDiffPage.this.repositoryName, entry.commitId, entry.path)).setEnabled(!entry.changeType.equals((Object)DiffEntry.ChangeType.DELETE))});
                    }
                    item.add(new Component[]{new BookmarkablePageLink("blame", BlamePage.class, WicketUtils.newPathParameter(CommitDiffPage.this.repositoryName, entry.commitId, entry.path)).setEnabled(!entry.changeType.equals((Object)DiffEntry.ChangeType.ADD) && !entry.changeType.equals((Object)DiffEntry.ChangeType.DELETE))});
                    item.add(new Component[]{new BookmarkablePageLink("history", HistoryPage.class, WicketUtils.newPathParameter(CommitDiffPage.this.repositoryName, entry.commitId, entry.path)).setEnabled(!entry.changeType.equals((Object)DiffEntry.ChangeType.ADD))});
                }
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{pathsView});
        this.add(new Component[]{new Label("diffText", diff.content).setEscapeModelStrings(false)});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.commitdiff");
    }

    @Override
    protected boolean isCommitPage() {
        return true;
    }

    @Override
    protected Class<? extends BasePage> getRepoNavPageClass() {
        return LogPage.class;
    }
}

