/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.UserModel;
import com.gitblit.servlet.RawServlet;
import com.gitblit.utils.BugtraqProcessor;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.MarkupProcessor;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.BlamePage;
import com.gitblit.wicket.pages.HistoryPage;
import com.gitblit.wicket.pages.RepositoryPage;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

@CacheControl(value=CacheControl.LastModified.REPOSITORY)
public class EditFilePage
extends RepositoryPage {
    public EditFilePage(final PageParameters params) {
        super(params);
        Fragment fragment;
        final UserModel currentUser = GitBlitWebSession.get().getUser() != null ? GitBlitWebSession.get().getUser() : UserModel.ANONYMOUS;
        final String path = WicketUtils.getPath(params).replace("%2f", "/").replace("%2F", "/");
        MarkupProcessor processor = new MarkupProcessor(this.app().settings(), this.app().xssFilter());
        Repository r = this.getRepository();
        RevCommit commit = JGitUtils.getCommit(r, this.objectId);
        String[] encodings = this.getEncodings();
        String documentPath = path;
        String markupText = JGitUtils.getStringContent(r, commit.getTree(), path, encodings);
        if (StringUtils.isEmpty(markupText)) {
            String name = StringUtils.stripFileExtension(path);
            List<String> docExtensions = processor.getAllExtensions();
            for (String ext : docExtensions) {
                String checkName = name + "." + ext;
                markupText = JGitUtils.getStringContent(r, commit.getTree(), checkName, encodings);
                if (StringUtils.isEmpty(markupText)) continue;
                documentPath = path;
                break;
            }
        }
        if (markupText == null) {
            markupText = "";
        }
        BugtraqProcessor bugtraq = new BugtraqProcessor(this.app().settings());
        markupText = bugtraq.processText(this.getRepository(), this.repositoryName, markupText);
        String displayedCommitId = commit.getId().getName();
        if (currentUser.canEdit(this.getRepositoryModel()) && JGitUtils.isTip(this.getRepository(), this.objectId.toString())) {
            final Model documentContent = new Model((Serializable)((Object)markupText));
            final Model commitMessage = new Model((Serializable)((Object)"Document update"));
            final Model commitIdAtLoad = new Model((Serializable)((Object)displayedCommitId));
            fragment = new Fragment("doc", "markupContent", (MarkupContainer)this);
            Form<Void> form = new Form<Void>("documentEditor"){
                private static final long serialVersionUID = 1L;

                protected void onSubmit() {
                    Repository repository = EditFilePage.this.getRepository();
                    String document = (String)((Object)documentContent.getObject());
                    String message = (String)((Object)commitMessage.getObject());
                    String branchName = JGitUtils.getBranch(EditFilePage.this.getRepository(), EditFilePage.this.objectId).getName();
                    String authorEmail = StringUtils.isEmpty(currentUser.emailAddress) ? currentUser.username + "@gitblit" : currentUser.emailAddress;
                    boolean success = false;
                    try {
                        ObjectId docAtLoad = EditFilePage.this.getRepository().resolve((String)((Object)commitIdAtLoad.getObject()));
                        EditFilePage.this.logger.trace("Commiting Edit File page: " + (String)((Object)commitIdAtLoad.getObject()));
                        DirCache index = DirCache.newInCore();
                        DirCacheBuilder builder = index.builder();
                        byte[] bytes = document.getBytes("UTF-8");
                        DirCacheEntry fileUpdate = new DirCacheEntry(path);
                        fileUpdate.setLength(bytes.length);
                        fileUpdate.setLastModified(System.currentTimeMillis());
                        fileUpdate.setFileMode(FileMode.REGULAR_FILE);
                        fileUpdate.setObjectId((AnyObjectId)repository.newObjectInserter().insert(3, bytes));
                        builder.add(fileUpdate);
                        HashSet<String> ignorePaths = new HashSet<String>();
                        ignorePaths.add(path);
                        for (DirCacheEntry entry : JGitUtils.getTreeEntries(repository, branchName, ignorePaths)) {
                            builder.add(entry);
                        }
                        builder.finish();
                        boolean forceCommit = false;
                        success = JGitUtils.commitIndex(repository, branchName, index, docAtLoad, false, currentUser.getDisplayName(), authorEmail, message);
                    }
                    catch (IOException | ConcurrentRefUpdateException e) {
                        e.printStackTrace();
                    }
                    if (!success) {
                        this.getSession().error(MessageFormat.format(this.getString("gb.fileNotMergeable"), path));
                        return;
                    }
                    this.getSession().info(MessageFormat.format(this.getString("gb.fileCommitted"), path));
                    this.setResponsePage(EditFilePage.class, params);
                }
            };
            TextArea docIO = new TextArea("content", (IModel)documentContent);
            docIO.setOutputMarkupId(false);
            form.add(new Component[]{new Label("commitAuthor", String.format("%s <%s>", currentUser.getDisplayName(), currentUser.emailAddress))});
            form.add(new Component[]{new TextArea("commitMessage", (IModel)commitMessage)});
            form.setOutputMarkupId(false);
            form.add(new Component[]{docIO});
            this.addBottomScriptInline("attachDocumentEditor(document.querySelector('textarea#editor'), $('#commitDialog'));");
            fragment.add(new Component[]{form});
        } else {
            MarkupProcessor.MarkupDocument markupDoc = processor.parse(this.repositoryName, displayedCommitId, documentPath, markupText);
            Model documentContent = new Model((Serializable)((Object)markupDoc.html));
            fragment = new Fragment("doc", "plainContent", (MarkupContainer)this);
            fragment.add(new Component[]{new Label("content", (IModel)documentContent).setEscapeModelStrings(false)});
        }
        fragment.add(new Component[]{new BookmarkablePageLink("blameLink", BlamePage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, documentPath))});
        fragment.add(new Component[]{new BookmarkablePageLink("historyLink", HistoryPage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, documentPath))});
        String rawUrl = RawServlet.asLink(this.getContextUrl(), this.repositoryName, this.objectId, documentPath);
        fragment.add(new Component[]{new ExternalLink("rawLink", rawUrl)});
        this.add(new Component[]{fragment});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.editFile");
    }

    @Override
    protected boolean isCommitPage() {
        return true;
    }

    @Override
    protected Class<? extends BasePage> getRepoNavPageClass() {
        return EditFilePage.class;
    }
}

