/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TicketModel;
import com.gitblit.models.UserModel;
import com.gitblit.tickets.TicketMilestone;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.Html5DateField;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.TicketsPage;
import com.gitblit.wicket.panels.BasePanel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class EditMilestonePage
extends RepositoryPage {
    private final String oldName;
    private IModel<String> nameModel;
    private IModel<Date> dueModel;
    private IModel<TicketModel.Status> statusModel;
    private IModel<Boolean> notificationModel;

    public EditMilestonePage(PageParameters params) {
        super(params);
        RepositoryModel model = this.getRepositoryModel();
        if (!this.app().tickets().isAcceptingTicketUpdates(model)) {
            throw new RestartResponseException(TicketsPage.class, WicketUtils.newOpenTicketsParameter(this.repositoryName));
        }
        UserModel currentUser = GitBlitWebSession.get().getUser();
        if (currentUser == null) {
            currentUser = UserModel.ANONYMOUS;
        }
        if (!currentUser.isAuthenticated || !currentUser.canAdmin(model)) {
            throw new RestartResponseException(TicketsPage.class, WicketUtils.newOpenTicketsParameter(this.repositoryName));
        }
        this.oldName = WicketUtils.getObject(params);
        if (StringUtils.isEmpty(this.oldName)) {
            throw new RestartResponseException(TicketsPage.class, WicketUtils.newOpenTicketsParameter(this.repositoryName));
        }
        TicketMilestone tm = this.app().tickets().getMilestone(this.getRepositoryModel(), this.oldName);
        if (tm == null) {
            throw new RestartResponseException(TicketsPage.class, WicketUtils.newOpenTicketsParameter(this.repositoryName));
        }
        this.setStatelessHint(false);
        this.setOutputMarkupId(true);
        Form form = new Form("editForm");
        this.add(new Component[]{form});
        this.nameModel = Model.of((Serializable)((Object)tm.name));
        this.dueModel = Model.of((Serializable)tm.due);
        this.statusModel = Model.of((Serializable)((Object)tm.status));
        this.notificationModel = Model.of((Serializable)Boolean.valueOf(true));
        form.add(new Component[]{new TextField("name", this.nameModel)});
        form.add(new Component[]{new Html5DateField("due", this.dueModel, "yyyy-MM-dd")});
        form.add(new Component[]{new Label("dueFormat", "yyyy-MM-dd")});
        form.add(new Component[]{new CheckBox("notify", this.notificationModel)});
        this.addBottomScriptInline("{var e=document.createElement('input');e.type='date';if(e.type=='date'){$('[name=\"due\"]~.help-inline').hide()}}");
        this.addBottomScript("scripts/wicketHtml5Patch.js");
        List<TicketModel.Status> statusChoices = Arrays.asList(TicketModel.Status.Open, TicketModel.Status.Closed);
        form.add(new Component[]{new DropDownChoice("status", this.statusModel, statusChoices)});
        form.add(new Component[]{new AjaxButton("save"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                String name = (String)EditMilestonePage.this.nameModel.getObject();
                if (StringUtils.isEmpty(name)) {
                    return;
                }
                Date due = (Date)EditMilestonePage.this.dueModel.getObject();
                TicketModel.Status status = (TicketModel.Status)((Object)EditMilestonePage.this.statusModel.getObject());
                boolean rename = !name.equals(EditMilestonePage.this.oldName);
                boolean notify = (Boolean)EditMilestonePage.this.notificationModel.getObject();
                UserModel currentUser = GitBlitWebSession.get().getUser();
                String createdBy = currentUser.username;
                TicketMilestone tm = EditMilestonePage.this.app().tickets().getMilestone(EditMilestonePage.this.getRepositoryModel(), EditMilestonePage.this.oldName);
                tm.setName(name);
                tm.setDue(due);
                tm.status = status;
                boolean success = true;
                if (rename) {
                    success = EditMilestonePage.this.app().tickets().renameMilestone(EditMilestonePage.this.getRepositoryModel(), EditMilestonePage.this.oldName, name, createdBy, notify);
                }
                if (success && EditMilestonePage.this.app().tickets().updateMilestone(EditMilestonePage.this.getRepositoryModel(), tm, createdBy)) {
                    EditMilestonePage.this.redirectTo(TicketsPage.class, WicketUtils.newOpenTicketsParameter(EditMilestonePage.this.repositoryName));
                }
            }
        }});
        Button cancel = new Button("cancel"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                this.setResponsePage(TicketsPage.class, WicketUtils.newOpenTicketsParameter(EditMilestonePage.this.repositoryName));
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
        Link<Void> delete = new Link<Void>("delete"){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                UserModel currentUser = GitBlitWebSession.get().getUser();
                String createdBy = currentUser.username;
                boolean notify = (Boolean)EditMilestonePage.this.notificationModel.getObject();
                if (EditMilestonePage.this.app().tickets().deleteMilestone(EditMilestonePage.this.getRepositoryModel(), EditMilestonePage.this.oldName, createdBy, notify)) {
                    this.setResponsePage(TicketsPage.class, WicketUtils.newOpenTicketsParameter(EditMilestonePage.this.repositoryName));
                } else {
                    this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.milestoneDeleteFailed"), EditMilestonePage.this.oldName)));
                }
            }
        };
        delete.add(new IBehavior[]{new BasePanel.JavascriptEventConfirmation("onclick", MessageFormat.format(this.getString("gb.deleteMilestone"), this.oldName))});
        form.add(new Component[]{delete});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.editMilestone");
    }

    @Override
    protected Class<? extends BasePage> getRepoNavPageClass() {
        return TicketsPage.class;
    }
}

