/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.models.TicketModel;
import com.gitblit.models.UserModel;
import com.gitblit.tickets.TicketMilestone;
import com.gitblit.tickets.TicketNotifier;
import com.gitblit.tickets.TicketResponsible;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.TicketsPage;
import com.gitblit.wicket.panels.MarkdownTextArea;
import com.google.common.base.Optional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.eclipse.jgit.lib.Repository;

public class EditTicketPage
extends RepositoryPage {
    static final String NIL = "<nil>";
    static final String ESC_NIL = StringUtils.escapeForHtml("<nil>", false);
    private IModel<TicketModel.Type> typeModel;
    private IModel<String> titleModel;
    private MarkdownTextArea descriptionEditor;
    private IModel<String> topicModel;
    private IModel<String> mergeToModel;
    private IModel<TicketModel.Status> statusModel;
    private IModel<TicketResponsible> responsibleModel;
    private IModel<TicketMilestone> milestoneModel;
    private Label descriptionPreview;
    private IModel<TicketModel.Priority> priorityModel;
    private IModel<TicketModel.Severity> severityModel;

    public EditTicketPage(PageParameters params) {
        super(params);
        UserModel currentUser = GitBlitWebSession.get().getUser();
        if (currentUser == null) {
            currentUser = UserModel.ANONYMOUS;
        }
        long ticketId = 0L;
        try {
            String h = WicketUtils.getObject(params);
            ticketId = Long.parseLong(h);
        }
        catch (Exception e) {
            this.setResponsePage(TicketsPage.class, WicketUtils.newRepositoryParameter(this.repositoryName));
        }
        TicketModel ticket = this.app().tickets().getTicket(this.getRepositoryModel(), ticketId);
        if (ticket == null || !currentUser.canEdit(ticket, this.getRepositoryModel()) || !this.app().tickets().isAcceptingTicketUpdates(this.getRepositoryModel())) {
            this.setResponsePage(TicketsPage.class, WicketUtils.newObjectParameter(this.repositoryName, "" + ticketId));
            ticket = new TicketModel();
        }
        this.typeModel = Model.of((Serializable)((Object)ticket.type));
        this.titleModel = Model.of((Serializable)((Object)ticket.title));
        this.topicModel = Model.of((Serializable)((Object)(ticket.topic == null ? "" : ticket.topic)));
        this.responsibleModel = Model.of();
        this.milestoneModel = Model.of();
        this.mergeToModel = Model.of((Serializable)((Object)(ticket.mergeTo == null ? this.getRepositoryModel().mergeTo : ticket.mergeTo)));
        this.statusModel = Model.of((Serializable)((Object)ticket.status));
        this.priorityModel = Model.of((Serializable)((Object)ticket.priority));
        this.severityModel = Model.of((Serializable)((Object)ticket.severity));
        this.setStatelessHint(false);
        this.setOutputMarkupId(true);
        Form form = new Form("editForm");
        this.add(new Component[]{form});
        List<TicketModel.Type> typeChoices = ticket.isProposal() ? Arrays.asList(TicketModel.Type.Proposal) : Arrays.asList(TicketModel.Type.choices());
        form.add(new Component[]{new DropDownChoice("type", this.typeModel, typeChoices)});
        form.add(new Component[]{new TextField("title", this.titleModel)});
        form.add(new Component[]{new TextField("topic", this.topicModel)});
        Model markdownPreviewModel = Model.of((Serializable)((Object)(ticket.body == null ? "" : ticket.body)));
        this.descriptionPreview = new Label("descriptionPreview", (IModel)markdownPreviewModel);
        this.descriptionPreview.setEscapeModelStrings(false);
        this.descriptionPreview.setOutputMarkupId(true);
        form.add(new Component[]{this.descriptionPreview});
        this.descriptionEditor = new MarkdownTextArea("description", (IModel<String>)markdownPreviewModel, this.descriptionPreview);
        this.descriptionEditor.setRepository(this.repositoryName);
        this.descriptionEditor.setText(ticket.body);
        form.add(new Component[]{this.descriptionEditor});
        List<TicketModel.Status> statusChoices = ticket.isClosed() ? Arrays.asList(ticket.status, TicketModel.Status.Open) : (ticket.isProposal() ? Arrays.asList(TicketModel.Status.proposalWorkflow) : (ticket.isBug() ? Arrays.asList(TicketModel.Status.bugWorkflow) : Arrays.asList(TicketModel.Status.requestWorkflow)));
        Fragment status = new Fragment("status", "statusFragment", (MarkupContainer)this);
        status.add(new Component[]{new DropDownChoice("status", this.statusModel, statusChoices)});
        form.add(new Component[]{status});
        List<TicketModel.Severity> severityChoices = Arrays.asList(TicketModel.Severity.choices());
        form.add(new Component[]{new DropDownChoice("severity", this.severityModel, severityChoices)});
        if (currentUser.canAdmin(ticket, this.getRepositoryModel())) {
            TreeSet<String> userlist = new TreeSet<String>(ticket.getParticipants());
            if (UserModel.ANONYMOUS.canPush(this.getRepositoryModel()) || Constants.AuthorizationControl.AUTHENTICATED == this.getRepositoryModel().authorizationControl) {
                userlist.addAll(this.app().users().getAllUsernames());
            } else {
                for (RegistrantAccessPermission rp : this.app().repositories().getUserAccessPermissions(this.getRepositoryModel())) {
                    if (!rp.permission.atLeast(Constants.AccessPermission.PUSH)) continue;
                    userlist.add(rp.registrant);
                }
            }
            ArrayList<TicketResponsible> responsibles = new ArrayList<TicketResponsible>();
            for (String username : userlist) {
                UserModel user = this.app().users().getUserModel(username);
                if (user == null || user.disabled) continue;
                TicketResponsible responsible = new TicketResponsible(user);
                responsibles.add(responsible);
                if (!user.username.equals(ticket.responsible)) continue;
                this.responsibleModel.setObject((Object)responsible);
            }
            Collections.sort(responsibles);
            responsibles.add(new TicketResponsible(NIL, "", ""));
            Fragment responsible = new Fragment("responsible", "responsibleFragment", (MarkupContainer)this);
            responsible.add(new Component[]{new DropDownChoice("responsible", this.responsibleModel, responsibles)});
            form.add(new Component[]{responsible.setVisible(!responsibles.isEmpty())});
            List<TicketMilestone> milestones = this.app().tickets().getMilestones(this.getRepositoryModel(), TicketModel.Status.Open);
            for (TicketMilestone milestone : milestones) {
                if (!milestone.name.equals(ticket.milestone)) continue;
                this.milestoneModel.setObject((Object)milestone);
                break;
            }
            if (this.milestoneModel.getObject() == null && !StringUtils.isEmpty(ticket.milestone)) {
                TicketMilestone tms = new TicketMilestone(ticket.milestone);
                milestones.add(tms);
                this.milestoneModel.setObject((Object)tms);
            }
            if (!milestones.isEmpty()) {
                milestones.add(new TicketMilestone(NIL));
            }
            Fragment milestone = new Fragment("milestone", "milestoneFragment", (MarkupContainer)this);
            milestone.add(new Component[]{new DropDownChoice("milestone", this.milestoneModel, milestones)});
            form.add(new Component[]{milestone.setVisible(!milestones.isEmpty())});
            Fragment priority = new Fragment("priority", "priorityFragment", (MarkupContainer)this);
            List<TicketModel.Priority> priorityChoices = Arrays.asList(TicketModel.Priority.choices());
            priority.add(new Component[]{new DropDownChoice("priority", this.priorityModel, priorityChoices)});
            form.add(new Component[]{priority});
            ArrayList<String> branches = new ArrayList<String>();
            for (String branch : this.getRepositoryModel().getLocalBranches()) {
                if (branch.startsWith("refs/heads/ticket/")) continue;
                branches.add(Repository.shortenRefName((String)branch));
            }
            branches.remove(Repository.shortenRefName((String)this.getRepositoryModel().mergeTo));
            branches.add(0, Repository.shortenRefName((String)this.getRepositoryModel().mergeTo));
            Fragment mergeto = new Fragment("mergeto", "mergeToFragment", (MarkupContainer)this);
            mergeto.add(new Component[]{new DropDownChoice("mergeto", this.mergeToModel, branches)});
            form.add(new Component[]{mergeto.setVisible(!branches.isEmpty())});
        } else {
            form.add(new Component[]{new Label("responsible").setVisible(false)});
            form.add(new Component[]{new Label("milestone").setVisible(false)});
            form.add(new Component[]{new Label("mergeto").setVisible(false)});
            form.add(new Component[]{new Label("priority").setVisible(false)});
        }
        form.add(new Component[]{new AjaxButton("update"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                TicketModel.Severity severity;
                TicketModel.Priority priority;
                TicketMilestone milestone;
                TicketResponsible responsible;
                TicketModel.Type type;
                TicketModel.Status status;
                long ticketId = 0L;
                try {
                    String h = WicketUtils.getObject(EditTicketPage.this.getPageParameters());
                    ticketId = Long.parseLong(h);
                }
                catch (Exception e) {
                    this.setResponsePage(TicketsPage.class, WicketUtils.newRepositoryParameter(EditTicketPage.this.repositoryName));
                }
                TicketModel ticket = EditTicketPage.this.app().tickets().getTicket(EditTicketPage.this.getRepositoryModel(), ticketId);
                String createdBy = GitBlitWebSession.get().getUsername();
                TicketModel.Change change = new TicketModel.Change(createdBy);
                String title = (String)EditTicketPage.this.titleModel.getObject();
                if (StringUtils.isEmpty(title)) {
                    return;
                }
                if (!ticket.title.equals(title)) {
                    change.setField(TicketModel.Field.title, title);
                }
                String description = (String)Optional.fromNullable((Object)EditTicketPage.this.descriptionEditor.getText()).or((Object)"");
                if (StringUtils.isEmpty(ticket.body) && !StringUtils.isEmpty(description) || !StringUtils.isEmpty(ticket.body) && !ticket.body.equals(description)) {
                    change.setField(TicketModel.Field.body, description);
                }
                if (!ticket.status.equals((Object)(status = (TicketModel.Status)((Object)EditTicketPage.this.statusModel.getObject())))) {
                    change.setField(TicketModel.Field.status, (Object)status);
                }
                if (!ticket.type.equals((Object)(type = (TicketModel.Type)((Object)EditTicketPage.this.typeModel.getObject())))) {
                    change.setField(TicketModel.Field.type, (Object)type);
                }
                String topic = (String)Optional.fromNullable((Object)EditTicketPage.this.topicModel.getObject()).or((Object)"");
                if (StringUtils.isEmpty(ticket.topic) && !StringUtils.isEmpty(topic) || !StringUtils.isEmpty(ticket.topic) && !ticket.topic.equals(topic)) {
                    change.setField(TicketModel.Field.topic, topic);
                }
                TicketResponsible ticketResponsible = responsible = EditTicketPage.this.responsibleModel == null ? null : (TicketResponsible)EditTicketPage.this.responsibleModel.getObject();
                if (responsible != null && !responsible.username.equals(ticket.responsible)) {
                    change.setField(TicketModel.Field.responsible, responsible.username);
                    if (!StringUtils.isEmpty(responsible.username) && !ticket.isWatching(responsible.username)) {
                        change.watch(responsible.username);
                    }
                }
                TicketMilestone ticketMilestone = milestone = EditTicketPage.this.milestoneModel == null ? null : (TicketMilestone)EditTicketPage.this.milestoneModel.getObject();
                if (milestone != null && !milestone.name.equals(ticket.milestone)) {
                    if (EditTicketPage.NIL.equals(milestone.name)) {
                        change.setField(TicketModel.Field.milestone, "");
                    } else {
                        change.setField(TicketModel.Field.milestone, milestone.name);
                    }
                }
                if (!ticket.priority.equals((Object)(priority = (TicketModel.Priority)((Object)EditTicketPage.this.priorityModel.getObject())))) {
                    change.setField(TicketModel.Field.priority, (Object)priority);
                }
                if (!ticket.severity.equals((Object)(severity = (TicketModel.Severity)((Object)EditTicketPage.this.severityModel.getObject())))) {
                    change.setField(TicketModel.Field.severity, (Object)severity);
                }
                String mergeTo = (String)EditTicketPage.this.mergeToModel.getObject();
                if (StringUtils.isEmpty(ticket.mergeTo) && !StringUtils.isEmpty(mergeTo) || !StringUtils.isEmpty(mergeTo) && !mergeTo.equals(ticket.mergeTo)) {
                    change.setField(TicketModel.Field.mergeTo, mergeTo);
                }
                if (change.hasFieldChanges()) {
                    if (!ticket.isWatching(createdBy)) {
                        change.watch(createdBy);
                    }
                    if ((ticket = EditTicketPage.this.app().tickets().updateTicket(EditTicketPage.this.getRepositoryModel(), ticket.number, change)) != null) {
                        TicketNotifier notifier = EditTicketPage.this.app().tickets().createNotifier();
                        notifier.sendMailing(ticket);
                        EditTicketPage.this.redirectTo(TicketsPage.class, WicketUtils.newObjectParameter(EditTicketPage.this.getRepositoryModel().name, "" + ticket.number));
                    }
                } else {
                    EditTicketPage.this.redirectTo(TicketsPage.class, WicketUtils.newObjectParameter(EditTicketPage.this.getRepositoryModel().name, "" + ticket.number));
                }
            }
        }});
        Button cancel = new Button("cancel"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                this.setResponsePage(TicketsPage.class, EditTicketPage.this.getPageParameters());
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.editTicket");
    }

    @Override
    protected Class<? extends BasePage> getRepoNavPageClass() {
        return TicketsPage.class;
    }
}

