/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.FilestoreModel;
import com.gitblit.models.UserModel;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.FilestoreUI;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.FilestoreUsage;
import com.gitblit.wicket.pages.RootPage;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

@CacheControl(value=CacheControl.LastModified.ACTIVITY)
public class FilestorePage
extends RootPage {
    public FilestorePage(PageParameters params) {
        super(params);
        this.setupPage("", "");
        int itemsPerPage = this.app().settings().getInteger("web.itemsPerPage", 20);
        if (itemsPerPage <= 1) {
            itemsPerPage = 20;
        }
        int pageNumber = WicketUtils.getPage(params);
        String filter = WicketUtils.getSearchString(params);
        int prevPage = Math.max(0, pageNumber - 1);
        int nextPage = pageNumber + 1;
        boolean hasMore = false;
        UserModel user = GitBlitWebSession.get().getUser() == null ? UserModel.ANONYMOUS : GitBlitWebSession.get().getUser();
        long nBytesUsed = this.app().filestore().getFilestoreUsedByteCount();
        long nBytesAvailable = this.app().filestore().getFilestoreAvailableByteCount();
        List<FilestoreModel> files = this.app().filestore().getAllObjects(user);
        if (files == null) {
            files = new ArrayList<FilestoreModel>();
        }
        long nOk = 0L;
        long nPending = 0L;
        long nInprogress = 0L;
        long nError = 0L;
        long nDeleted = 0L;
        block6: for (FilestoreModel file : files) {
            switch (file.getStatus()) {
                case Available: {
                    ++nOk;
                    continue block6;
                }
                case Upload_Pending: {
                    ++nPending;
                    continue block6;
                }
                case Upload_In_Progress: {
                    ++nInprogress;
                    continue block6;
                }
                case Deleted: {
                    ++nDeleted;
                    continue block6;
                }
            }
            ++nError;
        }
        BookmarkablePageLink itemOk = new BookmarkablePageLink("filterByOk", FilestorePage.class, WicketUtils.newFilestorePageParameter(prevPage, SortBy.ok.name()));
        BookmarkablePageLink itemPending = new BookmarkablePageLink("filterByPending", FilestorePage.class, WicketUtils.newFilestorePageParameter(prevPage, SortBy.pending.name()));
        BookmarkablePageLink itemInprogress = new BookmarkablePageLink("filterByInprogress", FilestorePage.class, WicketUtils.newFilestorePageParameter(prevPage, SortBy.inprogress.name()));
        BookmarkablePageLink itemError = new BookmarkablePageLink("filterByError", FilestorePage.class, WicketUtils.newFilestorePageParameter(prevPage, SortBy.error.name()));
        BookmarkablePageLink itemDeleted = new BookmarkablePageLink("filterByDeleted", FilestorePage.class, WicketUtils.newFilestorePageParameter(prevPage, SortBy.deleted.name()));
        ArrayList<FilestoreModel> filteredResults = new ArrayList(files.size());
        if (filter == null) {
            filteredResults = files;
        } else if (filter.equals(SortBy.ok.name())) {
            WicketUtils.setCssClass((Component)itemOk, "filter-on");
            for (FilestoreModel item : files) {
                if (item.getStatus() != FilestoreModel.Status.Available) continue;
                filteredResults.add(item);
            }
        } else if (filter.equals(SortBy.pending.name())) {
            WicketUtils.setCssClass((Component)itemPending, "filter-on");
            for (FilestoreModel item : files) {
                if (item.getStatus() != FilestoreModel.Status.Upload_Pending) continue;
                filteredResults.add(item);
            }
        } else if (filter.equals(SortBy.inprogress.name())) {
            WicketUtils.setCssClass((Component)itemInprogress, "filter-on");
            for (FilestoreModel item : files) {
                if (item.getStatus() != FilestoreModel.Status.Upload_In_Progress) continue;
                filteredResults.add(item);
            }
        } else if (filter.equals(SortBy.error.name())) {
            WicketUtils.setCssClass((Component)itemError, "filter-on");
            for (FilestoreModel item : files) {
                if (!item.isInErrorState()) continue;
                filteredResults.add(item);
            }
        } else if (filter.equals(SortBy.deleted.name())) {
            WicketUtils.setCssClass((Component)itemDeleted, "filter-on");
            for (FilestoreModel item : files) {
                if (item.getStatus() != FilestoreModel.Status.Deleted) continue;
                filteredResults.add(item);
            }
        }
        DataView<FilestoreModel> filesView = new DataView<FilestoreModel>("fileRow", (IDataProvider)new SortableFilestoreProvider(filteredResults), itemsPerPage){
            private static final long serialVersionUID = 1L;
            private int counter;

            protected void onBeforeRender() {
                super.onBeforeRender();
                this.counter = 0;
            }

            public void populateItem(Item<FilestoreModel> item) {
                FilestoreModel entry = (FilestoreModel)item.getModelObject();
                SimpleDateFormat dateFormater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                UserModel user = FilestorePage.this.app().users().getUserModel(entry.getChangedBy());
                user = user == null ? UserModel.ANONYMOUS : user;
                Label icon = FilestoreUI.getStatusIcon("status", entry);
                item.add(new Component[]{icon});
                item.add(new Component[]{new Label("on", dateFormater.format(entry.getChangedOn()))});
                item.add(new Component[]{new Label("by", user.getDisplayName())});
                item.add(new Component[]{new Label("oid", entry.oid)});
                item.add(new Component[]{new Label("size", FileUtils.byteCountToDisplaySize((long)entry.getSize()))});
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        if (filteredResults.size() < itemsPerPage) {
            filesView.setCurrentPage(0);
            hasMore = false;
        } else {
            filesView.setCurrentPage(pageNumber - 1);
            hasMore = true;
        }
        this.add(new Component[]{filesView});
        this.add(new Component[]{new BookmarkablePageLink("firstPageBottom", FilestorePage.class).setEnabled(pageNumber > 1)});
        this.add(new Component[]{new BookmarkablePageLink("prevPageBottom", FilestorePage.class, WicketUtils.newFilestorePageParameter(prevPage, filter)).setEnabled(pageNumber > 1)});
        this.add(new Component[]{new BookmarkablePageLink("nextPageBottom", FilestorePage.class, WicketUtils.newFilestorePageParameter(nextPage, filter)).setEnabled(hasMore)});
        itemOk.add(new Component[]{FilestoreUI.getStatusIcon("statusOkIcon", FilestoreModel.Status.Available)});
        itemPending.add(new Component[]{FilestoreUI.getStatusIcon("statusPendingIcon", FilestoreModel.Status.Upload_Pending)});
        itemInprogress.add(new Component[]{FilestoreUI.getStatusIcon("statusInprogressIcon", FilestoreModel.Status.Upload_In_Progress)});
        itemError.add(new Component[]{FilestoreUI.getStatusIcon("statusErrorIcon", FilestoreModel.Status.Error_Unknown)});
        itemDeleted.add(new Component[]{FilestoreUI.getStatusIcon("statusDeletedIcon", FilestoreModel.Status.Deleted)});
        itemOk.add(new Component[]{new Label("statusOkCount", String.valueOf(nOk))});
        itemPending.add(new Component[]{new Label("statusPendingCount", String.valueOf(nPending))});
        itemInprogress.add(new Component[]{new Label("statusInprogressCount", String.valueOf(nInprogress))});
        itemError.add(new Component[]{new Label("statusErrorCount", String.valueOf(nError))});
        itemDeleted.add(new Component[]{new Label("statusDeletedCount", String.valueOf(nDeleted))});
        this.add(new Component[]{itemOk});
        this.add(new Component[]{itemPending});
        this.add(new Component[]{itemInprogress});
        this.add(new Component[]{itemError});
        this.add(new Component[]{itemDeleted});
        this.add(new Component[]{new Label("spaceAvailable", String.format("%s / %s", FileUtils.byteCountToDisplaySize((long)nBytesUsed), FileUtils.byteCountToDisplaySize((long)nBytesAvailable)))});
        BookmarkablePageLink helpLink = new BookmarkablePageLink("filestoreHelp", FilestoreUsage.class);
        helpLink.add(new Component[]{new Label("helpMessage", this.getString("gb.filestoreHelp"))});
        this.add(new Component[]{helpLink});
    }

    private static class SortableFilestoreProvider
    extends SortableDataProvider<FilestoreModel> {
        private static final long serialVersionUID = 1L;
        private List<FilestoreModel> list;

        protected SortableFilestoreProvider(List<FilestoreModel> list) {
            this.list = list;
        }

        public int size() {
            if (this.list == null) {
                return 0;
            }
            return this.list.size();
        }

        public IModel<FilestoreModel> model(FilestoreModel header) {
            return new Model((Serializable)header);
        }

        public Iterator<FilestoreModel> iterator(int first, int count) {
            Collections.sort(this.list, new Comparator<FilestoreModel>(){

                @Override
                public int compare(FilestoreModel o1, FilestoreModel o2) {
                    return o2.getChangedOn().compareTo(o1.getChangedOn());
                }
            });
            return this.list.subList(first, first + count).iterator();
        }
    }

    protected static enum SortBy {
        ok,
        pending,
        inprogress,
        error,
        deleted;

    }
}

