/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.wicket.GitBlitWebApp;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.GitblitRedirectException;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.SummaryPage;
import java.text.MessageFormat;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.slf4j.LoggerFactory;

public class ForkPage
extends RepositoryPage {
    public ForkPage(PageParameters params) {
        super(params);
        this.setVersioned(false);
        GitBlitWebSession session = GitBlitWebSession.get();
        RepositoryModel repository = this.getRepositoryModel();
        UserModel user = session.getUser();
        boolean canFork = user.canFork(repository);
        if (!canFork) {
            GitBlitWebSession.get().cacheErrorMessage(MessageFormat.format(this.getString("gb.forkNotAuthorized"), repository.name));
            throw new GitblitRedirectException(SummaryPage.class, WicketUtils.newRepositoryParameter(repository.name));
        }
        String fork = this.app().repositories().getFork(user.username, repository.name);
        if (fork != null) {
            throw new GitblitRedirectException(SummaryPage.class, WicketUtils.newRepositoryParameter(fork));
        }
        this.add(new Component[]{new Label("forkText", this.getString("gb.preparingFork"))});
        if (!session.isForking()) {
            session.isForking(true);
            ForkThread forker = new ForkThread(this.app(), repository, session);
            forker.start();
        }
    }

    @Override
    protected boolean allowForkControls() {
        return false;
    }

    @Override
    protected String getPageName() {
        return "fork";
    }

    private static class ForkThread
    extends Thread {
        private final GitBlitWebApp app;
        private final RepositoryModel repository;
        private final GitBlitWebSession session;

        public ForkThread(GitBlitWebApp app, RepositoryModel repository, GitBlitWebSession session) {
            this.app = app;
            this.repository = repository;
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            UserModel user = this.session.getUser();
            try {
                this.app.gitblit().fork(this.repository, user);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(ForkPage.class).error(MessageFormat.format("Failed to fork {0} for {1}", this.repository.name, user.username), (Throwable)e);
            }
            finally {
                this.session.isForking(false);
            }
        }
    }
}

