/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.panels.HistoryPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;

@CacheControl(value=CacheControl.LastModified.REPOSITORY)
public class HistoryPage
extends RepositoryPage {
    public HistoryPage(PageParameters params) {
        super(params);
        String path = WicketUtils.getPath(params);
        int pageNumber = WicketUtils.getPage(params);
        int prevPage = Math.max(0, pageNumber - 1);
        int nextPage = pageNumber + 1;
        HistoryPanel history = new HistoryPanel("historyPanel", this.repositoryName, this.objectId, path, this.getRepository(), -1, pageNumber - 1, this.getRepositoryModel().showRemoteBranches);
        boolean hasMore = history.hasMore();
        this.add(new Component[]{history});
        this.add(new Component[]{new BookmarkablePageLink("firstPageTop", HistoryPage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, path)).setEnabled(pageNumber > 1)});
        this.add(new Component[]{new BookmarkablePageLink("prevPageTop", HistoryPage.class, WicketUtils.newHistoryPageParameter(this.repositoryName, this.objectId, path, prevPage)).setEnabled(pageNumber > 1)});
        this.add(new Component[]{new BookmarkablePageLink("nextPageTop", HistoryPage.class, WicketUtils.newHistoryPageParameter(this.repositoryName, this.objectId, path, nextPage)).setEnabled(hasMore)});
        this.add(new Component[]{new BookmarkablePageLink("firstPageBottom", HistoryPage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, path)).setEnabled(pageNumber > 1)});
        this.add(new Component[]{new BookmarkablePageLink("prevPageBottom", HistoryPage.class, WicketUtils.newHistoryPageParameter(this.repositoryName, this.objectId, path, prevPage)).setEnabled(pageNumber > 1)});
        this.add(new Component[]{new BookmarkablePageLink("nextPageBottom", HistoryPage.class, WicketUtils.newHistoryPageParameter(this.repositoryName, this.objectId, path, nextPage)).setEnabled(hasMore)});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.history");
    }

    @Override
    protected boolean isCommitPage() {
        return true;
    }

    @Override
    protected Class<? extends BasePage> getRepoNavPageClass() {
        return TreePage.class;
    }
}

