/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.servlet.RawServlet;
import com.gitblit.utils.DiffUtils;
import com.gitblit.utils.HtmlBuilder;
import com.gitblit.wicket.pages.BasePage;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WicketURLEncoder;
import org.eclipse.jgit.diff.DiffEntry;
import org.jsoup.nodes.Element;

public class ImageDiffHandler
implements DiffUtils.BinaryDiffHandler {
    private final String oldCommitId;
    private final String newCommitId;
    private final String repositoryName;
    private final BasePage page;
    private final List<String> imageExtensions;
    private int imgDiffCount = 0;

    public ImageDiffHandler(BasePage page, String repositoryName, String oldCommitId, String newCommitId, List<String> imageExtensions) {
        this.page = page;
        this.repositoryName = repositoryName;
        this.oldCommitId = oldCommitId;
        this.newCommitId = newCommitId;
        this.imageExtensions = imageExtensions;
    }

    @Override
    public String renderBinaryDiff(DiffEntry diffEntry) {
        switch (diffEntry.getChangeType()) {
            case MODIFY: 
            case RENAME: 
            case COPY: {
                String oldUrl = this.getImageUrl(diffEntry, DiffEntry.Side.OLD);
                String newUrl = this.getImageUrl(diffEntry, DiffEntry.Side.NEW);
                if (oldUrl == null || newUrl == null) break;
                ++this.imgDiffCount;
                String id = "imgdiff" + this.imgDiffCount;
                HtmlBuilder builder = new HtmlBuilder("div");
                Element wrapper = builder.root().attr("class", "imgdiff-container").attr("id", "imgdiff-" + id);
                Element container2 = wrapper.appendElement("div").attr("class", "imgdiff-ovr-slider").appendElement("div").attr("class", "imgdiff");
                Element old = container2.appendElement("div").attr("class", "imgdiff-left");
                old.appendElement("img").attr("class", "imgdiff-old").attr("id", id).attr("style", "max-width:640px;").attr("src", oldUrl);
                container2.appendElement("img").attr("class", "imgdiff").attr("style", "max-width:640px;").attr("src", newUrl);
                wrapper.appendElement("br");
                Element controls = wrapper.appendElement("div");
                controls.appendElement("div").attr("class", "imgdiff-opa-container").appendElement("a").attr("class", "imgdiff-opa-slider").attr("href", "#").attr("title", this.page.getString("gb.opacityAdjust"));
                controls.appendElement("a").attr("class", "imgdiff-link imgdiff-blink").attr("href", "#").attr("title", this.page.getString("gb.blinkComparator")).appendElement("img").attr("src", this.getStaticResourceUrl("blink32.png")).attr("width", "20");
                controls.appendElement("a").attr("class", "imgdiff-link imgdiff-subtract").attr("href", "#").attr("title", this.page.getString("gb.imgdiffSubtract")).attr("style", "display:none;").appendElement("img").attr("src", this.getStaticResourceUrl("sub32.png")).attr("width", "20");
                return builder.toString();
            }
            case ADD: {
                String url = this.getImageUrl(diffEntry, DiffEntry.Side.NEW);
                if (url == null) break;
                return new HtmlBuilder("img").root().attr("class", "diff-img").attr("src", url).toString();
            }
        }
        return null;
    }

    public int getImgDiffCount() {
        return this.imgDiffCount;
    }

    protected String getImageUrl(DiffEntry entry, DiffEntry.Side side) {
        String path = entry.getPath(side);
        int i = path.lastIndexOf(46);
        if (i > 0) {
            String extension = path.substring(i + 1);
            for (String ext : this.imageExtensions) {
                String commitId;
                if (!ext.equalsIgnoreCase(extension)) continue;
                String string = commitId = DiffEntry.Side.NEW.equals((Object)side) ? this.newCommitId : this.oldCommitId;
                if (commitId != null) {
                    return RawServlet.asLink(this.page.getContextUrl(), this.urlencode(this.repositoryName), commitId, this.urlencode(path));
                }
                return null;
            }
        }
        return null;
    }

    protected String getStaticResourceUrl(String contextRelativePath) {
        return WebApplication.get().getRequestCycleProcessor().getRequestCodingStrategy().rewriteStaticRelativeUrl(contextRelativePath);
    }

    protected String urlencode(String component) {
        return WicketURLEncoder.PATH_INSTANCE.encode(component, StandardCharsets.UTF_8.name()).replaceAll("%2[fF]", "/");
    }
}

