/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.panels.LogPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;

@CacheControl(value=CacheControl.LastModified.REPOSITORY)
public class LogPage
extends RepositoryPage {
    public LogPage(PageParameters params) {
        super(params);
        this.addSyndicationDiscoveryLink();
        int pageNumber = WicketUtils.getPage(params);
        int prevPage = Math.max(0, pageNumber - 1);
        int nextPage = pageNumber + 1;
        String refid = this.objectId;
        if (StringUtils.isEmpty(refid)) {
            refid = this.getRepositoryModel().HEAD;
        }
        LogPanel logPanel = new LogPanel("logPanel", this.repositoryName, refid, this.getRepository(), -1, pageNumber - 1, this.getRepositoryModel().showRemoteBranches);
        boolean hasMore = logPanel.hasMore();
        this.add(new Component[]{logPanel});
        this.add(new Component[]{new BookmarkablePageLink("firstPageTop", LogPage.class, WicketUtils.newObjectParameter(this.repositoryName, this.objectId)).setEnabled(pageNumber > 1)});
        this.add(new Component[]{new BookmarkablePageLink("prevPageTop", LogPage.class, WicketUtils.newLogPageParameter(this.repositoryName, this.objectId, prevPage)).setEnabled(pageNumber > 1)});
        this.add(new Component[]{new BookmarkablePageLink("nextPageTop", LogPage.class, WicketUtils.newLogPageParameter(this.repositoryName, this.objectId, nextPage)).setEnabled(hasMore)});
        this.add(new Component[]{new BookmarkablePageLink("firstPageBottom", LogPage.class, WicketUtils.newObjectParameter(this.repositoryName, this.objectId)).setEnabled(pageNumber > 1)});
        this.add(new Component[]{new BookmarkablePageLink("prevPageBottom", LogPage.class, WicketUtils.newLogPageParameter(this.repositoryName, this.objectId, prevPage)).setEnabled(pageNumber > 1)});
        this.add(new Component[]{new BookmarkablePageLink("nextPageBottom", LogPage.class, WicketUtils.newLogPageParameter(this.repositoryName, this.objectId, nextPage)).setEnabled(hasMore)});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.log");
    }

    @Override
    protected boolean isCommitPage() {
        return true;
    }
}

