/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.ProjectModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.MarkdownUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.DashboardPage;
import com.gitblit.wicket.panels.FilterableProjectList;
import com.gitblit.wicket.panels.FilterableRepositoryList;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;

@CacheControl(value=CacheControl.LastModified.ACTIVITY)
public class MyDashboardPage
extends DashboardPage {
    public MyDashboardPage() {
        this.setup(null);
    }

    public MyDashboardPage(PageParameters params) {
        super(params);
        this.setup(params);
    }

    @Override
    protected boolean reusePageParameters() {
        return true;
    }

    private void setup(PageParameters params) {
        FilterableRepositoryList repoList;
        String activityTitle;
        this.setupPage("", "");
        boolean authenticateView = this.app().settings().getBoolean("web.authenticateViewPages", true);
        if (authenticateView && !GitBlitWebSession.get().isLoggedIn()) {
            String messageSource = this.app().settings().getString("web.loginMessage", "gitblit");
            String message = this.readMarkdown(messageSource, "login.mkd");
            Label repositoriesMessage = new Label("repositoriesMessage", message);
            this.add(new Component[]{repositoriesMessage.setEscapeModelStrings(false)});
            this.add(new Component[]{new Label("activity").setVisible(false)});
            this.add(new Component[]{new Label("repositoryTabs").setVisible(false)});
            return;
        }
        String messageSource = this.app().settings().getString("web.repositoriesMessage", "gitblit");
        String message = this.readMarkdown(messageSource, "welcome.mkd");
        Component repositoriesMessage = new Label("repositoriesMessage", message).setEscapeModelStrings(false).setVisible(message.length() > 0);
        this.add(new Component[]{repositoriesMessage});
        UserModel user = GitBlitWebSession.get().getUser();
        if (user == null) {
            user = UserModel.ANONYMOUS;
        }
        int daysBack = params == null ? 0 : WicketUtils.getDaysBack(params);
        int maxDaysBack = this.app().settings().getInteger("web.activityDurationMaximum", 30);
        if (daysBack < 1) {
            daysBack = this.app().settings().getInteger("web.activityDuration", 7);
        }
        if (maxDaysBack > 0 && daysBack > maxDaysBack) {
            daysBack = maxDaysBack;
        }
        Calendar c = Calendar.getInstance();
        c.add(5, -1 * daysBack);
        Date minimumDate = c.getTime();
        ArrayList<RepositoryModel> starred = new ArrayList<RepositoryModel>();
        ArrayList<RepositoryModel> owned = new ArrayList<RepositoryModel>();
        ArrayList<RepositoryModel> active = new ArrayList<RepositoryModel>();
        for (RepositoryModel model : this.getRepositoryModels()) {
            if (model.isUsersPersonalRepository(user.username) || model.isOwner(user.username)) {
                owned.add(model);
            }
            if (user.getPreferences().isStarredRepository(model.name)) {
                starred.add(model);
            }
            if (!model.isShowActivity() || !model.lastChange.after(minimumDate)) continue;
            active.add(model);
        }
        Comparator<RepositoryModel> lastUpdateSort = new Comparator<RepositoryModel>(){

            @Override
            public int compare(RepositoryModel o1, RepositoryModel o2) {
                return o2.lastChange.compareTo(o1.lastChange);
            }
        };
        Collections.sort(owned, lastUpdateSort);
        Collections.sort(starred, lastUpdateSort);
        Collections.sort(active, lastUpdateSort);
        HashSet<RepositoryModel> feed = new HashSet<RepositoryModel>();
        feed.addAll(starred);
        feed.addAll(owned);
        if (feed.isEmpty()) {
            activityTitle = this.getString("gb.recentActivity");
            feed.addAll(active);
        } else {
            activityTitle = starred.isEmpty() ? this.getString("gb.owned") : (owned.isEmpty() ? this.getString("gb.starred") : this.getString("gb.starredAndOwned"));
        }
        this.addActivity(user, feed, activityTitle, daysBack);
        Fragment repositoryTabs = UserModel.ANONYMOUS.equals(user) ? new Fragment("repositoryTabs", "anonymousTabsFragment", (MarkupContainer)this) : new Fragment("repositoryTabs", "authenticatedTabsFragment", (MarkupContainer)this);
        this.add(new Component[]{repositoryTabs});
        List<ProjectModel> projects = this.app().projects().getProjectModels(this.getRepositoryModels(), false);
        repositoryTabs.add(new Component[]{new FilterableProjectList("projects", projects)});
        if (active.isEmpty()) {
            repositoryTabs.add(new Component[]{new Label("active").setVisible(false)});
        } else {
            repoList = new FilterableRepositoryList("active", active);
            repoList.setTitle(this.getString("gb.activeRepositories"), "icon-time");
            repositoryTabs.add(new Component[]{repoList});
        }
        if (ArrayUtils.isEmpty(starred)) {
            repositoryTabs.add(new Component[]{new Label("starred").setVisible(false)});
        } else {
            repoList = new FilterableRepositoryList("starred", starred);
            repoList.setTitle(this.getString("gb.starredRepositories"), "icon-star");
            repositoryTabs.add(new Component[]{repoList});
        }
        if (ArrayUtils.isEmpty(owned)) {
            repositoryTabs.add(new Component[]{new Label("owned").setVisible(false)});
        } else {
            repoList = new FilterableRepositoryList("owned", owned);
            repoList.setTitle(this.getString("gb.myRepositories"), "icon-user");
            repoList.setAllowCreate(user.canCreate() || user.canAdmin());
            repositoryTabs.add(new Component[]{repoList});
        }
    }

    private String readMarkdown(String messageSource, String resource) {
        String message = "";
        if (messageSource.equalsIgnoreCase("gitblit")) {
            message = this.readDefaultMarkdown(resource);
        } else if (!StringUtils.isEmpty(messageSource)) {
            File file = this.app().runtime().getFileOrFolder(messageSource);
            if (file.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(file);
                    InputStreamReader reader = new InputStreamReader((InputStream)fis, "UTF-8");
                    message = MarkdownUtils.transformMarkdown(reader);
                    reader.close();
                }
                catch (Throwable t) {
                    message = this.getString("gb.failedToRead") + " " + file;
                    this.warn(message, t);
                }
            } else {
                message = messageSource + " " + this.getString("gb.isNotValidFile");
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readDefaultMarkdown(String file) {
        String string;
        InputStream is;
        InputStreamReader reader;
        String base = file.substring(0, file.lastIndexOf(46));
        String ext = file.substring(file.lastIndexOf(46));
        String lc = this.getLanguageCode();
        String cc = this.getCountryCode();
        ArrayList<String> files = new ArrayList<String>();
        if (!StringUtils.isEmpty(lc)) {
            if (!StringUtils.isEmpty(cc)) {
                files.add(base + "_" + lc + "-" + cc + ext);
                files.add(base + "_" + lc + "_" + cc.toUpperCase() + ext);
            }
            files.add(base + "_" + lc + ext);
        }
        files.add(file);
        Iterator i$ = files.iterator();
        while (true) {
            if (!i$.hasNext()) {
                return MessageFormat.format(this.getString("gb.failedToReadMessage"), file);
            }
            String name = (String)i$.next();
            reader = null;
            try {
                is = ((Object)((Object)this)).getClass().getResourceAsStream("/" + name);
                if (is != null) break;
                if (reader == null) continue;
            }
            catch (Throwable t) {
                try {
                    String message = MessageFormat.format(this.getString("gb.failedToReadMessage"), file);
                    this.error(message, t, false);
                    String string2 = message;
                    return string2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        {
            reader = new InputStreamReader(is, "UTF-8");
            String message = MarkdownUtils.transformMarkdown(reader);
            reader.close();
            string = message;
            if (reader == null) return string;
        }
        try {
            reader.close();
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }
}

