/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TicketModel;
import com.gitblit.models.UserModel;
import com.gitblit.tickets.QueryBuilder;
import com.gitblit.tickets.QueryResult;
import com.gitblit.tickets.TicketIndexer;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.TicketsUI;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RootPage;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.TicketListPanel;
import com.gitblit.wicket.panels.TicketSearchForm;
import com.gitblit.wicket.panels.UserTitlePanel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;

public class MyTicketsPage
extends RootPage {
    public MyTicketsPage() {
        this(null);
    }

    public MyTicketsPage(PageParameters params) {
        super(params);
        String repositoryId;
        this.setupPage("", this.getString("gb.myTickets"));
        UserModel currentUser = GitBlitWebSession.get().getUser();
        if (currentUser == null || UserModel.ANONYMOUS.equals(currentUser)) {
            this.setRedirect(true);
            this.setResponsePage(this.getApplication().getHomePage());
            return;
        }
        String username = currentUser.getName();
        Object[] statiiParam = params == null ? TicketsUI.openStatii : params.getStringArray(TicketIndexer.Lucene.status.name());
        final String assignedToParam = params == null ? "" : params.getString(TicketIndexer.Lucene.responsible.name(), null);
        final String milestoneParam = params == null ? "" : params.getString(TicketIndexer.Lucene.milestone.name(), null);
        final String queryParam = params == null ? null : params.getString("q", null);
        String searchParam = params == null ? "" : params.getString("s", null);
        final String sortBy = params == null ? "" : TicketIndexer.Lucene.fromString(params.getString("sort", TicketIndexer.Lucene.created.name())).name();
        String string = repositoryId = params == null ? "" : params.getString(TicketIndexer.Lucene.rid.name(), null);
        final boolean desc = params == null ? true : !"asc".equals(params.getString("direction", "desc"));
        this.add(new Component[]{new UserTitlePanel("userTitlePanel", currentUser, this.getString("gb.myTickets"))});
        this.add(new Component[]{new TicketSearchForm("ticketSearchForm", null, searchParam, ((Object)((Object)this)).getClass(), params)});
        this.add(new Component[]{new BookmarkablePageLink("changesQuery", MyTicketsPage.class, this.queryParameters(TicketIndexer.Lucene.type.matches(TicketModel.Type.Proposal.name()), milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, repositoryId, 1))});
        this.add(new Component[]{new BookmarkablePageLink("bugsQuery", MyTicketsPage.class, this.queryParameters(TicketIndexer.Lucene.type.matches(TicketModel.Type.Bug.name()), milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, repositoryId, 1))});
        this.add(new Component[]{new BookmarkablePageLink("enhancementsQuery", MyTicketsPage.class, this.queryParameters(TicketIndexer.Lucene.type.matches(TicketModel.Type.Enhancement.name()), milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, repositoryId, 1))});
        this.add(new Component[]{new BookmarkablePageLink("tasksQuery", MyTicketsPage.class, this.queryParameters(TicketIndexer.Lucene.type.matches(TicketModel.Type.Task.name()), milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, repositoryId, 1))});
        this.add(new Component[]{new BookmarkablePageLink("questionsQuery", MyTicketsPage.class, this.queryParameters(TicketIndexer.Lucene.type.matches(TicketModel.Type.Question.name()), milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, repositoryId, 1))});
        this.add(new Component[]{new BookmarkablePageLink("maintenanceQuery", MyTicketsPage.class, this.queryParameters(TicketIndexer.Lucene.type.matches(TicketModel.Type.Maintenance.name()), milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, repositoryId, 1))});
        this.add(new Component[]{new BookmarkablePageLink("resetQuery", MyTicketsPage.class, this.queryParameters(null, milestoneParam, TicketsUI.openStatii, null, null, true, null, 1))});
        this.add(new Component[]{new Label("userDivider")});
        this.add(new Component[]{new BookmarkablePageLink("createdQuery", MyTicketsPage.class, this.queryParameters(TicketIndexer.Lucene.createdby.matches(username), milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, repositoryId, 1))});
        this.add(new Component[]{new BookmarkablePageLink("watchedQuery", MyTicketsPage.class, this.queryParameters(TicketIndexer.Lucene.watchedby.matches(username), milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, repositoryId, 1))});
        this.add(new Component[]{new BookmarkablePageLink("mentionsQuery", MyTicketsPage.class, this.queryParameters(TicketIndexer.Lucene.mentions.matches(username), milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, repositoryId, 1))});
        this.add(new Component[]{new BookmarkablePageLink("responsibleQuery", MyTicketsPage.class, this.queryParameters(TicketIndexer.Lucene.responsible.matches(username), milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, repositoryId, 1))});
        if (ArrayUtils.isEmpty(statiiParam)) {
            this.add(new Component[]{new Label("selectedStatii", this.getString("gb.all"))});
        } else {
            this.add(new Component[]{new Label("selectedStatii", StringUtils.flattenStrings(Arrays.asList(statiiParam), ","))});
        }
        this.add(new Component[]{new BookmarkablePageLink("openTickets", MyTicketsPage.class, this.queryParameters(queryParam, milestoneParam, TicketsUI.openStatii, assignedToParam, sortBy, desc, repositoryId, 1))});
        this.add(new Component[]{new BookmarkablePageLink("closedTickets", MyTicketsPage.class, this.queryParameters(queryParam, milestoneParam, TicketsUI.closedStatii, assignedToParam, sortBy, desc, repositoryId, 1))});
        this.add(new Component[]{new BookmarkablePageLink("allTickets", MyTicketsPage.class, this.queryParameters(queryParam, milestoneParam, null, assignedToParam, sortBy, desc, repositoryId, 1))});
        ArrayList<TicketModel.Status> statii = new ArrayList<TicketModel.Status>(Arrays.asList(TicketModel.Status.values()));
        statii.remove((Object)TicketModel.Status.Closed);
        ListDataProvider resolutionsDp = new ListDataProvider(statii);
        DataView<TicketModel.Status> statiiLinks = new DataView<TicketModel.Status>("statii", (IDataProvider)resolutionsDp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<TicketModel.Status> item) {
                TicketModel.Status status = (TicketModel.Status)((Object)item.getModelObject());
                PageParameters p = MyTicketsPage.this.queryParameters(queryParam, milestoneParam, new String[]{status.name().toLowerCase()}, assignedToParam, sortBy, desc, repositoryId, 1);
                String css = TicketsUI.getStatusClass(status);
                item.add(new Component[]{new LinkPanel("statusLink", css, status.toString(), MyTicketsPage.class, p).setRenderBodyOnly(true)});
            }
        };
        this.add(new Component[]{statiiLinks});
        ArrayList<TicketsUI.TicketSort> sortChoices = new ArrayList<TicketsUI.TicketSort>();
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortNewest"), TicketIndexer.Lucene.created.name(), true));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortOldest"), TicketIndexer.Lucene.created.name(), false));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortMostRecentlyUpdated"), TicketIndexer.Lucene.updated.name(), true));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortLeastRecentlyUpdated"), TicketIndexer.Lucene.updated.name(), false));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortMostComments"), TicketIndexer.Lucene.comments.name(), true));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortLeastComments"), TicketIndexer.Lucene.comments.name(), false));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortMostPatchsetRevisions"), TicketIndexer.Lucene.patchsets.name(), true));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortLeastPatchsetRevisions"), TicketIndexer.Lucene.patchsets.name(), false));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortMostVotes"), TicketIndexer.Lucene.votes.name(), true));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortLeastVotes"), TicketIndexer.Lucene.votes.name(), false));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortHighestPriority"), TicketIndexer.Lucene.priority.name(), true));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortLowestPriority"), TicketIndexer.Lucene.priority.name(), false));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortHighestSeverity"), TicketIndexer.Lucene.severity.name(), true));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortLowestSeverity"), TicketIndexer.Lucene.severity.name(), false));
        TicketsUI.TicketSort currentSort = (TicketsUI.TicketSort)sortChoices.get(0);
        for (TicketsUI.TicketSort ts : sortChoices) {
            if (!ts.sortBy.equals(sortBy) || desc != ts.desc) continue;
            currentSort = ts;
            break;
        }
        this.add(new Component[]{new Label("currentSort", currentSort.name)});
        ListDataProvider sortChoicesDp = new ListDataProvider(sortChoices);
        DataView<TicketsUI.TicketSort> sortMenu = new DataView<TicketsUI.TicketSort>("sort", (IDataProvider)sortChoicesDp, (String[])statiiParam, assignedToParam, repositoryId){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ String[] val$statiiParam;
            final /* synthetic */ String val$assignedToParam;
            final /* synthetic */ String val$repositoryId;
            {
                this.val$statiiParam = stringArray;
                this.val$assignedToParam = string3;
                this.val$repositoryId = string4;
                super(x0, x1);
            }

            public void populateItem(Item<TicketsUI.TicketSort> item) {
                TicketsUI.TicketSort ts = (TicketsUI.TicketSort)item.getModelObject();
                PageParameters params = MyTicketsPage.this.queryParameters(queryParam, milestoneParam, this.val$statiiParam, this.val$assignedToParam, ts.sortBy, ts.desc, this.val$repositoryId, 1);
                item.add(new Component[]{new LinkPanel("sortLink", null, ts.name, MyTicketsPage.class, params).setRenderBodyOnly(true)});
            }
        };
        this.add(new Component[]{sortMenu});
        List<QueryResult> tickets2 = this.query(this.initializeQueryBuilder(null, username), 1, Integer.MAX_VALUE, sortBy, desc);
        List<RepositoryModel> repositoryChoices = this.correspondingRepositories(tickets2);
        Collections.sort(repositoryChoices);
        final RepositoryModel noneChoice = new RepositoryModel();
        noneChoice.name = this.getString("gb.all");
        repositoryChoices.add(0, noneChoice);
        RepositoryModel currentRepository = repositoryChoices.get(0);
        for (RepositoryModel r : repositoryChoices) {
            if (!r.getRID().equals(repositoryId)) continue;
            currentRepository = r;
            break;
        }
        this.add(new Component[]{new Label("currentRepository", currentRepository.toString())});
        ListDataProvider repositoryChoicesDp = new ListDataProvider(repositoryChoices);
        DataView<RepositoryModel> repositoryMenu = new DataView<RepositoryModel>("repository", (IDataProvider)repositoryChoicesDp, (String[])statiiParam, assignedToParam, sortBy, desc){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ String[] val$statiiParam;
            final /* synthetic */ String val$assignedToParam;
            final /* synthetic */ String val$sortBy;
            final /* synthetic */ boolean val$desc;
            {
                this.val$statiiParam = stringArray;
                this.val$assignedToParam = string3;
                this.val$sortBy = string4;
                this.val$desc = bl;
                super(x0, x1);
            }

            public void populateItem(Item<RepositoryModel> item) {
                RepositoryModel r = (RepositoryModel)item.getModelObject();
                String rid = r == noneChoice ? null : r.getRID();
                PageParameters params = MyTicketsPage.this.queryParameters(queryParam, milestoneParam, this.val$statiiParam, this.val$assignedToParam, this.val$sortBy, this.val$desc, rid, 1);
                item.add(new Component[]{new LinkPanel("repositoryLink", null, r.toString(), MyTicketsPage.class, params).setRenderBodyOnly(true)});
            }
        };
        this.add(new Component[]{repositoryMenu});
        QueryBuilder qb = this.initializeQueryBuilder(queryParam, username);
        if (!qb.containsField(TicketIndexer.Lucene.status.name()) && !ArrayUtils.isEmpty(statiiParam)) {
            boolean not = false;
            QueryBuilder q = new QueryBuilder();
            for (Object state : statiiParam) {
                if (((String)state).charAt(0) == '!') {
                    not = true;
                    q.and(TicketIndexer.Lucene.status.doesNotMatch(((String)state).substring(1)));
                    continue;
                }
                q.or(TicketIndexer.Lucene.status.matches((String)state));
            }
            if (not) {
                qb.and(q.toString());
            } else {
                qb.and(q.toSubquery().toString());
            }
        }
        if (noneChoice != currentRepository && !qb.containsField(TicketIndexer.Lucene.rid.name())) {
            QueryBuilder q1 = new QueryBuilder();
            q1.and(TicketIndexer.Lucene.rid.matches(repositoryId));
            qb.and(q1.toSubquery().toString());
        }
        int page = params != null ? Math.max(1, WicketUtils.getPage(params)) : 1;
        int pageSize = this.app().settings().getInteger("tickets.perPage", 25);
        List<QueryResult> allResults = StringUtils.isEmpty(searchParam) ? this.query(qb, page, pageSize, sortBy, desc) : this.search(searchParam, page, pageSize);
        ArrayList<QueryResult> viewableResults = new ArrayList<QueryResult>(allResults.size());
        for (QueryResult queryResult : allResults) {
            RepositoryModel model = this.app().repositories().getRepositoryModel(currentUser, queryResult.repository);
            if (model == null || !currentUser.canView(model)) continue;
            viewableResults.add(queryResult);
        }
        int totalResults = viewableResults.size() == 0 ? 0 : ((QueryResult)viewableResults.get((int)0)).totalResults;
        this.buildPager(queryParam, milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, repositoryId, page, pageSize, viewableResults.size(), totalResults);
        boolean showSwatch = this.app().settings().getBoolean("web.repositoryListSwatches", true);
        this.add(new Component[]{new TicketListPanel("ticketList", viewableResults, showSwatch, true)});
    }

    protected PageParameters queryParameters(String query, String milestone, String[] states, String assignedTo, String sort, boolean descending, String repositoryId, int page) {
        PageParameters params = WicketUtils.newRepositoryParameter("");
        if (!StringUtils.isEmpty(query)) {
            params.add("q", query);
        }
        if (!StringUtils.isEmpty(milestone)) {
            params.add(TicketIndexer.Lucene.milestone.name(), milestone);
        }
        if (!ArrayUtils.isEmpty(states)) {
            for (String state : states) {
                params.add(TicketIndexer.Lucene.status.name(), state);
            }
        }
        if (!StringUtils.isEmpty(assignedTo)) {
            params.add(TicketIndexer.Lucene.responsible.name(), assignedTo);
        }
        if (!StringUtils.isEmpty(sort)) {
            params.add("sort", sort);
        }
        if (!descending) {
            params.add("direction", "asc");
        }
        if (!StringUtils.isEmpty(repositoryId)) {
            params.add(TicketIndexer.Lucene.rid.name(), repositoryId);
        }
        if (page > 1) {
            params.add("pg", "" + page);
        }
        return params;
    }

    protected void buildPager(final String query, final String milestone, final String[] states, final String assignedTo, final String sort, final boolean desc, final String repositoryId, final int page, int pageSize, int count, int total) {
        int segments;
        boolean showNav = total > 2 * pageSize;
        boolean allowPrev = page > 1;
        boolean allowNext = pageSize * (page - 1) + count < total;
        this.add(new Component[]{new BookmarkablePageLink("prevLink", MyTicketsPage.class, this.queryParameters(query, milestone, states, assignedTo, sort, desc, repositoryId, page - 1)).setEnabled(allowPrev).setVisible(showNav)});
        this.add(new Component[]{new BookmarkablePageLink("nextLink", MyTicketsPage.class, this.queryParameters(query, milestone, states, assignedTo, sort, desc, repositoryId, page + 1)).setEnabled(allowNext).setVisible(showNav)});
        if (total <= pageSize) {
            this.add(new Component[]{new Label("pageLink").setVisible(false)});
            return;
        }
        int pages = count == 0 ? 0 : total / pageSize + (total % pageSize == 0 ? 0 : 1);
        if (pages < (segments = 5)) {
            segments = pages;
        }
        int minpage = Math.min(Math.max(1, page - 2), pages - (segments - 1));
        int maxpage = Math.min(pages, minpage + (segments - 1));
        ArrayList<Integer> sequence = new ArrayList<Integer>();
        for (int i = minpage; i <= maxpage; ++i) {
            sequence.add(i);
        }
        ListDataProvider pagesDp = new ListDataProvider(sequence);
        DataView<Integer> pagesView = new DataView<Integer>("pageLink", (IDataProvider)pagesDp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<Integer> item) {
                Integer i = (Integer)item.getModelObject();
                LinkPanel link = new LinkPanel("page", null, "" + i, MyTicketsPage.class, MyTicketsPage.this.queryParameters(query, milestone, states, assignedTo, sort, desc, repositoryId, i));
                link.setRenderBodyOnly(true);
                if (i == page) {
                    WicketUtils.setCssClass(item, "active");
                }
                item.add(new Component[]{link});
            }
        };
        this.add(new Component[]{pagesView});
    }

    private QueryBuilder initializeQueryBuilder(String queryparam, String username) {
        QueryBuilder qb = new QueryBuilder(queryparam);
        if (qb.containsField(TicketIndexer.Lucene.createdby.name()) || qb.containsField(TicketIndexer.Lucene.responsible.name()) || qb.containsField(TicketIndexer.Lucene.watchedby.name()) || qb.containsField(TicketIndexer.Lucene.mentions.name())) {
            return qb;
        }
        return qb.andSubquery().or(TicketIndexer.Lucene.createdby.matches(username)).or(TicketIndexer.Lucene.responsible.matches(username)).or(TicketIndexer.Lucene.watchedby.matches(username)).or(TicketIndexer.Lucene.mentions.matches(username)).endSubquery();
    }

    private List<QueryResult> query(QueryBuilder qb, int page, int pageSize, String sortBy, boolean descending) {
        return this.app().tickets().queryFor(qb.build(), page, pageSize, sortBy, descending);
    }

    private List<QueryResult> search(String searchParam, int page, int pageSize) {
        return this.app().tickets().searchFor(null, searchParam, page, pageSize);
    }

    private List<RepositoryModel> correspondingRepositories(Collection<QueryResult> tickets2) {
        HashMap<String, RepositoryModel> result = new HashMap<String, RepositoryModel>();
        for (QueryResult ticket : tickets2) {
            RepositoryModel repository = this.app().repositories().getRepositoryModel(ticket.repository);
            if (result.containsKey(repository.getRID())) continue;
            result.put(repository.getRID(), repository);
        }
        return new ArrayList<RepositoryModel>(result.values());
    }
}

