/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.Metric;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.JGitUtils;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.charting.Chart;
import com.gitblit.wicket.charting.Charts;
import com.gitblit.wicket.charting.Flotr2Charts;
import com.gitblit.wicket.pages.MetricsPage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.UserPage;
import com.gitblit.wicket.panels.BranchesPanel;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.ReflogPanel;
import com.gitblit.wicket.panels.RepositoryUrlPanel;
import com.gitblit.wicket.panels.TagsPanel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.eclipse.jgit.lib.Repository;

@CacheControl(value=CacheControl.LastModified.REPOSITORY)
public class OverviewPage
extends RepositoryPage {
    public OverviewPage(PageParameters params) {
        super(params);
        int numberRefs = this.app().settings().getInteger("web.summaryRefsCount", 5);
        Repository r = this.getRepository();
        RepositoryModel model = this.getRepositoryModel();
        UserModel user = GitBlitWebSession.get().getUser();
        if (user == null) {
            user = UserModel.ANONYMOUS;
        }
        List<Metric> metrics = null;
        Metric metricsTotal = null;
        if (!model.skipSummaryMetrics && this.app().settings().getBoolean("web.generateActivityGraph", true)) {
            metrics = this.app().repositories().getRepositoryDefaultMetrics(model, r);
            metricsTotal = metrics.remove(0);
        }
        this.addSyndicationDiscoveryLink();
        this.add(new Component[]{new Label("repositoryDescription", this.getRepositoryModel().description)});
        final ArrayList<String> owners = new ArrayList<String>(this.getRepositoryModel().owners);
        ListDataProvider ownersDp = new ListDataProvider(owners);
        DataView<String> ownersView = new DataView<String>("repositoryOwners", (IDataProvider)ownersDp){
            private static final long serialVersionUID = 1L;
            int counter;
            {
                super(x0, x1);
                this.counter = 0;
            }

            public void populateItem(Item<String> item) {
                String ownername = (String)item.getModelObject();
                UserModel ownerModel = OverviewPage.this.app().users().getUserModel(ownername);
                if (ownerModel != null) {
                    item.add(new Component[]{new LinkPanel("owner", null, ownerModel.getDisplayName(), UserPage.class, WicketUtils.newUsernameParameter(ownerModel.username)).setRenderBodyOnly(true)});
                } else {
                    Label owner = new Label("owner", ownername);
                    WicketUtils.setCssStyle((Component)owner, "text-decoration: line-through;");
                    WicketUtils.setHtmlTooltip((Component)owner, MessageFormat.format(this.getString("gb.failedToFindAccount"), ownername));
                    item.add(new Component[]{owner});
                }
                ++this.counter;
                item.add(new Component[]{new Label("comma", ",").setVisible(this.counter < owners.size())});
                item.setRenderBodyOnly(true);
            }
        };
        ownersView.setRenderBodyOnly(true);
        this.add(new Component[]{ownersView});
        this.add(new Component[]{WicketUtils.createTimestampLabel("repositoryLastChange", JGitUtils.getLastChange((Repository)r).when, this.getTimeZone(), this.getTimeUtils())});
        this.add(new Component[]{new Label("repositorySize", model.size)});
        if (metricsTotal == null) {
            this.add(new Component[]{new Label("branchStats", "")});
        } else {
            this.add(new Component[]{new Label("branchStats", MessageFormat.format(this.getString("gb.branchStats"), metricsTotal.count, metricsTotal.tag, this.getTimeUtils().duration(metricsTotal.duration)))});
        }
        this.add(new Component[]{new BookmarkablePageLink("metrics", MetricsPage.class, WicketUtils.newRepositoryParameter(this.repositoryName))});
        this.add(new Component[]{new RepositoryUrlPanel("repositoryUrlPanel", false, user, model)});
        int reflogCount = this.app().settings().getInteger("web.overviewReflogCount", 5);
        ReflogPanel reflog = new ReflogPanel("reflogPanel", this.getRepositoryModel(), r, reflogCount, 0);
        this.add(new Component[]{reflog});
        this.add(new Component[]{new TagsPanel("tagsPanel", this.repositoryName, r, numberRefs).hideIfEmpty()});
        this.add(new Component[]{new BranchesPanel("branchesPanel", this.getRepositoryModel(), r, numberRefs, false).hideIfEmpty()});
        this.insertActivityGraph(metrics);
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.overview");
    }

    private void insertActivityGraph(List<Metric> metrics) {
        if (metrics != null && metrics.size() > 0 && this.app().settings().getBoolean("web.generateActivityGraph", true)) {
            Flotr2Charts charts = new Flotr2Charts();
            Chart chart = ((Charts)charts).createLineChart("chartDaily", "", "unit", this.getString("gb.commits"));
            for (Metric metric : metrics) {
                chart.addValue(metric.name, metric.count);
            }
            chart.setWidth(375);
            chart.setHeight(150);
            charts.addChart(chart);
            this.add(new IBehavior[]{new HeaderContributor((IHeaderContributor)charts)});
        }
    }
}

