/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.DiffUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RepositoriesPage;
import com.gitblit.wicket.pages.SessionPage;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

@CacheControl(value=CacheControl.LastModified.BOOT)
public class PatchPage
extends SessionPage {
    public PatchPage(PageParameters params) {
        super(params);
        if (!params.containsKey((Object)"r")) {
            this.error((Serializable)((Object)this.getString("gb.repositoryNotSpecified")));
            this.redirectToInterceptPage((Page)new RepositoriesPage());
        }
        String repositoryName = WicketUtils.getRepositoryName(params);
        String baseObjectId = WicketUtils.getBaseObjectId(params);
        String objectId = WicketUtils.getObject(params);
        String blobPath = WicketUtils.getPath(params);
        GitBlitWebSession session = GitBlitWebSession.get();
        UserModel user = session.getUser();
        RepositoryModel model = this.app().repositories().getRepositoryModel(user, repositoryName);
        if (model == null) {
            this.error((Serializable)((Object)(this.getString("gb.canNotLoadRepository") + " " + repositoryName)));
            this.redirectToInterceptPage((Page)new RepositoriesPage());
            return;
        }
        Repository r = this.app().repositories().getRepository(repositoryName);
        if (r == null) {
            this.error((Serializable)((Object)(this.getString("gb.canNotLoadRepository") + " " + repositoryName)));
            this.redirectToInterceptPage((Page)new RepositoriesPage());
            return;
        }
        RevCommit commit = JGitUtils.getCommit(r, objectId);
        if (commit == null) {
            GitBlitWebSession.get().cacheErrorMessage(this.getString("gb.commitIsNull"));
            this.redirectToInterceptPage((Page)new RepositoriesPage());
            return;
        }
        RevCommit baseCommit = null;
        if (!StringUtils.isEmpty(baseObjectId)) {
            baseCommit = JGitUtils.getCommit(r, baseObjectId);
        }
        String patch = DiffUtils.getCommitPatch(r, baseCommit, commit, blobPath);
        this.add(new Component[]{new Label("patchText", patch)});
        r.close();
    }
}

