/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.Menu;
import com.gitblit.models.NavLink;
import com.gitblit.models.ProjectModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.servlet.SyndicationServlet;
import com.gitblit.utils.MarkdownUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.GitBlitWebApp;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.GitblitRedirectException;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.DashboardPage;
import com.gitblit.wicket.pages.RepositoriesPage;
import com.gitblit.wicket.panels.FilterableRepositoryList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ExternalLink;

@CacheControl(value=CacheControl.LastModified.PROJECT)
public class ProjectPage
extends DashboardPage {
    List<ProjectModel> projectModels = new ArrayList<ProjectModel>();

    public ProjectPage() {
        throw new GitblitRedirectException(GitBlitWebApp.get().getHomePage());
    }

    public ProjectPage(PageParameters params) {
        super(params);
        this.setup(params);
    }

    @Override
    protected Class<? extends BasePage> getRootNavPageClass() {
        return RepositoriesPage.class;
    }

    @Override
    protected void setLastModified() {
        if (((Object)((Object)this)).getClass().isAnnotationPresent(CacheControl.class)) {
            CacheControl cacheControl = ((Object)((Object)this)).getClass().getAnnotation(CacheControl.class);
            switch (cacheControl.value()) {
                case PROJECT: {
                    ProjectModel project;
                    String projectName = WicketUtils.getProjectName(this.getPageParameters());
                    if (StringUtils.isEmpty(projectName) || (project = this.getProjectModel(projectName)) == null) break;
                    this.setLastModified(project.lastChange);
                    break;
                }
                default: {
                    super.setLastModified();
                }
            }
        }
    }

    private void setup(PageParameters params) {
        int daysBack;
        String projectName;
        this.setupPage("", "");
        boolean authenticateView = this.app().settings().getBoolean("web.authenticateViewPages", true);
        if (authenticateView && !GitBlitWebSession.get().isLoggedIn()) {
            this.authenticationError("Please login");
            return;
        }
        String string = projectName = params == null ? null : WicketUtils.getProjectName(params);
        if (StringUtils.isEmpty(projectName)) {
            throw new GitblitRedirectException(GitBlitWebApp.get().getHomePage());
        }
        ProjectModel project = this.getProjectModel(projectName);
        if (project == null) {
            throw new GitblitRedirectException(GitBlitWebApp.get().getHomePage());
        }
        this.add(new Component[]{new Label("projectTitle", project.getDisplayName())});
        this.add(new Component[]{new Label("projectDescription", project.description)});
        String feedLink = SyndicationServlet.asLink(this.getRequest().getRelativePathPrefixToContextRoot(), projectName, null, 0);
        this.add(new Component[]{new ExternalLink("syndication", feedLink)});
        this.add(new IBehavior[]{WicketUtils.syndicationDiscoveryLink(SyndicationServlet.getTitle(project.getDisplayName(), null), feedLink)});
        String pmessage = this.transformMarkdown(project.projectMarkdown);
        Component projectMessage = new Label("projectMessage", pmessage).setEscapeModelStrings(false).setVisible(pmessage.length() > 0);
        this.add(new Component[]{projectMessage});
        String rmessage = this.transformMarkdown(project.repositoriesMarkdown);
        Component repositoriesMessage = new Label("repositoriesMessage", rmessage).setEscapeModelStrings(false).setVisible(rmessage.length() > 0);
        this.add(new Component[]{repositoriesMessage});
        UserModel user = GitBlitWebSession.get().getUser();
        if (user == null) {
            user = UserModel.ANONYMOUS;
        }
        int n = daysBack = params == null ? 0 : WicketUtils.getDaysBack(params);
        if (daysBack < 1) {
            daysBack = this.app().settings().getInteger("web.activityDuration", 7);
        }
        if (params != null) {
            params.remove((Object)"db");
        }
        List<RepositoryModel> repositories = this.getRepositories(params);
        Collections.sort(repositories, new Comparator<RepositoryModel>(){

            @Override
            public int compare(RepositoryModel o1, RepositoryModel o2) {
                return o2.lastChange.compareTo(o1.lastChange);
            }
        });
        this.addActivity(user, repositories, this.getString("gb.recentActivity"), daysBack);
        if (repositories.isEmpty()) {
            this.add(new Component[]{new Label("repositoryList").setVisible(false)});
        } else {
            FilterableRepositoryList repoList = new FilterableRepositoryList("repositoryList", repositories);
            repoList.setAllowCreate(user.canCreate(project.name + "/"));
            this.add(new Component[]{repoList});
        }
    }

    @Override
    protected void addDropDownMenus(List<NavLink> navLinks) {
        PageParameters params = this.getPageParameters();
        NavLink.DropDownPageMenuNavLink menu = new NavLink.DropDownPageMenuNavLink("gb.filters", ProjectPage.class);
        menu.menuItems.addAll(this.getRepositoryFilterItems(params));
        menu.menuItems.addAll(this.getTimeFilterItems(params));
        if (menu.menuItems.size() > 0) {
            menu.menuItems.add(new Menu.ParameterMenuItem(this.getString("gb.reset"), "p", WicketUtils.getProjectName(params)));
        }
        navLinks.add(menu);
        NavLink.DropDownPageMenuNavLink projects = new NavLink.DropDownPageMenuNavLink("gb.projects", ProjectPage.class);
        projects.menuItems.addAll(this.getProjectsMenu());
        navLinks.add(projects);
    }

    @Override
    protected List<ProjectModel> getProjectModels() {
        if (this.projectModels.isEmpty()) {
            List<RepositoryModel> repositories = this.getRepositoryModels();
            List<ProjectModel> projects = this.app().projects().getProjectModels(repositories, false);
            this.projectModels.addAll(projects);
        }
        return this.projectModels;
    }

    private ProjectModel getProjectModel(String name) {
        for (ProjectModel project : this.getProjectModels()) {
            if (!name.equalsIgnoreCase(project.name)) continue;
            return project;
        }
        return null;
    }

    protected List<Menu.MenuItem> getProjectsMenu() {
        boolean showAllProjects;
        ArrayList<Menu.MenuItem> menu = new ArrayList<Menu.MenuItem>();
        List<ProjectModel> projects = new ArrayList<ProjectModel>();
        for (ProjectModel model : this.getProjectModels()) {
            if (model.isUserProject()) continue;
            projects.add(model);
        }
        int maxProjects = 15;
        boolean bl = showAllProjects = projects.size() > maxProjects;
        if (showAllProjects) {
            Collections.sort(projects, new Comparator<ProjectModel>(){

                @Override
                public int compare(ProjectModel o1, ProjectModel o2) {
                    return o2.lastChange.compareTo(o1.lastChange);
                }
            });
            projects = projects.subList(0, maxProjects);
            Collections.sort(projects);
        }
        for (ProjectModel project : projects) {
            menu.add(new Menu.ParameterMenuItem(project.getDisplayName(), "p", project.name));
        }
        if (showAllProjects) {
            menu.add(new Menu.MenuDivider());
            menu.add(new Menu.ParameterMenuItem("all projects"));
        }
        return menu;
    }

    private String transformMarkdown(String markdown) {
        String message = "";
        if (!StringUtils.isEmpty(markdown)) {
            try {
                message = MarkdownUtils.transformMarkdown(markdown);
            }
            catch (Throwable t) {
                message = this.getString("gb.failedToRead") + " " + markdown;
                this.warn(message, t);
            }
        }
        return message;
    }
}

