/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RepositoriesPage;
import com.gitblit.wicket.pages.SessionPage;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.protocol.http.servlet.AbortWithWebErrorCodeException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawPage
extends SessionPage {
    private final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getSimpleName());
    String contentType;

    public RawPage(final PageParameters params) {
        super(params);
        if (!params.containsKey((Object)"r")) {
            this.error((Serializable)((Object)this.getString("gb.repositoryNotSpecified")));
            this.redirectToInterceptPage((Page)new RepositoriesPage());
        }
        this.getRequestCycle().setRequestTarget(new IRequestTarget(){

            public void detach(RequestCycle requestCycle) {
            }

            public void respond(RequestCycle requestCycle) {
                WebResponse response = (WebResponse)requestCycle.getResponse();
                String repositoryName = WicketUtils.getRepositoryName(params);
                String objectId = WicketUtils.getObject(params);
                String blobPath = WicketUtils.getPath(params);
                String[] encodings = RawPage.this.getEncodings();
                GitBlitWebSession session = GitBlitWebSession.get();
                UserModel user = session.getUser();
                RepositoryModel model = RawPage.this.app().repositories().getRepositoryModel(user, repositoryName);
                if (model == null) {
                    RawPage.this.error((Serializable)((Object)(RawPage.this.getString("gb.canNotLoadRepository") + " " + repositoryName)));
                    RawPage.this.redirectToInterceptPage((Page)new RepositoriesPage());
                    return;
                }
                Repository r = RawPage.this.app().repositories().getRepository(repositoryName);
                if (r == null) {
                    RawPage.this.error((Serializable)((Object)(RawPage.this.getString("gb.canNotLoadRepository") + " " + repositoryName)));
                    RawPage.this.redirectToInterceptPage((Page)new RepositoriesPage());
                    return;
                }
                if (StringUtils.isEmpty(blobPath)) {
                    byte[] binary = JGitUtils.getByteContent(r, objectId);
                    if (binary == null) {
                        String objectNotFound = MessageFormat.format("Raw page failed to find object {0} in {1}", objectId, repositoryName);
                        RawPage.this.logger.error(objectNotFound);
                        throw new AbortWithWebErrorCodeException(404, objectNotFound);
                    }
                    RawPage.this.contentType = "application/octet-stream";
                    response.setContentType(RawPage.this.contentType);
                    response.setContentLength((long)binary.length);
                    try {
                        response.getOutputStream().write(binary);
                    }
                    catch (Exception e) {
                        RawPage.this.logger.error("Failed to write binary response", (Throwable)e);
                    }
                } else {
                    RevCommit commit = JGitUtils.getCommit(r, objectId);
                    if (commit == null) {
                        String commitNotFound = MessageFormat.format("Raw page failed to find commit {0} in {1}", objectId, repositoryName);
                        RawPage.this.logger.error(commitNotFound);
                        throw new AbortWithWebErrorCodeException(404, commitNotFound);
                    }
                    String filename = blobPath;
                    if (blobPath.indexOf(47) > -1) {
                        filename = blobPath.substring(blobPath.lastIndexOf(47) + 1);
                    }
                    String extension = null;
                    if (blobPath.lastIndexOf(46) > -1) {
                        extension = blobPath.substring(blobPath.lastIndexOf(46) + 1);
                    }
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    for (String ext : RawPage.this.app().settings().getStrings("web.imageExtensions")) {
                        map.put(ext.toLowerCase(), 2);
                    }
                    for (String ext : RawPage.this.app().settings().getStrings("web.binaryExtensions")) {
                        map.put(ext.toLowerCase(), 3);
                    }
                    String blobNotFound = MessageFormat.format("Raw page failed to find blob {0} in {1} @ {2}", blobPath, repositoryName, objectId);
                    if (extension != null) {
                        int type = 0;
                        if (map.containsKey(extension)) {
                            type = (Integer)map.get(extension);
                        }
                        switch (type) {
                            case 2: {
                                byte[] image = JGitUtils.getByteContent(r, commit.getTree(), blobPath, true);
                                if (image == null) {
                                    RawPage.this.logger.error(blobNotFound);
                                    throw new AbortWithWebErrorCodeException(404, blobNotFound);
                                }
                                RawPage.this.contentType = "image/" + extension.toLowerCase();
                                response.setContentType(RawPage.this.contentType);
                                response.setContentLength((long)image.length);
                                try {
                                    response.getOutputStream().write(image);
                                }
                                catch (IOException e) {
                                    RawPage.this.logger.error("Failed to write image response", (Throwable)e);
                                }
                                break;
                            }
                            case 3: {
                                byte[] binary = JGitUtils.getByteContent(r, commit.getTree(), blobPath, true);
                                if (binary == null) {
                                    RawPage.this.logger.error(blobNotFound);
                                    throw new AbortWithWebErrorCodeException(404, blobNotFound);
                                }
                                RawPage.this.contentType = "application/octet-stream";
                                response.setContentLength((long)binary.length);
                                response.setContentType(RawPage.this.contentType);
                                try {
                                    WebRequest request = (WebRequest)requestCycle.getRequest();
                                    String userAgent = request.getHttpServletRequest().getHeader("User-Agent");
                                    if (userAgent != null && userAgent.indexOf("MSIE 5.5") > -1) {
                                        response.setHeader("Content-Disposition", "filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\"");
                                    } else if (userAgent != null && userAgent.indexOf("MSIE") > -1) {
                                        response.setHeader("Content-Disposition", "attachment; filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\"");
                                    } else {
                                        response.setHeader("Content-Disposition", "attachment; filename=\"" + new String(filename.getBytes("UTF-8"), "latin1") + "\"");
                                    }
                                }
                                catch (UnsupportedEncodingException e) {
                                    response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
                                }
                                try {
                                    response.getOutputStream().write(binary);
                                }
                                catch (IOException e) {
                                    RawPage.this.logger.error("Failed to write binary response", (Throwable)e);
                                }
                                break;
                            }
                            default: {
                                String content = JGitUtils.getStringContent(r, commit.getTree(), blobPath, encodings);
                                if (content == null) {
                                    RawPage.this.logger.error(blobNotFound);
                                    throw new AbortWithWebErrorCodeException(404, blobNotFound);
                                }
                                RawPage.this.contentType = "text/plain; charset=UTF-8";
                                response.setContentType(RawPage.this.contentType);
                                try {
                                    response.getOutputStream().write(content.getBytes("UTF-8"));
                                }
                                catch (Exception e) {
                                    RawPage.this.logger.error("Failed to write text response", (Throwable)e);
                                }
                                break;
                            }
                        }
                    } else {
                        String content = JGitUtils.getStringContent(r, commit.getTree(), blobPath, encodings);
                        if (content == null) {
                            RawPage.this.logger.error(blobNotFound);
                            throw new AbortWithWebErrorCodeException(404, blobNotFound);
                        }
                        RawPage.this.contentType = "text/plain; charset=UTF-8";
                        response.setContentType(RawPage.this.contentType);
                        try {
                            response.getOutputStream().write(content.getBytes("UTF-8"));
                        }
                        catch (Exception e) {
                            RawPage.this.logger.error("Failed to write text response", (Throwable)e);
                        }
                    }
                }
                r.close();
            }
        });
    }

    protected void setHeaders(WebResponse response) {
        super.setHeaders(response);
        if (!StringUtils.isEmpty(this.contentType)) {
            response.setContentType(this.contentType);
        }
    }
}

