/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.wicket.CacheControl;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.panels.ReflogPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;

@CacheControl(value=CacheControl.LastModified.REPOSITORY)
public class ReflogPage
extends RepositoryPage {
    public ReflogPage(PageParameters params) {
        super(params);
        this.addSyndicationDiscoveryLink();
        int pageNumber = WicketUtils.getPage(params);
        int prevPage = Math.max(0, pageNumber - 1);
        int nextPage = pageNumber + 1;
        ReflogPanel reflogPanel = new ReflogPanel("reflogPanel", this.getRepositoryModel(), this.getRepository(), -1, pageNumber - 1);
        boolean hasMore = reflogPanel.hasMore();
        this.add(new Component[]{reflogPanel});
        this.add(new Component[]{new BookmarkablePageLink("firstPageTop", ReflogPage.class, WicketUtils.newObjectParameter(this.repositoryName, this.objectId)).setEnabled(pageNumber > 1)});
        this.add(new Component[]{new BookmarkablePageLink("prevPageTop", ReflogPage.class, WicketUtils.newLogPageParameter(this.repositoryName, this.objectId, prevPage)).setEnabled(pageNumber > 1)});
        this.add(new Component[]{new BookmarkablePageLink("nextPageTop", ReflogPage.class, WicketUtils.newLogPageParameter(this.repositoryName, this.objectId, nextPage)).setEnabled(hasMore)});
        this.add(new Component[]{new BookmarkablePageLink("firstPageBottom", ReflogPage.class, WicketUtils.newObjectParameter(this.repositoryName, this.objectId)).setEnabled(pageNumber > 1)});
        this.add(new Component[]{new BookmarkablePageLink("prevPageBottom", ReflogPage.class, WicketUtils.newLogPageParameter(this.repositoryName, this.objectId, prevPage)).setEnabled(pageNumber > 1)});
        this.add(new Component[]{new BookmarkablePageLink("nextPageBottom", ReflogPage.class, WicketUtils.newLogPageParameter(this.repositoryName, this.objectId, nextPage)).setEnabled(hasMore)});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.reflog");
    }
}

