/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.models.FederationProposal;
import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.FederationUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.RequiresAdminRole;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.FederationPage;
import com.gitblit.wicket.pages.RepositoriesPage;
import com.gitblit.wicket.pages.RootSubPage;
import com.gitblit.wicket.panels.RepositoriesPanel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;

@RequiresAdminRole
public class SendProposalPage
extends RootSubPage {
    public String myUrl;
    public String destinationUrl;
    public String message;

    public SendProposalPage(PageParameters params) {
        super(params);
        this.setupPage(this.getString("gb.sendProposal"), "");
        this.setStatelessHint(true);
        final String token = WicketUtils.getToken(params);
        this.myUrl = WicketUtils.getGitblitURL(this.getRequest());
        this.destinationUrl = "https://";
        FederationProposal proposal = this.app().federation().createFederationProposal(this.myUrl, token);
        if (proposal == null) {
            this.error(this.getString("gb.couldNotCreateFederationProposal"), true);
        }
        CompoundPropertyModel model = new CompoundPropertyModel((Object)this);
        Form<SendProposalPage> form = new Form<SendProposalPage>("editForm", (IModel)model){
            private static final long serialVersionUID = 1L;

            protected void onSubmit() {
                if (StringUtils.isEmpty(SendProposalPage.this.myUrl)) {
                    this.error((Serializable)((Object)this.getString("gb.pleaseSetGitblitUrl")));
                    return;
                }
                if (StringUtils.isEmpty(SendProposalPage.this.destinationUrl)) {
                    this.error((Serializable)((Object)this.getString("gb.pleaseSetDestinationUrl")));
                    return;
                }
                FederationProposal proposal = SendProposalPage.this.app().federation().createFederationProposal(SendProposalPage.this.myUrl, token);
                proposal.url = SendProposalPage.this.myUrl;
                proposal.message = SendProposalPage.this.message;
                try {
                    Constants.FederationProposalResult res = FederationUtils.propose(SendProposalPage.this.destinationUrl, proposal);
                    switch (res) {
                        case ACCEPTED: {
                            this.info(MessageFormat.format(this.getString("gb.proposalReceived"), SendProposalPage.this.destinationUrl));
                            this.setResponsePage(RepositoriesPage.class);
                            break;
                        }
                        case NO_POKE: {
                            this.error((Serializable)((Object)MessageFormat.format(this.getString("noGitblitFound"), SendProposalPage.this.destinationUrl, SendProposalPage.this.myUrl)));
                            break;
                        }
                        case NO_PROPOSALS: {
                            this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.noProposals"), SendProposalPage.this.destinationUrl)));
                            break;
                        }
                        case FEDERATION_DISABLED: {
                            this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.noFederation"), SendProposalPage.this.destinationUrl)));
                            break;
                        }
                        case MISSING_DATA: {
                            this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.proposalFailed"), SendProposalPage.this.destinationUrl)));
                            break;
                        }
                        case ERROR: {
                            this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.proposalError"), SendProposalPage.this.destinationUrl)));
                        }
                    }
                }
                catch (Exception e) {
                    if (!StringUtils.isEmpty(e.getMessage())) {
                        this.error((Serializable)((Object)e.getMessage()));
                    }
                    this.error((Serializable)((Object)this.getString("gb.failedToSendProposal")));
                }
            }
        };
        form.add(new Component[]{new TextField("myUrl")});
        form.add(new Component[]{new TextField("destinationUrl")});
        form.add(new Component[]{new TextField("message")});
        form.add(new Component[]{new Label("tokenType", proposal.tokenType.name())});
        form.add(new Component[]{new Label("token", proposal.token)});
        form.add(new Component[]{new Button("save")});
        Button cancel = new Button("cancel"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                this.setResponsePage(FederationPage.class);
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
        this.add(new Component[]{form});
        ArrayList<RepositoryModel> repositories = new ArrayList<RepositoryModel>(proposal.repositories.values());
        RepositoriesPanel repositoriesPanel = new RepositoriesPanel("repositoriesPanel", false, false, repositories, false, this.getAccessRestrictions());
        this.add(new Component[]{repositoriesPanel});
    }

    @Override
    protected Class<? extends BasePage> getRootNavPageClass() {
        return FederationPage.class;
    }
}

