/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.git.PatchsetCommand;
import com.gitblit.git.PatchsetReceivePack;
import com.gitblit.models.PathModel;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.RepositoryUrl;
import com.gitblit.models.SubmoduleModel;
import com.gitblit.models.TicketModel;
import com.gitblit.models.UserModel;
import com.gitblit.tickets.TicketIndexer;
import com.gitblit.tickets.TicketLabel;
import com.gitblit.tickets.TicketMilestone;
import com.gitblit.tickets.TicketResponsible;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.CommitCache;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.MarkdownUtils;
import com.gitblit.utils.RefLogUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.TimeUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.TicketsUI;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.BlobDiffPage;
import com.gitblit.wicket.pages.BlobPage;
import com.gitblit.wicket.pages.CommitDiffPage;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.ComparePage;
import com.gitblit.wicket.pages.EditTicketPage;
import com.gitblit.wicket.pages.ExportTicketPage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.TicketsPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.pages.UserPage;
import com.gitblit.wicket.panels.AvatarImage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.CommentPanel;
import com.gitblit.wicket.panels.DiffStatPanel;
import com.gitblit.wicket.panels.IconAjaxLink;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.ShockWaveComponent;
import com.gitblit.wicket.panels.SimpleAjaxLink;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.ContextImage;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.pages.RedirectPage;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.protocol.http.WebRequest;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class TicketPage
extends RepositoryPage {
    static final String NIL = "<nil>";
    static final String ESC_NIL = StringUtils.escapeForHtml("<nil>", false);
    final int avatarWidth = 40;
    final TicketModel ticket;

    public TicketPage(PageParameters params) {
        super(params);
        String desc;
        String fuzzydate;
        final UserModel user = GitBlitWebSession.get().getUser() == null ? UserModel.ANONYMOUS : GitBlitWebSession.get().getUser();
        final RepositoryModel repository = this.getRepositoryModel();
        String id = WicketUtils.getObject(params);
        long ticketId = Long.parseLong(id);
        this.ticket = this.app().tickets().getTicket(repository, ticketId);
        if (this.ticket == null) {
            throw new RestartResponseException(TicketsPage.class, WicketUtils.newRepositoryParameter(this.repositoryName));
        }
        final ArrayList<TicketModel.Change> revisions = new ArrayList<TicketModel.Change>();
        ArrayList<TicketModel.Change> comments = new ArrayList<TicketModel.Change>();
        ArrayList<TicketModel.Change> statusChanges = new ArrayList<TicketModel.Change>();
        ArrayList<TicketModel.Change> discussion = new ArrayList<TicketModel.Change>();
        for (TicketModel.Change change : this.ticket.changes) {
            if (change.hasComment() || change.isStatusChange() && change.getStatus() != TicketModel.Status.New) {
                discussion.add(change);
            }
            if (change.hasComment()) {
                comments.add(change);
            }
            if (change.hasPatchset()) {
                revisions.add(change);
            }
            if (!change.isStatusChange() || change.hasPatchset()) continue;
            statusChanges.add(change);
        }
        TicketModel.Change currentRevision = revisions.isEmpty() ? null : (TicketModel.Change)revisions.get(revisions.size() - 1);
        TicketModel.Patchset currentPatchset = this.ticket.getCurrentPatchset();
        String href = this.urlFor(TicketsPage.class, params).toString();
        this.add(new Component[]{new ExternalLink("ticketNumber", href, "#" + this.ticket.number)});
        Label headerStatus = new Label("headerStatus", this.ticket.status.toString());
        WicketUtils.setCssClass((Component)headerStatus, TicketsUI.getLozengeClass(this.ticket.status, false));
        this.add(new Component[]{headerStatus});
        this.add(new Component[]{new Label("ticketTitle", this.ticket.title)});
        if (currentPatchset == null) {
            this.add(new Component[]{new Label("diffstat").setVisible(false)});
        } else {
            this.add(new Component[]{new DiffStatPanel("diffstat", this.ticket.insertions, this.ticket.deletions)});
        }
        this.add(new Component[]{new Label("commentCount", "" + comments.size()).setVisible(!comments.isEmpty())});
        this.add(new Component[]{new Label("commitCount", "" + (currentPatchset == null ? 0 : currentPatchset.commits)).setVisible(currentPatchset != null)});
        UserModel createdBy = this.app().users().getUserModel(this.ticket.createdBy);
        if (createdBy == null) {
            this.add(new Component[]{new Label("whoCreated", this.ticket.createdBy)});
        } else {
            this.add(new Component[]{new LinkPanel("whoCreated", null, createdBy.getDisplayName(), UserPage.class, WicketUtils.newUsernameParameter(createdBy.username))});
        }
        if (this.ticket.isProposal()) {
            this.add(new Component[]{new Label("creationMessage", this.getString("gb.proposedThisChange"))});
        } else {
            this.add(new Component[]{new Label("creationMessage", this.getString("gb.createdThisTicket"))});
        }
        String dateFormat = this.app().settings().getString("web.datestampLongFormat", "EEEE, MMMM d, yyyy");
        String timestampFormat = this.app().settings().getString("web.datetimestampLongFormat", "EEEE, MMMM d, yyyy");
        TimeZone timezone = this.getTimeZone();
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        df.setTimeZone(timezone);
        SimpleDateFormat tsf = new SimpleDateFormat(timestampFormat);
        tsf.setTimeZone(timezone);
        Calendar cal = Calendar.getInstance(timezone);
        TimeUtils tu = this.getTimeUtils();
        Date createdDate = this.ticket.created;
        if (TimeUtils.isToday(createdDate, timezone)) {
            fuzzydate = tu.today();
        } else if (TimeUtils.isYesterday(createdDate, timezone)) {
            fuzzydate = tu.yesterday();
        } else {
            cal.setTime(createdDate);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            createdDate = cal.getTime();
            fuzzydate = this.getTimeUtils().timeAgo(createdDate);
        }
        Label when = new Label("whenCreated", fuzzydate + ", " + df.format(createdDate));
        WicketUtils.setHtmlTooltip((Component)when, tsf.format(this.ticket.created));
        this.add(new Component[]{when});
        String exportHref = this.urlFor(ExportTicketPage.class, params).toString();
        this.add(new Component[]{new ExternalLink("exportJson", exportHref, "json")});
        if (StringUtils.isEmpty(this.ticket.responsible)) {
            this.add(new Component[]{new Label("responsible")});
        } else {
            UserModel responsible = this.app().users().getUserModel(this.ticket.responsible);
            if (responsible == null) {
                this.add(new Component[]{new Label("responsible", this.ticket.responsible)});
            } else {
                this.add(new Component[]{new LinkPanel("responsible", null, responsible.getDisplayName(), UserPage.class, WicketUtils.newUsernameParameter(responsible.username))});
            }
        }
        if (StringUtils.isEmpty(this.ticket.milestone)) {
            this.add(new Component[]{new Label("milestone")});
        } else {
            TicketMilestone tm = this.app().tickets().getMilestone(repository, this.ticket.milestone);
            if (tm == null) {
                tm = new TicketMilestone(this.ticket.milestone);
            }
            PageParameters milestoneParameters = tm.isOpen() ? WicketUtils.newOpenTicketsParameter(this.repositoryName) : WicketUtils.newRepositoryParameter(this.repositoryName);
            milestoneParameters.put(TicketIndexer.Lucene.milestone.name(), (Object)this.ticket.milestone);
            int progress = 0;
            int open = 0;
            int closed = 0;
            if (tm != null) {
                progress = tm.getProgress();
                open = tm.getOpenTickets();
                closed = tm.getClosedTickets();
            }
            Fragment milestoneProgress = new Fragment("milestone", "milestoneProgressFragment", (MarkupContainer)this);
            milestoneProgress.add(new Component[]{new LinkPanel("link", null, this.ticket.milestone, TicketsPage.class, milestoneParameters)});
            Label label = new Label("progress");
            WicketUtils.setCssStyle((Component)label, "width:" + progress + "%;");
            milestoneProgress.add(new Component[]{label});
            WicketUtils.setHtmlTooltip((Component)milestoneProgress, MessageFormat.format(this.getString("gb.milestoneProgress"), open, closed));
            this.add(new Component[]{milestoneProgress});
        }
        if (StringUtils.isEmpty(this.ticket.body)) {
            desc = this.getString("gb.noDescriptionGiven");
        } else {
            String safeHtml;
            String bugtraq = this.bugtraqProcessor().processText(this.getRepository(), this.repositoryName, this.ticket.body);
            String html = MarkdownUtils.transformGFM(this.app().settings(), bugtraq, this.ticket.repository);
            desc = safeHtml = this.app().xssFilter().relaxed(html);
        }
        this.add(new Component[]{new Label("ticketDescription", desc).setEscapeModelStrings(false)});
        if (this.app().settings().getBoolean("web.allowGravatar", true)) {
            List<String> participants = this.ticket.getParticipants();
            this.add(new Component[]{new Label("participantsLabel", MessageFormat.format(this.getString(participants.size() > 1 ? "gb.nParticipants" : "gb.oneParticipant"), "<b>" + participants.size() + "</b>")).setEscapeModelStrings(false)});
            ListDataProvider participantsDp = new ListDataProvider(participants);
            DataView<String> participantsView = new DataView<String>("participants", (IDataProvider)participantsDp){
                private static final long serialVersionUID = 1L;

                public void populateItem(Item<String> item) {
                    String username = (String)item.getModelObject();
                    UserModel user = TicketPage.this.app().users().getUserModel(username);
                    if (user == null) {
                        user = new UserModel(username);
                    }
                    item.add(new Component[]{new AvatarImage("participant", user.getDisplayName(), user.emailAddress, null, 25, true)});
                }
            };
            this.add(new Component[]{participantsView});
        } else {
            this.add(new Component[]{new Label("participantsLabel").setVisible(false)});
            this.add(new Component[]{new Label("participants").setVisible(false)});
        }
        Fragment ticketStatus = new Fragment("ticketStatus", "ticketStatusFragment", (MarkupContainer)this);
        Label ticketIcon = TicketsUI.getStateIcon("ticketIcon", this.ticket);
        ticketStatus.add(new Component[]{ticketIcon});
        ticketStatus.add(new Component[]{new Label("ticketStatus", this.ticket.status.toString())});
        WicketUtils.setCssClass((Component)ticketStatus, TicketsUI.getLozengeClass(this.ticket.status, false));
        this.add(new Component[]{ticketStatus});
        if (user.canEdit(this.ticket, repository) && this.app().tickets().isAcceptingTicketUpdates(repository)) {
            if (user.canAdmin(this.ticket, repository) && this.ticket.isOpen()) {
                Fragment controls = new Fragment("controls", "openControlsFragment", (MarkupContainer)this);
                ArrayList<TicketModel.Status> choices = new ArrayList<TicketModel.Status>();
                if (this.ticket.isProposal()) {
                    choices.addAll(Arrays.asList(TicketModel.Status.proposalWorkflow));
                } else if (this.ticket.isBug()) {
                    choices.addAll(Arrays.asList(TicketModel.Status.bugWorkflow));
                } else {
                    choices.addAll(Arrays.asList(TicketModel.Status.requestWorkflow));
                }
                choices.remove((Object)this.ticket.status);
                ListDataProvider workflowDp = new ListDataProvider(choices);
                DataView<TicketModel.Status> statusView = new DataView<TicketModel.Status>("newStatus", (IDataProvider)workflowDp){
                    private static final long serialVersionUID = 1L;

                    public void populateItem(Item<TicketModel.Status> item) {
                        SimpleAjaxLink<TicketModel.Status> link = new SimpleAjaxLink<TicketModel.Status>("link", item.getModel()){
                            private static final long serialVersionUID = 1L;

                            public void onClick(AjaxRequestTarget target) {
                                TicketModel.Status status = (TicketModel.Status)((Object)this.getModel().getObject());
                                TicketModel.Change change = new TicketModel.Change(user.username);
                                change.setField(TicketModel.Field.status, (Object)status);
                                if (!TicketPage.this.ticket.isWatching(user.username)) {
                                    change.watch(user.username);
                                }
                                TicketModel update = TicketPage.this.app().tickets().updateTicket(repository, TicketPage.this.ticket.number, change);
                                TicketPage.this.app().tickets().createNotifier().sendMailing(update);
                                TicketPage.this.redirectTo(TicketsPage.class, TicketPage.this.getPageParameters());
                            }
                        };
                        String css = TicketsUI.getStatusClass((TicketModel.Status)((Object)item.getModel().getObject()));
                        WicketUtils.setCssClass((Component)link, css);
                        item.add(new Component[]{link});
                    }
                };
                controls.add(new Component[]{statusView});
                TreeSet<String> userlist = new TreeSet<String>(this.ticket.getParticipants());
                if (UserModel.ANONYMOUS.canPush(this.getRepositoryModel()) || Constants.AuthorizationControl.AUTHENTICATED == this.getRepositoryModel().authorizationControl) {
                    userlist.addAll(this.app().users().getAllUsernames());
                } else {
                    for (RegistrantAccessPermission rp : this.app().repositories().getUserAccessPermissions(this.getRepositoryModel())) {
                        if (!rp.permission.atLeast(Constants.AccessPermission.PUSH)) continue;
                        userlist.add(rp.registrant);
                    }
                }
                ArrayList<TicketResponsible> responsibles = new ArrayList<TicketResponsible>();
                if (!StringUtils.isEmpty(this.ticket.responsible)) {
                    userlist.remove(this.ticket.responsible);
                }
                for (String username : userlist) {
                    UserModel u = this.app().users().getUserModel(username);
                    if (u == null) continue;
                    responsibles.add(new TicketResponsible(u));
                }
                Collections.sort(responsibles);
                responsibles.add(new TicketResponsible(ESC_NIL, "", ""));
                ListDataProvider responsibleDp = new ListDataProvider(responsibles);
                DataView<TicketResponsible> responsibleView = new DataView<TicketResponsible>("newResponsible", (IDataProvider)responsibleDp){
                    private static final long serialVersionUID = 1L;

                    public void populateItem(Item<TicketResponsible> item) {
                        SimpleAjaxLink<TicketResponsible> link = new SimpleAjaxLink<TicketResponsible>("link", item.getModel()){
                            private static final long serialVersionUID = 1L;

                            public void onClick(AjaxRequestTarget target) {
                                TicketResponsible responsible = (TicketResponsible)this.getModel().getObject();
                                TicketModel.Change change = new TicketModel.Change(user.username);
                                change.setField(TicketModel.Field.responsible, responsible.username);
                                if (!StringUtils.isEmpty(responsible.username) && !TicketPage.this.ticket.isWatching(responsible.username)) {
                                    change.watch(responsible.username);
                                }
                                if (!TicketPage.this.ticket.isWatching(user.username)) {
                                    change.watch(user.username);
                                }
                                TicketModel update = TicketPage.this.app().tickets().updateTicket(repository, TicketPage.this.ticket.number, change);
                                TicketPage.this.app().tickets().createNotifier().sendMailing(update);
                                TicketPage.this.redirectTo(TicketsPage.class, TicketPage.this.getPageParameters());
                            }
                        };
                        item.add(new Component[]{link});
                    }
                };
                controls.add(new Component[]{responsibleView});
                List<TicketMilestone> milestones = this.app().tickets().getMilestones(repository, TicketModel.Status.Open);
                if (!StringUtils.isEmpty(this.ticket.milestone)) {
                    for (TicketMilestone milestone : milestones) {
                        if (!milestone.name.equals(this.ticket.milestone)) continue;
                        milestones.remove(milestone);
                        break;
                    }
                }
                milestones.add(new TicketMilestone(ESC_NIL));
                ListDataProvider milestoneDp = new ListDataProvider(milestones);
                DataView<TicketMilestone> milestoneView = new DataView<TicketMilestone>("newMilestone", (IDataProvider)milestoneDp){
                    private static final long serialVersionUID = 1L;

                    public void populateItem(Item<TicketMilestone> item) {
                        SimpleAjaxLink<TicketMilestone> link = new SimpleAjaxLink<TicketMilestone>("link", item.getModel()){
                            private static final long serialVersionUID = 1L;

                            public void onClick(AjaxRequestTarget target) {
                                TicketMilestone milestone = (TicketMilestone)this.getModel().getObject();
                                TicketModel.Change change = new TicketModel.Change(user.username);
                                if (TicketPage.NIL.equals(milestone.name) || ESC_NIL.equals(milestone.name)) {
                                    change.setField(TicketModel.Field.milestone, "");
                                } else {
                                    change.setField(TicketModel.Field.milestone, milestone.name);
                                }
                                if (!TicketPage.this.ticket.isWatching(user.username)) {
                                    change.watch(user.username);
                                }
                                TicketModel update = TicketPage.this.app().tickets().updateTicket(repository, TicketPage.this.ticket.number, change);
                                TicketPage.this.app().tickets().createNotifier().sendMailing(update);
                                TicketPage.this.redirectTo(TicketsPage.class, TicketPage.this.getPageParameters());
                            }
                        };
                        item.add(new Component[]{link});
                    }
                };
                controls.add(new Component[]{milestoneView});
                String editHref = this.urlFor(EditTicketPage.class, params).toString();
                controls.add(new Component[]{new ExternalLink("editLink", editHref, this.getString("gb.edit"))});
                this.add(new Component[]{controls});
            } else {
                Fragment controls = new Fragment("controls", "closedControlsFragment", (MarkupContainer)this);
                String editHref = this.urlFor(EditTicketPage.class, params).toString();
                controls.add(new Component[]{new ExternalLink("editLink", editHref, this.getString("gb.edit"))});
                this.add(new Component[]{controls});
            }
        } else {
            this.add(new Component[]{new Label("controls").setVisible(false)});
        }
        this.add(new Component[]{new Label("ticketType", this.ticket.type.toString())});
        this.add(new Component[]{new Label("priority", this.ticket.priority.toString())});
        this.add(new Component[]{new Label("severity", this.ticket.severity.toString())});
        if (StringUtils.isEmpty(this.ticket.topic)) {
            this.add(new Component[]{new Label("ticketTopic").setVisible(false)});
        } else {
            String topic = this.bugtraqProcessor().processText(this.getRepository(), this.repositoryName, this.ticket.topic);
            String safeTopic = this.app().xssFilter().relaxed(topic);
            this.add(new Component[]{new Label("ticketTopic", safeTopic).setEscapeModelStrings(false)});
        }
        List<String> voters = this.ticket.getVoters();
        Label votersCount = new Label("votes", "" + voters.size());
        if (voters.size() == 0) {
            WicketUtils.setCssClass((Component)votersCount, "badge");
        } else {
            WicketUtils.setCssClass((Component)votersCount, "badge badge-info");
        }
        this.add(new Component[]{votersCount});
        if (user.isAuthenticated && this.app().tickets().isAcceptingTicketUpdates(repository)) {
            Model model = this.ticket.isVoter(user.username) ? Model.of((Serializable)((Object)this.getString("gb.removeVote"))) : Model.of((Serializable)((Object)MessageFormat.format(this.getString("gb.vote"), this.ticket.type.toString())));
            SimpleAjaxLink<String> link = new SimpleAjaxLink<String>("voteLink", (IModel)model){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    TicketModel.Change change = new TicketModel.Change(user.username);
                    if (TicketPage.this.ticket.isVoter(user.username)) {
                        change.unvote(user.username);
                    } else {
                        change.vote(user.username);
                    }
                    TicketPage.this.app().tickets().updateTicket(repository, TicketPage.this.ticket.number, change);
                    TicketPage.this.redirectTo(TicketsPage.class, TicketPage.this.getPageParameters());
                }
            };
            this.add(new Component[]{link});
        } else {
            this.add(new Component[]{new Label("voteLink").setVisible(false)});
        }
        List<String> watchers = this.ticket.getWatchers();
        Label watchersCount = new Label("watchers", "" + watchers.size());
        if (watchers.size() == 0) {
            WicketUtils.setCssClass((Component)watchersCount, "badge");
        } else {
            WicketUtils.setCssClass((Component)watchersCount, "badge badge-info");
        }
        this.add(new Component[]{watchersCount});
        if (user.isAuthenticated && this.app().tickets().isAcceptingTicketUpdates(repository)) {
            Model model = this.ticket.isWatching(user.username) ? Model.of((Serializable)((Object)this.getString("gb.stopWatching"))) : Model.of((Serializable)((Object)MessageFormat.format(this.getString("gb.watch"), this.ticket.type.toString())));
            SimpleAjaxLink<String> link = new SimpleAjaxLink<String>("watchLink", (IModel)model){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    TicketModel.Change change = new TicketModel.Change(user.username);
                    if (TicketPage.this.ticket.isWatching(user.username)) {
                        change.unwatch(user.username);
                    } else {
                        change.watch(user.username);
                    }
                    TicketPage.this.app().tickets().updateTicket(repository, TicketPage.this.ticket.number, change);
                    TicketPage.this.redirectTo(TicketsPage.class, TicketPage.this.getPageParameters());
                }
            };
            this.add(new Component[]{link});
        } else {
            this.add(new Component[]{new Label("watchLink").setVisible(false)});
        }
        ListDataProvider labelsDp = new ListDataProvider(this.ticket.getLabels());
        DataView<String> labelsView = new DataView<String>("labels", (IDataProvider)labelsDp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<String> item) {
                String value = (String)item.getModelObject();
                Label label = new Label("label", value);
                TicketLabel tLabel = TicketPage.this.app().tickets().getLabel(repository, value);
                String background = MessageFormat.format("background-color:{0};", tLabel.color);
                label.add(new IBehavior[]{new SimpleAttributeModifier("style", (CharSequence)background)});
                item.add(new Component[]{label});
            }
        };
        this.add(new Component[]{labelsView});
        if (comments.size() == 0) {
            this.add(new Component[]{new Label("discussion").setVisible(false)});
        } else {
            Fragment discussionFragment = new Fragment("discussion", "discussionFragment", (MarkupContainer)this);
            ListDataProvider discussionDp = new ListDataProvider(discussion);
            DataView<TicketModel.Change> discussionView = new DataView<TicketModel.Change>("discussion", (IDataProvider)discussionDp){
                private static final long serialVersionUID = 1L;

                public void populateItem(Item<TicketModel.Change> item) {
                    TicketModel.Change entry = (TicketModel.Change)item.getModelObject();
                    if (entry.isMerge()) {
                        String commitLink;
                        String resolvedBy = entry.getString(TicketModel.Field.mergeSha);
                        TicketModel.Patchset mergedPatch = null;
                        for (TicketModel.Change c : revisions) {
                            if (!c.patchset.tip.equals(resolvedBy)) continue;
                            mergedPatch = c.patchset;
                            break;
                        }
                        if (mergedPatch == null) {
                            int len = TicketPage.this.app().settings().getInteger("web.shortCommitIdLength", 6);
                            commitLink = resolvedBy.substring(0, len);
                        } else {
                            commitLink = mergedPatch.toString();
                        }
                        Fragment mergeFragment = new Fragment("entry", "mergeFragment", (MarkupContainer)this);
                        mergeFragment.add(new Component[]{new LinkPanel("commitLink", null, commitLink, CommitPage.class, WicketUtils.newObjectParameter(TicketPage.this.repositoryName, resolvedBy))});
                        mergeFragment.add(new Component[]{new Label("toBranch", MessageFormat.format(this.getString("gb.toBranch"), "<b>" + TicketPage.this.ticket.mergeTo + "</b>")).setEscapeModelStrings(false)});
                        TicketPage.this.addUserAttributions((MarkupContainer)mergeFragment, entry, 0);
                        TicketPage.this.addDateAttributions((MarkupContainer)mergeFragment, entry);
                        item.add(new Component[]{mergeFragment});
                    } else if (entry.isStatusChange()) {
                        Fragment frag = new Fragment("entry", "statusFragment", (MarkupContainer)this);
                        Label status = new Label("statusChange", entry.getStatus().toString());
                        String css = TicketsUI.getLozengeClass(entry.getStatus(), false);
                        WicketUtils.setCssClass((Component)status, css);
                        frag.add(new Component[]{status});
                        TicketPage.this.addUserAttributions((MarkupContainer)frag, entry, 40);
                        TicketPage.this.addDateAttributions((MarkupContainer)frag, entry);
                        item.add(new Component[]{frag});
                    } else {
                        String bugtraq = TicketPage.this.bugtraqProcessor().processText(TicketPage.this.getRepository(), TicketPage.this.repositoryName, entry.comment.text);
                        String comment = MarkdownUtils.transformGFM(TicketPage.this.app().settings(), bugtraq, TicketPage.this.repositoryName);
                        String safeComment = TicketPage.this.app().xssFilter().relaxed(comment);
                        Fragment frag = new Fragment("entry", "commentFragment", (MarkupContainer)this);
                        Label commentIcon = new Label("commentIcon");
                        if (entry.comment.src == TicketModel.CommentSource.Email) {
                            WicketUtils.setCssClass((Component)commentIcon, "iconic-mail");
                        } else {
                            WicketUtils.setCssClass((Component)commentIcon, "iconic-comment-alt2-stroke");
                        }
                        frag.add(new Component[]{commentIcon});
                        frag.add(new Component[]{new Label("comment", safeComment).setEscapeModelStrings(false)});
                        TicketPage.this.addUserAttributions((MarkupContainer)frag, entry, 40);
                        TicketPage.this.addDateAttributions((MarkupContainer)frag, entry);
                        item.add(new Component[]{frag});
                    }
                }
            };
            discussionFragment.add(new Component[]{discussionView});
            this.add(new Component[]{discussionFragment});
        }
        if (UserModel.ANONYMOUS.equals(user) || !repository.isBare || repository.isFrozen || repository.isMirror) {
            this.add(new Component[]{new Label("newComment").setVisible(false)});
        } else {
            Fragment newComment = new Fragment("newComment", "newCommentFragment", (MarkupContainer)this);
            AvatarImage img = new AvatarImage("newCommentAvatar", user.username, user.emailAddress, "gravatar-round", 40, true);
            newComment.add(new Component[]{img});
            CommentPanel commentPanel = new CommentPanel("commentPanel", user, this.ticket, null, TicketsPage.class);
            commentPanel.setRepository(this.repositoryName);
            newComment.add(new Component[]{commentPanel});
            this.add(new Component[]{newComment});
        }
        if (currentPatchset == null) {
            boolean canPropose;
            RepositoryUrl repoUrl = this.getRepositoryUrl(user, repository);
            boolean bl = canPropose = repoUrl != null && repoUrl.hasPermission() && repoUrl.permission.atLeast(Constants.AccessPermission.CLONE) && !UserModel.ANONYMOUS.equals(user);
            if (this.ticket.isOpen() && this.app().tickets().isAcceptingNewPatchsets(repository) && canPropose) {
                Fragment changeIdFrag = new Fragment("patchset", "proposeFragment", (MarkupContainer)this);
                changeIdFrag.add(new Component[]{new Label("proposeInstructions", MarkdownUtils.transformMarkdown(this.getString("gb.proposeInstructions"))).setEscapeModelStrings(false)});
                changeIdFrag.add(new Component[]{new Label("ptWorkflow", MessageFormat.format(this.getString("gb.proposeWith"), "Barnum"))});
                changeIdFrag.add(new Component[]{new Label("ptWorkflowSteps", this.getProposeWorkflow("propose_pt.md", repoUrl.url, this.ticket.number)).setEscapeModelStrings(false)});
                changeIdFrag.add(new Component[]{new Label("gitWorkflow", MessageFormat.format(this.getString("gb.proposeWith"), "Git"))});
                changeIdFrag.add(new Component[]{new Label("gitWorkflowSteps", this.getProposeWorkflow("propose_git.md", repoUrl.url, this.ticket.number)).setEscapeModelStrings(false)});
                this.add(new Component[]{changeIdFrag});
            } else {
                Fragment fragment = new Fragment("patchset", "canNotProposeFragment", (MarkupContainer)this);
                String reason = "";
                reason = this.ticket.isClosed() ? this.getString("gb.ticketIsClosed") : (repository.isMirror ? this.getString("gb.repositoryIsMirror") : (repository.isFrozen ? this.getString("gb.repositoryIsFrozen") : (!repository.acceptNewPatchsets ? this.getString("gb.repositoryDoesNotAcceptPatchsets") : (!canPropose ? (UserModel.ANONYMOUS.equals(user) ? this.getString("gb.anonymousCanNotPropose") : this.getString("gb.youDoNotHaveClonePermission")) : this.getString("gb.serverDoesNotAcceptPatchsets")))));
                fragment.add(new Component[]{new Label("reason", reason)});
                this.add(new Component[]{fragment});
            }
        } else {
            Fragment patchsetFrag = new Fragment("patchset", "patchsetFragment", (MarkupContainer)this);
            patchsetFrag.add(new Component[]{new Label("commitsInPatchset", MessageFormat.format(this.getString("gb.commitsInPatchsetN"), currentPatchset.number))});
            patchsetFrag.add(new Component[]{this.createMergePanel(user, repository)});
            if (this.ticket.isOpen()) {
                Fragment panel = this.createPatchsetPanel("panel", repository, user);
                patchsetFrag.add(new Component[]{panel});
                this.addUserAttributions((MarkupContainer)patchsetFrag, currentRevision, 40);
                this.addUserAttributions((MarkupContainer)panel, currentRevision, 0);
                this.addDateAttributions((MarkupContainer)panel, currentRevision);
            } else {
                patchsetFrag.add(new Component[]{new Label("panel").setVisible(false)});
            }
            List<RevCommit> commits = JGitUtils.getRevLog(this.getRepository(), currentPatchset.base, currentPatchset.tip);
            ListDataProvider commitsDp = new ListDataProvider(commits);
            DataView<RevCommit> commitsView = new DataView<RevCommit>("commit", (IDataProvider)commitsDp){
                private static final long serialVersionUID = 1L;

                public void populateItem(Item<RevCommit> item) {
                    RevCommit commit = (RevCommit)item.getModelObject();
                    PersonIdent author = commit.getAuthorIdent();
                    item.add(new Component[]{new AvatarImage("authorAvatar", author.getName(), author.getEmailAddress(), null, 16, false)});
                    item.add(new Component[]{new Label("author", commit.getAuthorIdent().getName())});
                    item.add(new Component[]{new LinkPanel("commitId", null, TicketPage.this.getShortObjectId(commit.getName()), CommitPage.class, WicketUtils.newObjectParameter(TicketPage.this.repositoryName, commit.getName()), true)});
                    item.add(new Component[]{new LinkPanel("diff", "link", this.getString("gb.diff"), CommitDiffPage.class, WicketUtils.newObjectParameter(TicketPage.this.repositoryName, commit.getName()), true)});
                    item.add(new Component[]{new Label("title", StringUtils.trimString(commit.getShortMessage(), 60))});
                    item.add(new Component[]{WicketUtils.createDateLabel("commitDate", JGitUtils.getAuthorDate(commit), GitBlitWebSession.get().getTimezone(), TicketPage.this.getTimeUtils(), false)});
                    item.add(new Component[]{new DiffStatPanel("commitDiffStat", 0, 0, true)});
                }
            };
            patchsetFrag.add(new Component[]{commitsView});
            this.add(new Component[]{patchsetFrag});
        }
        Fragment revisionHistory = new Fragment("activity", "activityFragment", (MarkupContainer)this);
        ArrayList<TicketModel.Change> events = new ArrayList<TicketModel.Change>(this.ticket.changes);
        Collections.sort(events);
        Collections.reverse(events);
        ListDataProvider eventsDp = new ListDataProvider(events);
        DataView<TicketModel.Change> eventsView = new DataView<TicketModel.Change>("event", (IDataProvider)eventsDp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<TicketModel.Change> item) {
                TicketModel.Change event = (TicketModel.Change)item.getModelObject();
                TicketPage.this.addUserAttributions((MarkupContainer)item, event, 16);
                if (event.hasPatchset()) {
                    TicketModel.Patchset patchset = event.patchset;
                    String what = event.isStatusChange() && TicketModel.Status.New == event.getStatus() ? this.getString("gb.proposedThisChange") : (patchset.rev == 1 ? MessageFormat.format(this.getString("gb.uploadedPatchsetN"), patchset.number) : (patchset.added == 1 ? this.getString("gb.addedOneCommit") : MessageFormat.format(this.getString("gb.addedNCommits"), patchset.added)));
                    item.add(new Component[]{new Label("what", what)});
                    LinkPanel psr = new LinkPanel("patchsetRevision", null, patchset.number + "-" + patchset.rev, ComparePage.class, WicketUtils.newRangeParameter(TicketPage.this.repositoryName, patchset.parent == null ? patchset.base : patchset.parent, patchset.tip), true);
                    WicketUtils.setHtmlTooltip((Component)psr, patchset.toString());
                    WicketUtils.setCssClass((Component)psr, "aui-lozenge aui-lozenge-subtle");
                    item.add(new Component[]{psr});
                    String typeCss = TicketPage.this.getPatchsetTypeCss(patchset.type);
                    Label typeLabel = new Label("patchsetType", patchset.type.toString());
                    if (typeCss == null) {
                        typeLabel.setVisible(false);
                    } else {
                        WicketUtils.setCssClass((Component)typeLabel, typeCss);
                    }
                    item.add(new Component[]{typeLabel});
                    Link deleteLink = TicketPage.this.createDeletePatchsetLink(repository, patchset);
                    if (user.canDeleteRef(repository)) {
                        item.add(new Component[]{deleteLink.setVisible(patchset.canDelete)});
                    } else {
                        item.add(new Component[]{deleteLink.setVisible(false)});
                    }
                    item.add(new Component[]{new DiffStatPanel("patchsetDiffStat", patchset.insertions, patchset.deletions, patchset.rev > 1)});
                } else if (event.hasComment()) {
                    item.add(new Component[]{new Label("what", this.getString("gb.commented"))});
                    item.add(new Component[]{new Label("patchsetRevision").setVisible(false)});
                    item.add(new Component[]{new Label("patchsetType").setVisible(false)});
                    item.add(new Component[]{new Label("deleteRevision").setVisible(false)});
                    item.add(new Component[]{new Label("patchsetDiffStat").setVisible(false)});
                } else if (event.hasReference()) {
                    switch (event.reference.getSourceType()) {
                        case Commit: {
                            int shaLen = TicketPage.this.app().settings().getInteger("web.shortCommitIdLength", 6);
                            item.add(new Component[]{new Label("what", this.getString("gb.referencedByCommit"))});
                            LinkPanel psr = new LinkPanel("patchsetRevision", null, event.reference.toString().substring(0, shaLen), CommitPage.class, WicketUtils.newObjectParameter(TicketPage.this.repositoryName, event.reference.toString()), true);
                            WicketUtils.setHtmlTooltip((Component)psr, event.reference.toString());
                            WicketUtils.setCssClass((Component)psr, "ticketReference-commit shortsha1");
                            item.add(new Component[]{psr});
                            break;
                        }
                        case Ticket: {
                            String text = MessageFormat.format("ticket/{0}", event.reference.ticketId);
                            item.add(new Component[]{new Label("what", this.getString("gb.referencedByTicket"))});
                            LinkPanel psr = new LinkPanel("patchsetRevision", null, text, TicketsPage.class, WicketUtils.newObjectParameter(TicketPage.this.repositoryName, event.reference.ticketId.toString()), true);
                            WicketUtils.setCssClass((Component)psr, "ticketReference-comment");
                            item.add(new Component[]{psr});
                            break;
                        }
                        default: {
                            item.add(new Component[]{new Label("what").setVisible(false)});
                            item.add(new Component[]{new Label("patchsetRevision").setVisible(false)});
                        }
                    }
                    item.add(new Component[]{new Label("patchsetType").setVisible(false)});
                    item.add(new Component[]{new Label("deleteRevision").setVisible(false)});
                    item.add(new Component[]{new Label("patchsetDiffStat").setVisible(false)});
                } else if (event.hasReview()) {
                    String score;
                    switch (event.review.score) {
                        case approved: {
                            score = "<span style='color:darkGreen'>" + TicketPage.this.getScoreDescription(event.review.score) + "</span>";
                            break;
                        }
                        case vetoed: {
                            score = "<span style='color:darkRed'>" + TicketPage.this.getScoreDescription(event.review.score) + "</span>";
                            break;
                        }
                        default: {
                            score = TicketPage.this.getScoreDescription(event.review.score);
                        }
                    }
                    item.add(new Component[]{new Label("what", MessageFormat.format(this.getString("gb.reviewedPatchsetRev"), event.review.patchset, event.review.rev, score)).setEscapeModelStrings(false)});
                    item.add(new Component[]{new Label("patchsetRevision").setVisible(false)});
                    item.add(new Component[]{new Label("patchsetType").setVisible(false)});
                    item.add(new Component[]{new Label("deleteRevision").setVisible(false)});
                    item.add(new Component[]{new Label("patchsetDiffStat").setVisible(false)});
                } else {
                    item.add(new Component[]{new Label("patchsetRevision").setVisible(false)});
                    item.add(new Component[]{new Label("patchsetType").setVisible(false)});
                    item.add(new Component[]{new Label("deleteRevision").setVisible(false)});
                    item.add(new Component[]{new Label("patchsetDiffStat").setVisible(false)});
                    String what = "";
                    if (event.isStatusChange()) {
                        switch (event.getStatus()) {
                            case New: {
                                if (TicketPage.this.ticket.isProposal()) {
                                    what = this.getString("gb.proposedThisChange");
                                    break;
                                }
                                what = this.getString("gb.createdThisTicket");
                                break;
                            }
                        }
                    }
                    item.add(new Component[]{new Label("what", what).setVisible(what.length() > 0)});
                }
                TicketPage.this.addDateAttributions((MarkupContainer)item, event);
                if (event.hasFieldChanges()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("<table class=\"summary\"><tbody>");
                    block17: for (Map.Entry<TicketModel.Field, String> entry : event.fields.entrySet()) {
                        String value;
                        switch (entry.getKey()) {
                            case body: {
                                String body = entry.getValue();
                                if (event.isStatusChange() && TicketModel.Status.New == event.getStatus() && StringUtils.isEmpty(body)) continue block17;
                                if (StringUtils.isEmpty(body)) {
                                    value = "<i>" + ESC_NIL + "</i>";
                                    break;
                                }
                                value = StringUtils.trimString(body, 60);
                                break;
                            }
                            case status: {
                                TicketModel.Status status = event.getStatus();
                                String css = TicketsUI.getLozengeClass(status, true);
                                value = String.format("<span class=\"%1$s\">%2$s</span>", css, status.toString());
                                break;
                            }
                            default: {
                                value = StringUtils.isEmpty(entry.getValue()) ? "<i>" + ESC_NIL + "</i>" : StringUtils.escapeForHtml(entry.getValue(), false);
                            }
                        }
                        sb.append("<tr><th style=\"width:70px;\">");
                        try {
                            sb.append(this.getString("gb." + entry.getKey().name()));
                        }
                        catch (Exception e) {
                            sb.append(entry.getKey().name());
                        }
                        sb.append("</th><td>");
                        sb.append(value);
                        sb.append("</td></tr>");
                    }
                    sb.append("</tbody></table>");
                    String safeHtml = TicketPage.this.app().xssFilter().relaxed(sb.toString());
                    item.add(new Component[]{new Label("fields", safeHtml).setEscapeModelStrings(false)});
                } else {
                    item.add(new Component[]{new Label("fields").setVisible(false)});
                }
            }
        };
        revisionHistory.add(new Component[]{eventsView});
        this.add(new Component[]{revisionHistory});
    }

    protected void addUserAttributions(MarkupContainer container2, TicketModel.Change entry, int avatarSize) {
        UserModel commenter = this.app().users().getUserModel(entry.author);
        if (commenter == null) {
            container2.add(new Component[]{new AvatarImage("changeAvatar", entry.author, entry.author, null, avatarSize, false).setVisible(avatarSize > 0)});
            container2.add(new Component[]{new Label("changeAuthor", entry.author.toLowerCase())});
        } else {
            container2.add(new Component[]{new AvatarImage("changeAvatar", commenter.getDisplayName(), commenter.emailAddress, avatarSize > 24 ? "gravatar-round" : null, avatarSize, true).setVisible(avatarSize > 0)});
            container2.add(new Component[]{new LinkPanel("changeAuthor", null, commenter.getDisplayName(), UserPage.class, WicketUtils.newUsernameParameter(commenter.username))});
        }
    }

    protected void addDateAttributions(MarkupContainer container2, TicketModel.Change entry) {
        container2.add(new Component[]{WicketUtils.createDateLabel("changeDate", entry.date, GitBlitWebSession.get().getTimezone(), this.getTimeUtils(), false)});
        if (entry.hasComment()) {
            container2.setOutputMarkupId(true);
            container2.add(new IBehavior[]{new AttributeModifier("id", (IModel)Model.of((Serializable)((Object)entry.getId())))});
            ExternalLink link = new ExternalLink("changeLink", "#" + entry.getId());
            container2.add(new Component[]{link});
        } else {
            container2.add(new Component[]{new Label("changeLink").setVisible(false)});
        }
    }

    protected String getProposeWorkflow(String resource, String url, long ticketId) {
        String md = this.readResource(resource);
        md = md.replace("${url}", url);
        md = md.replace("${repo}", StringUtils.getLastPathElement(StringUtils.stripDotGit(this.repositoryName)));
        md = md.replace("${ticketId}", "" + ticketId);
        md = md.replace("${patchset}", "1");
        md = md.replace("${reviewBranch}", Repository.shortenRefName((String)PatchsetCommand.getTicketBranch(ticketId)));
        String integrationBranch = Repository.shortenRefName((String)this.getRepositoryModel().mergeTo);
        if (!StringUtils.isEmpty(this.ticket.mergeTo)) {
            integrationBranch = this.ticket.mergeTo;
        }
        md = md.replace("${integrationBranch}", integrationBranch);
        return MarkdownUtils.transformMarkdown(md);
    }

    protected Fragment createPatchsetPanel(String wicketId, RepositoryModel repository, UserModel user) {
        final TicketModel.Patchset currentPatchset = this.ticket.getCurrentPatchset();
        ArrayList<TicketModel.Patchset> patchsets = new ArrayList<TicketModel.Patchset>(this.ticket.getPatchsetRevisions(currentPatchset.number));
        patchsets.remove(currentPatchset);
        Collections.reverse(patchsets);
        Fragment panel = new Fragment(wicketId, "collapsiblePatchsetFragment", (MarkupContainer)this);
        String ps = "<b>" + currentPatchset.number + "</b>";
        if (currentPatchset.rev == 1) {
            panel.add(new Component[]{new Label("uploadedWhat", MessageFormat.format(this.getString("gb.uploadedPatchsetN"), ps)).setEscapeModelStrings(false)});
        } else {
            String rev = "<b>" + currentPatchset.rev + "</b>";
            panel.add(new Component[]{new Label("uploadedWhat", MessageFormat.format(this.getString("gb.uploadedPatchsetNRevisionN"), ps, rev)).setEscapeModelStrings(false)});
        }
        panel.add(new Component[]{new LinkPanel("patchId", null, "rev " + currentPatchset.rev, CommitPage.class, WicketUtils.newObjectParameter(this.repositoryName, currentPatchset.tip), true)});
        panel.add(new Component[]{new LinkPanel("compareMergeBase", null, this.getString("gb.compareToMergeBase"), ComparePage.class, WicketUtils.newRangeParameter(this.repositoryName, currentPatchset.base, currentPatchset.tip), true)});
        ListDataProvider compareMenuDp = new ListDataProvider(patchsets);
        DataView<TicketModel.Patchset> compareMenu = new DataView<TicketModel.Patchset>("comparePatch", (IDataProvider)compareMenuDp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<TicketModel.Patchset> item) {
                TicketModel.Patchset patchset = (TicketModel.Patchset)item.getModelObject();
                LinkPanel link = new LinkPanel("compareLink", null, MessageFormat.format(this.getString("gb.compareToN"), patchset.number + "-" + patchset.rev), ComparePage.class, WicketUtils.newRangeParameter(TicketPage.this.getRepositoryModel().name, patchset.tip, currentPatchset.tip), true);
                item.add(new Component[]{link});
            }
        };
        panel.add(new Component[]{compareMenu});
        List<TicketModel.Change> reviews = this.ticket.getReviews(currentPatchset);
        ListDataProvider reviewsDp = new ListDataProvider(reviews);
        DataView<TicketModel.Change> reviewsView = new DataView<TicketModel.Change>("reviews", (IDataProvider)reviewsDp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<TicketModel.Change> item) {
                TicketModel.Change change = (TicketModel.Change)item.getModelObject();
                String username = change.author;
                UserModel user = TicketPage.this.app().users().getUserModel(username);
                if (user == null) {
                    item.add(new Component[]{new Label("reviewer", username)});
                } else {
                    item.add(new Component[]{new LinkPanel("reviewer", null, user.getDisplayName(), UserPage.class, WicketUtils.newUsernameParameter(username))});
                }
                TicketModel.Review review = change.review;
                Label scoreLabel = new Label("score");
                String scoreClass = TicketPage.this.getScoreClass(review.score);
                String tooltip = TicketPage.this.getScoreDescription(review.score);
                WicketUtils.setCssClass((Component)scoreLabel, scoreClass);
                if (!StringUtils.isEmpty(tooltip)) {
                    WicketUtils.setHtmlTooltip((Component)scoreLabel, tooltip);
                }
                item.add(new Component[]{scoreLabel});
            }
        };
        panel.add(new Component[]{reviewsView});
        if (this.ticket.isOpen() && user.canReviewPatchset(repository) && this.app().tickets().isAcceptingTicketUpdates(repository)) {
            TicketModel.Review myReview = null;
            for (TicketModel.Change change : this.ticket.getReviews(currentPatchset)) {
                if (!change.author.equals(user.username)) continue;
                myReview = change.review;
            }
            Fragment reviewControls = new Fragment("reviewControls", "reviewControlsFragment", (MarkupContainer)this);
            if (user.canApprovePatchset(repository) && (myReview == null || TicketModel.Score.approved != myReview.score)) {
                reviewControls.add(new Component[]{this.createReviewLink("approveLink", TicketModel.Score.approved)});
            } else {
                reviewControls.add(new Component[]{new Label("approveLink").setVisible(false)});
            }
            if (myReview == null || TicketModel.Score.looks_good != myReview.score) {
                reviewControls.add(new Component[]{this.createReviewLink("looksGoodLink", TicketModel.Score.looks_good)});
            } else {
                reviewControls.add(new Component[]{new Label("looksGoodLink").setVisible(false)});
            }
            if (myReview == null || TicketModel.Score.needs_improvement != myReview.score) {
                reviewControls.add(new Component[]{this.createReviewLink("needsImprovementLink", TicketModel.Score.needs_improvement)});
            } else {
                reviewControls.add(new Component[]{new Label("needsImprovementLink").setVisible(false)});
            }
            if (user.canVetoPatchset(repository) && (myReview == null || TicketModel.Score.vetoed != myReview.score)) {
                reviewControls.add(new Component[]{this.createReviewLink("vetoLink", TicketModel.Score.vetoed)});
            } else {
                reviewControls.add(new Component[]{new Label("vetoLink").setVisible(false)});
            }
            panel.add(new Component[]{reviewControls});
        } else {
            panel.add(new Component[]{new Label("reviewControls").setVisible(false)});
        }
        String insertions = MessageFormat.format("<span style=\"color:darkGreen;font-weight:bold;\">+{0}</span>", this.ticket.insertions);
        String deletions = MessageFormat.format("<span style=\"color:darkRed;font-weight:bold;\">-{0}</span>", this.ticket.deletions);
        panel.add(new Component[]{new Label("patchsetStat", MessageFormat.format(StringUtils.escapeForHtml(this.getString("gb.diffStat"), false), insertions, deletions)).setEscapeModelStrings(false)});
        List<PathModel.PathChangeModel> paths = JGitUtils.getFilesInRange(this.getRepository(), currentPatchset.base, currentPatchset.tip);
        ListDataProvider pathsDp = new ListDataProvider(paths);
        DataView<PathModel.PathChangeModel> pathsView = new DataView<PathModel.PathChangeModel>("changedPath", (IDataProvider)pathsDp){
            private static final long serialVersionUID = 1L;
            int counter;

            public void populateItem(Item<PathModel.PathChangeModel> item) {
                PathModel.PathChangeModel entry = (PathModel.PathChangeModel)item.getModelObject();
                Label changeType = new Label("changeType", "");
                WicketUtils.setChangeTypeCssClass((Component)changeType, entry.changeType);
                TicketPage.this.setChangeTypeTooltip((Component)changeType, entry.changeType);
                item.add(new Component[]{changeType});
                boolean hasSubmodule = false;
                String submodulePath = null;
                if (entry.isTree()) {
                    item.add(new Component[]{new LinkPanel("pathName", null, entry.path, TreePage.class, WicketUtils.newPathParameter(TicketPage.this.repositoryName, currentPatchset.tip, entry.path), true)});
                    item.add(new Component[]{new Label("diffStat").setVisible(false)});
                } else if (entry.isSubmodule()) {
                    String submoduleId = entry.objectId;
                    SubmoduleModel submodule = TicketPage.this.getSubmodule(entry.path);
                    submodulePath = submodule.gitblitPath;
                    hasSubmodule = submodule.hasSubmodule;
                    item.add(new Component[]{new LinkPanel("pathName", "list", entry.path + " @ " + TicketPage.this.getShortObjectId(submoduleId), TreePage.class, WicketUtils.newPathParameter(submodulePath, submoduleId, ""), true).setEnabled(hasSubmodule)});
                    item.add(new Component[]{new Label("diffStat").setVisible(false)});
                } else {
                    String displayPath = entry.path;
                    String path = entry.path;
                    if (entry.isSymlink()) {
                        RevCommit commit = JGitUtils.getCommit(TicketPage.this.getRepository(), PatchsetCommand.getTicketBranch(TicketPage.this.ticket.number));
                        path = JGitUtils.getStringContent(TicketPage.this.getRepository(), commit.getTree(), path, new String[0]);
                        displayPath = entry.path + " -> " + path;
                    }
                    if (entry.changeType.equals((Object)DiffEntry.ChangeType.ADD)) {
                        item.add(new Component[]{new LinkPanel("pathName", "list", displayPath, BlobPage.class, WicketUtils.newPathParameter(TicketPage.this.repositoryName, currentPatchset.tip, path), true)});
                    } else if (entry.changeType.equals((Object)DiffEntry.ChangeType.DELETE)) {
                        item.add(new Component[]{new Label("pathName", displayPath)});
                    } else {
                        item.add(new Component[]{new LinkPanel("pathName", "list", displayPath, BlobDiffPage.class, WicketUtils.newPathParameter(TicketPage.this.repositoryName, currentPatchset.tip, path), true)});
                    }
                    item.add(new Component[]{new DiffStatPanel("diffStat", entry.insertions, entry.deletions, true)});
                }
                if (entry.isSubmodule()) {
                    item.add(new Component[]{TicketPage.this.setNewTarget(new BookmarkablePageLink("diff", BlobDiffPage.class, WicketUtils.newPathParameter(TicketPage.this.repositoryName, entry.commitId, entry.path))).setEnabled(!entry.changeType.equals((Object)DiffEntry.ChangeType.ADD))});
                    item.add(new Component[]{new BookmarkablePageLink("view", CommitPage.class, WicketUtils.newObjectParameter(submodulePath, entry.objectId)).setEnabled(hasSubmodule)});
                } else {
                    item.add(new Component[]{TicketPage.this.setNewTarget(new BookmarkablePageLink("diff", BlobDiffPage.class, WicketUtils.newBlobDiffParameter(TicketPage.this.repositoryName, currentPatchset.base, currentPatchset.tip, entry.path))).setEnabled(!entry.changeType.equals((Object)DiffEntry.ChangeType.ADD) && !entry.changeType.equals((Object)DiffEntry.ChangeType.DELETE))});
                    item.add(new Component[]{TicketPage.this.setNewTarget(new BookmarkablePageLink("view", BlobPage.class, WicketUtils.newPathParameter(TicketPage.this.repositoryName, currentPatchset.tip, entry.path))).setEnabled(!entry.changeType.equals((Object)DiffEntry.ChangeType.DELETE))});
                }
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        panel.add(new Component[]{pathsView});
        this.addPtCheckoutInstructions(user, repository, (MarkupContainer)panel);
        this.addGitCheckoutInstructions(user, repository, (MarkupContainer)panel);
        return panel;
    }

    protected IconAjaxLink<String> createReviewLink(String wicketId, final TicketModel.Score score) {
        return new IconAjaxLink<String>(wicketId, this.getScoreClass(score), (IModel)Model.of((Serializable)((Object)this.getScoreDescription(score)))){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                TicketPage.this.review(score);
            }
        };
    }

    protected String getScoreClass(TicketModel.Score score) {
        switch (score) {
            case vetoed: {
                return "fa fa-exclamation-circle";
            }
            case needs_improvement: {
                return "fa fa-thumbs-o-down";
            }
            case looks_good: {
                return "fa fa-thumbs-o-up";
            }
            case approved: {
                return "fa fa-check-circle";
            }
        }
        return "fa fa-minus-circle";
    }

    protected String getScoreDescription(TicketModel.Score score) {
        String description;
        switch (score) {
            case vetoed: {
                description = this.getString("gb.veto");
                break;
            }
            case needs_improvement: {
                description = this.getString("gb.needsImprovement");
                break;
            }
            case looks_good: {
                description = this.getString("gb.looksGood");
                break;
            }
            case approved: {
                description = this.getString("gb.approve");
                break;
            }
            default: {
                description = this.getString("gb.hasNotReviewed");
            }
        }
        return String.format("%1$s (%2$+d)", description, score.getValue());
    }

    protected void review(TicketModel.Score score) {
        UserModel user = GitBlitWebSession.get().getUser();
        TicketModel.Patchset ps = this.ticket.getCurrentPatchset();
        TicketModel.Change change = new TicketModel.Change(user.username);
        change.review(ps, score, !this.ticket.isReviewer(user.username));
        if (!this.ticket.isWatching(user.username)) {
            change.watch(user.username);
        }
        TicketModel updatedTicket = this.app().tickets().updateTicket(this.getRepositoryModel(), this.ticket.number, change);
        this.app().tickets().createNotifier().sendMailing(updatedTicket);
        this.redirectTo(TicketsPage.class, this.getPageParameters());
    }

    protected <X extends MarkupContainer> X setNewTarget(X x) {
        x.add(new IBehavior[]{new SimpleAttributeModifier("target", (CharSequence)"_blank")});
        return x;
    }

    protected void addGitCheckoutInstructions(UserModel user, RepositoryModel repository, MarkupContainer panel) {
        panel.add(new Component[]{new Label("gitStep1", MessageFormat.format(this.getString("gb.stepN"), 1))});
        panel.add(new Component[]{new Label("gitStep2", MessageFormat.format(this.getString("gb.stepN"), 2))});
        String ticketBranch = Repository.shortenRefName((String)PatchsetCommand.getTicketBranch(this.ticket.number));
        String step1 = "git fetch origin";
        String step2 = MessageFormat.format("git checkout {0} && git pull --ff-only\nOR\ngit checkout {0} && git reset --hard origin/{0}", ticketBranch);
        panel.add(new Component[]{new Label("gitPreStep1", step1)});
        panel.add(new Component[]{new Label("gitPreStep2", step2)});
        panel.add(new Component[]{this.createCopyFragment("gitCopyStep1", step1.replace("\n", " && "))});
        panel.add(new Component[]{this.createCopyFragment("gitCopyStep2", step2.replace("\n", " && "))});
    }

    protected void addPtCheckoutInstructions(UserModel user, RepositoryModel repository, MarkupContainer panel) {
        String step1 = MessageFormat.format("pt checkout {0,number,0}", this.ticket.number);
        panel.add(new Component[]{new Label("ptPreStep", step1)});
        panel.add(new Component[]{this.createCopyFragment("ptCopyStep", step1)});
    }

    protected Component createMergePanel(UserModel user, RepositoryModel repository) {
        TicketModel.Patchset patchset = this.ticket.getCurrentPatchset();
        if (patchset == null) {
            return new Label("mergePanel");
        }
        boolean allowMerge = repository.requireApproval ? this.ticket.isOpen() && this.ticket.isApproved(patchset) : this.ticket.isOpen() && !this.ticket.isVetoed(patchset);
        JGitUtils.MergeStatus mergeStatus = JGitUtils.canMerge(this.getRepository(), patchset.tip, this.ticket.mergeTo, repository.mergeType);
        if (allowMerge) {
            if (JGitUtils.MergeStatus.MERGEABLE == mergeStatus) {
                Fragment mergePanel = new Fragment("mergePanel", "mergeableFragment", (MarkupContainer)this);
                mergePanel.add(new Component[]{new Label("mergeTitle", MessageFormat.format(this.getString("gb.patchsetMergeable"), this.ticket.mergeTo))});
                if (user.canPush(repository)) {
                    SimpleAjaxLink<String> mergeButton = new SimpleAjaxLink<String>("mergeButton", (IModel)Model.of((Serializable)((Object)this.getString("gb.merge")))){
                        private static final long serialVersionUID = 1L;

                        public void onClick(AjaxRequestTarget target) {
                            TicketModel refreshedTicket;
                            TicketModel.Patchset patchset = TicketPage.this.ticket.getCurrentPatchset();
                            if (patchset.equals((refreshedTicket = TicketPage.this.app().tickets().getTicket(TicketPage.this.getRepositoryModel(), TicketPage.this.ticket.number)).getCurrentPatchset())) {
                                if (!refreshedTicket.isVetoed(patchset)) {
                                    TicketPage.this.app().tickets().exec(new Runnable(){

                                        @Override
                                        public void run() {
                                            PatchsetReceivePack rp = new PatchsetReceivePack(TicketPage.this.app().gitblit(), TicketPage.this.getRepository(), TicketPage.this.getRepositoryModel(), GitBlitWebSession.get().getUser());
                                            JGitUtils.MergeStatus result = rp.merge(refreshedTicket);
                                            if (JGitUtils.MergeStatus.MERGED == result) {
                                                rp.sendAll();
                                            } else {
                                                String msg = MessageFormat.format("Failed to merge ticket {0,number,0}: {1}", TicketPage.this.ticket.number, result.name());
                                                TicketPage.this.logger.error(msg);
                                                GitBlitWebSession.get().cacheErrorMessage(msg);
                                            }
                                        }
                                    });
                                } else {
                                    String msg = MessageFormat.format("Can not merge ticket {0,number,0}, patchset {1,number,0} has been vetoed!", TicketPage.this.ticket.number, patchset.number);
                                    GitBlitWebSession.get().cacheErrorMessage(msg);
                                    TicketPage.this.logger.error(msg);
                                }
                            } else {
                                String msg = MessageFormat.format("Can not merge ticket {0,number,0}, the patchset has been updated!", TicketPage.this.ticket.number);
                                GitBlitWebSession.get().cacheErrorMessage(msg);
                                TicketPage.this.logger.error(msg);
                            }
                            TicketPage.this.redirectTo(TicketsPage.class, TicketPage.this.getPageParameters());
                        }
                    };
                    mergePanel.add(new Component[]{mergeButton});
                    Component instructions = this.getMergeInstructions(user, repository, "mergeMore", "gb.patchsetMergeableMore");
                    mergePanel.add(new Component[]{instructions});
                } else {
                    mergePanel.add(new Component[]{new Label("mergeButton").setVisible(false)});
                    mergePanel.add(new Component[]{new Label("mergeMore").setVisible(false)});
                }
                return mergePanel;
            }
            if (JGitUtils.MergeStatus.ALREADY_MERGED == mergeStatus) {
                Fragment mergePanel = new Fragment("mergePanel", "alreadyMergedFragment", (MarkupContainer)this);
                mergePanel.add(new Component[]{new Label("mergeTitle", MessageFormat.format(this.getString("gb.patchsetAlreadyMerged"), this.ticket.mergeTo))});
                return mergePanel;
            }
            if (JGitUtils.MergeStatus.MISSING_INTEGRATION_BRANCH == mergeStatus) {
                Fragment mergePanel = new Fragment("mergePanel", "notMergeableFragment", (MarkupContainer)this);
                mergePanel.add(new Component[]{new Label("mergeTitle", MessageFormat.format(this.getString("gb.patchsetNotMergeable"), this.ticket.mergeTo))});
                mergePanel.add(new Component[]{new Label("mergeMore", MessageFormat.format(this.getString("gb.missingIntegrationBranchMore"), this.ticket.mergeTo))});
                return mergePanel;
            }
            Fragment mergePanel = new Fragment("mergePanel", "notMergeableFragment", (MarkupContainer)this);
            mergePanel.add(new Component[]{new Label("mergeTitle", MessageFormat.format(this.getString("gb.patchsetNotMergeable"), this.ticket.mergeTo))});
            if (user.canPush(repository)) {
                Component instructions = this.getMergeInstructions(user, repository, "mergeMore", "gb.patchsetNotMergeableMore");
                mergePanel.add(new Component[]{instructions});
            } else {
                mergePanel.add(new Component[]{new Label("mergeMore").setVisible(false)});
            }
            return mergePanel;
        }
        if (JGitUtils.MergeStatus.ALREADY_MERGED == mergeStatus) {
            Fragment mergePanel = new Fragment("mergePanel", "alreadyMergedFragment", (MarkupContainer)this);
            mergePanel.add(new Component[]{new Label("mergeTitle", MessageFormat.format(this.getString("gb.patchsetAlreadyMerged"), this.ticket.mergeTo))});
            return mergePanel;
        }
        if (this.ticket.isVetoed(patchset)) {
            Fragment mergePanel = new Fragment("mergePanel", "vetoedFragment", (MarkupContainer)this);
            mergePanel.add(new Component[]{new Label("mergeTitle", MessageFormat.format(this.getString("gb.patchsetNotMergeable"), this.ticket.mergeTo))});
            return mergePanel;
        }
        if (repository.requireApproval) {
            Fragment mergePanel = new Fragment("mergePanel", "notApprovedFragment", (MarkupContainer)this);
            mergePanel.add(new Component[]{new Label("mergeTitle", MessageFormat.format(this.getString("gb.patchsetNotApproved"), this.ticket.mergeTo))});
            mergePanel.add(new Component[]{new Label("mergeMore", MessageFormat.format(this.getString("gb.patchsetNotApprovedMore"), this.ticket.mergeTo))});
            return mergePanel;
        }
        return new Label("mergePanel");
    }

    protected Component getMergeInstructions(UserModel user, RepositoryModel repository, String markupId, String infoKey) {
        Fragment cmd = new Fragment(markupId, "commandlineMergeFragment", (MarkupContainer)this);
        cmd.add(new Component[]{new Label("instructions", MessageFormat.format(this.getString(infoKey), this.ticket.mergeTo))});
        cmd.add(new Component[]{new Label("mergeStep1", MessageFormat.format(this.getString("gb.stepN"), 1))});
        cmd.add(new Component[]{new Label("mergeStep2", MessageFormat.format(this.getString("gb.stepN"), 2))});
        cmd.add(new Component[]{new Label("mergeStep3", MessageFormat.format(this.getString("gb.stepN"), 3))});
        String ticketBranch = Repository.shortenRefName((String)PatchsetCommand.getTicketBranch(this.ticket.number));
        String reviewBranch = PatchsetCommand.getReviewBranch(this.ticket.number);
        String step1 = MessageFormat.format("git checkout -b {0} {1}", reviewBranch, this.ticket.mergeTo);
        String step2 = MessageFormat.format("git pull origin {0}", ticketBranch);
        String step3 = MessageFormat.format("git checkout {0}\ngit merge {1}\ngit push origin {0}\ngit branch -d {1}", this.ticket.mergeTo, reviewBranch);
        cmd.add(new Component[]{new Label("mergePreStep1", step1)});
        cmd.add(new Component[]{new Label("mergePreStep2", step2)});
        cmd.add(new Component[]{new Label("mergePreStep3", step3)});
        cmd.add(new Component[]{this.createCopyFragment("mergeCopyStep1", step1.replace("\n", " && "))});
        cmd.add(new Component[]{this.createCopyFragment("mergeCopyStep2", step2.replace("\n", " && "))});
        cmd.add(new Component[]{this.createCopyFragment("mergeCopyStep3", step3.replace("\n", " && "))});
        String ptStep = MessageFormat.format("pt pull {0,number,0}", this.ticket.number);
        cmd.add(new Component[]{new Label("ptMergeStep", ptStep)});
        cmd.add(new Component[]{this.createCopyFragment("ptMergeCopyStep", step1.replace("\n", " && "))});
        return cmd;
    }

    protected RepositoryUrl getRepositoryUrl(UserModel user, RepositoryModel repository) {
        HttpServletRequest req = ((WebRequest)this.getRequest()).getHttpServletRequest();
        List<RepositoryUrl> urls = this.app().services().getRepositoryUrls(req, user, repository);
        if (ArrayUtils.isEmpty(urls)) {
            return null;
        }
        RepositoryUrl primary = urls.get(0);
        return primary;
    }

    protected TicketModel getTicket(RevCommit commit) {
        try {
            Map refs = this.getRepository().getRefDatabase().getRefs("refs/tickets/");
            for (Map.Entry entry : refs.entrySet()) {
                if (!((Ref)entry.getValue()).getObjectId().equals((AnyObjectId)commit.getId())) continue;
                long id = PatchsetCommand.getTicketNumber((String)entry.getKey());
                TicketModel ticket = this.app().tickets().getTicket(this.getRepositoryModel(), id);
                return ticket;
            }
        }
        catch (Exception e) {
            this.logger().error("failed to determine ticket from ref", (Throwable)e);
        }
        return null;
    }

    protected String getPatchsetTypeCss(TicketModel.PatchsetType type) {
        String typeCss;
        switch (type) {
            case Rebase: 
            case Rebase_Squash: {
                typeCss = TicketsUI.getLozengeClass(TicketModel.Status.Declined, false);
                break;
            }
            case Squash: 
            case Amend: {
                typeCss = TicketsUI.getLozengeClass(TicketModel.Status.On_Hold, false);
                break;
            }
            case Proposal: {
                typeCss = TicketsUI.getLozengeClass(TicketModel.Status.New, false);
                break;
            }
            default: {
                typeCss = null;
            }
        }
        return typeCss;
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.ticket");
    }

    @Override
    protected Class<? extends BasePage> getRepoNavPageClass() {
        return TicketsPage.class;
    }

    @Override
    protected String getPageTitle(String repositoryName) {
        return "#" + this.ticket.number + " - " + this.ticket.title;
    }

    protected Fragment createCopyFragment(String wicketId, String text) {
        if (this.app().settings().getBoolean("web.allowFlashCopyToClipboard", true)) {
            Fragment copyFragment = new Fragment(wicketId, "clippyPanel", (MarkupContainer)this);
            String baseUrl = WicketUtils.getGitblitURL(this.getRequest());
            ShockWaveComponent clippy = new ShockWaveComponent("clippy", baseUrl + "/clippy.swf");
            clippy.setValue("flashVars", "text=" + StringUtils.encodeURL(text));
            copyFragment.add(new Component[]{clippy});
            return copyFragment;
        }
        Fragment copyFragment = new Fragment(wicketId, "jsPanel", (MarkupContainer)this);
        ContextImage img = WicketUtils.newImage("copyIcon", "clippy.png");
        img.add(new IBehavior[]{new BasePanel.JavascriptTextPrompt("onclick", "Copy to Clipboard (Ctrl+C, Enter)", text)});
        copyFragment.add(new Component[]{img});
        return copyFragment;
    }

    private Link<Void> createDeletePatchsetLink(final RepositoryModel repositoryModel, final TicketModel.Patchset patchset) {
        Link<Void> deleteLink = new Link<Void>("deleteRevision"){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClick() {
                Repository r = TicketPage.this.app().repositories().getRepository(repositoryModel.name);
                UserModel user = GitBlitWebSession.get().getUser();
                if (r == null) {
                    if (TicketPage.this.app().repositories().isCollectingGarbage(repositoryModel.name)) {
                        this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.busyCollectingGarbage"), repositoryModel.name)));
                    } else {
                        this.error((Serializable)((Object)MessageFormat.format("Failed to find repository {0}", repositoryModel.name)));
                    }
                    return;
                }
                String ticketShard = String.format("%02d", TicketPage.this.ticket.number);
                ticketShard = ticketShard.substring(ticketShard.length() - 2);
                String refName = String.format("%s%s/%d/%d", "refs/tickets/", ticketShard, TicketPage.this.ticket.number, patchset.number);
                Ref ref = null;
                boolean success = true;
                try {
                    ref = r.getRef(refName);
                    success = ref != null ? JGitUtils.deleteBranchRef(r, ref.getName()) : false;
                    if (success) {
                        TicketModel updatedTicket;
                        CommitCache.instance().clear(repositoryModel.name, refName);
                        if (RefLogUtils.hasRefLogBranch(r)) {
                            RefLogUtils.deleteRef(user, r, ref);
                        }
                        if ((updatedTicket = TicketPage.this.app().tickets().deletePatchset(TicketPage.this.ticket, patchset, user.username)) == null) {
                            success = false;
                        }
                    }
                }
                catch (IOException e) {
                    TicketPage.this.logger().error("failed to determine ticket from ref", (Throwable)e);
                    success = false;
                }
                finally {
                    r.close();
                }
                if (success) {
                    this.getSession().info(MessageFormat.format(this.getString("gb.deletePatchsetSuccess"), patchset.number));
                    TicketPage.this.logger().info(MessageFormat.format("{0} deleted patchset {1} from ticket {2}", user.username, patchset.number, TicketPage.this.ticket.number));
                } else {
                    this.getSession().error(MessageFormat.format(this.getString("gb.deletePatchsetFailure"), patchset.number));
                }
                String relativeUrl = this.urlFor(TicketsPage.class, TicketPage.this.getPageParameters()).toString();
                String absoluteUrl = RequestUtils.toAbsolutePath((String)relativeUrl);
                this.setResponsePage((Page)new RedirectPage((CharSequence)absoluteUrl));
            }
        };
        WicketUtils.setHtmlTooltip((Component)deleteLink, MessageFormat.format(this.getString("gb.deletePatchset"), patchset.number));
        deleteLink.add(new IBehavior[]{new BasePanel.JavascriptEventConfirmation("onclick", MessageFormat.format(this.getString("gb.deletePatchset"), patchset.number))});
        return deleteLink;
    }
}

