/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.models.RegistrantAccessPermission;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TicketModel;
import com.gitblit.models.UserModel;
import com.gitblit.tickets.QueryBuilder;
import com.gitblit.tickets.QueryResult;
import com.gitblit.tickets.TicketIndexer;
import com.gitblit.tickets.TicketLabel;
import com.gitblit.tickets.TicketMilestone;
import com.gitblit.tickets.TicketResponsible;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.TicketsUI;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.EditMilestonePage;
import com.gitblit.wicket.pages.NewMilestonePage;
import com.gitblit.wicket.pages.NoTicketsPage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.pages.TicketPage;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.TicketListPanel;
import com.gitblit.wicket.panels.TicketSearchForm;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;

public class TicketsPage
extends RepositoryPage {
    final TicketResponsible any;

    public TicketsPage(PageParameters params) {
        super(params);
        boolean acceptingUpdates;
        String q;
        Fragment milestonePanel;
        if (!this.app().tickets().isReady()) {
            this.setResponsePage(SummaryPage.class, WicketUtils.newRepositoryParameter(this.repositoryName));
        } else if (!this.app().tickets().hasTickets(this.getRepositoryModel())) {
            this.setResponsePage(NoTicketsPage.class, WicketUtils.newRepositoryParameter(this.repositoryName));
        } else {
            String id = WicketUtils.getObject(params);
            if (id != null) {
                this.setResponsePage(TicketPage.class, params);
            }
        }
        this.setStatelessHint(true);
        this.any = new TicketResponsible(this.getString("gb.any"), "[* TO *]", null);
        UserModel user = GitBlitWebSession.get().getUser();
        boolean isAuthenticated = user != null && user.isAuthenticated;
        Object[] statiiParam = params.getStringArray(TicketIndexer.Lucene.status.name());
        final String assignedToParam = params.getString(TicketIndexer.Lucene.responsible.name(), null);
        final String milestoneParam = params.getString(TicketIndexer.Lucene.milestone.name(), null);
        final String queryParam = params.getString("q", null);
        String searchParam = params.getString("s", null);
        final String sortBy = TicketIndexer.Lucene.fromString(params.getString("sort", TicketIndexer.Lucene.created.name())).name();
        final boolean desc = !"asc".equals(params.getString("direction", "desc"));
        this.add(new Component[]{new TicketSearchForm("ticketSearchForm", this.repositoryName, searchParam, ((Object)((Object)this)).getClass(), params)});
        final String activeQuery = !StringUtils.isEmpty(searchParam) ? searchParam : (StringUtils.isEmpty(queryParam) ? "" : queryParam);
        QueryBuilder qb = new QueryBuilder(queryParam);
        if (!qb.containsField(TicketIndexer.Lucene.rid.name())) {
            qb.and(TicketIndexer.Lucene.rid.matches(this.getRepositoryModel().getRID()));
        }
        if (!qb.containsField(TicketIndexer.Lucene.responsible.name())) {
            qb.and(TicketIndexer.Lucene.responsible.matches(assignedToParam));
        }
        if (!qb.containsField(TicketIndexer.Lucene.milestone.name())) {
            qb.and(TicketIndexer.Lucene.milestone.matches(milestoneParam));
        }
        if (!qb.containsField(TicketIndexer.Lucene.status.name()) && !ArrayUtils.isEmpty(statiiParam)) {
            boolean not = false;
            QueryBuilder q2 = new QueryBuilder();
            for (Object state : statiiParam) {
                if (((String)state).charAt(0) == '!') {
                    not = true;
                    q2.and(TicketIndexer.Lucene.status.doesNotMatch(((String)state).substring(1)));
                    continue;
                }
                q2.or(TicketIndexer.Lucene.status.matches((String)state));
            }
            if (not) {
                qb.and(q2.toString());
            } else {
                qb.and(q2.toSubquery().toString());
            }
        }
        String luceneQuery = qb.build();
        List<TicketMilestone> milestones = this.app().tickets().getMilestones(this.getRepositoryModel(), TicketModel.Status.Open);
        TicketMilestone currentMilestone = null;
        if (!StringUtils.isEmpty(milestoneParam)) {
            for (TicketMilestone tm : milestones) {
                if (!tm.name.equals(milestoneParam)) continue;
                currentMilestone = this.app().tickets().getMilestone(this.getRepositoryModel(), milestoneParam);
                break;
            }
            if (currentMilestone == null) {
                currentMilestone = new TicketMilestone(milestoneParam);
                String q3 = QueryBuilder.q(TicketIndexer.Lucene.rid.matches(this.getRepositoryModel().getRID())).and(TicketIndexer.Lucene.milestone.matches(milestoneParam)).build();
                currentMilestone.tickets = this.app().tickets().queryFor(q3, 1, 0, TicketIndexer.Lucene.number.name(), true);
                milestones.add(currentMilestone);
            }
        }
        if (currentMilestone == null) {
            milestonePanel = new Fragment("milestonePanel", "noMilestoneFragment", (MarkupContainer)this);
            this.add(new Component[]{milestonePanel});
        } else {
            milestonePanel = new Fragment("milestonePanel", "milestoneProgressFragment", (MarkupContainer)this);
            milestonePanel.add(new Component[]{new Label("currentMilestone", currentMilestone.name)});
            if (currentMilestone.due == null) {
                milestonePanel.add(new Component[]{new Label("currentDueDate", this.getString("gb.notSpecified"))});
            } else {
                milestonePanel.add(new Component[]{WicketUtils.createDateLabel("currentDueDate", currentMilestone.due, GitBlitWebSession.get().getTimezone(), this.getTimeUtils(), false)});
            }
            Label label = new Label("progress");
            WicketUtils.setCssStyle((Component)label, "width:" + currentMilestone.getProgress() + "%;");
            milestonePanel.add(new Component[]{label});
            milestonePanel.add(new Component[]{new LinkPanel("openTickets", null, MessageFormat.format(this.getString("gb.nOpenTickets"), currentMilestone.getOpenTickets()), TicketsPage.class, this.queryParameters(null, currentMilestone.name, TicketsUI.openStatii, null, sortBy, desc, 1))});
            milestonePanel.add(new Component[]{new LinkPanel("closedTickets", null, MessageFormat.format(this.getString("gb.nClosedTickets"), currentMilestone.getClosedTickets()), TicketsPage.class, this.queryParameters(null, currentMilestone.name, TicketsUI.closedStatii, null, sortBy, desc, 1))});
            milestonePanel.add(new Component[]{new Label("totalTickets", MessageFormat.format(this.getString("gb.nTotalTickets"), currentMilestone.getTotalTickets()))});
            this.add(new Component[]{milestonePanel});
        }
        Fragment milestoneDropdown = new Fragment("milestoneDropdown", "milestoneDropdownFragment", (MarkupContainer)this);
        PageParameters resetMilestone = this.queryParameters(queryParam, null, (String[])statiiParam, assignedToParam, sortBy, desc, 1);
        milestoneDropdown.add(new Component[]{new BookmarkablePageLink("resetMilestone", TicketsPage.class, resetMilestone)});
        ListDataProvider milestonesDp = new ListDataProvider(milestones);
        DataView<TicketMilestone> milestonesMenu = new DataView<TicketMilestone>("milestone", (IDataProvider)milestonesDp, (String[])statiiParam, assignedToParam, sortBy, desc){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ String[] val$statiiParam;
            final /* synthetic */ String val$assignedToParam;
            final /* synthetic */ String val$sortBy;
            final /* synthetic */ boolean val$desc;
            {
                this.val$statiiParam = stringArray;
                this.val$assignedToParam = string2;
                this.val$sortBy = string3;
                this.val$desc = bl;
                super(x0, x1);
            }

            public void populateItem(Item<TicketMilestone> item) {
                TicketMilestone tm = (TicketMilestone)item.getModelObject();
                PageParameters params = TicketsPage.this.queryParameters(queryParam, tm.name, this.val$statiiParam, this.val$assignedToParam, this.val$sortBy, this.val$desc, 1);
                item.add(new Component[]{new LinkPanel("milestoneLink", null, tm.name, TicketsPage.class, params).setRenderBodyOnly(true)});
            }
        };
        milestoneDropdown.add(new Component[]{milestonesMenu});
        milestonePanel.add(new Component[]{milestoneDropdown});
        int page = Math.max(1, WicketUtils.getPage(params));
        int pageSize = this.app().settings().getInteger("tickets.perPage", 25);
        List<QueryResult> results = StringUtils.isEmpty(searchParam) ? this.app().tickets().queryFor(luceneQuery, page, pageSize, sortBy, desc) : this.app().tickets().searchFor(this.getRepositoryModel(), searchParam, page, pageSize);
        int totalResults = results.size() == 0 ? 0 : results.get((int)0).totalResults;
        this.add(new Component[]{new BookmarkablePageLink("changesQuery", TicketsPage.class, this.queryParameters(TicketIndexer.Lucene.type.matches(TicketModel.Type.Proposal.name()), milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, 1))});
        this.add(new Component[]{new BookmarkablePageLink("bugsQuery", TicketsPage.class, this.queryParameters(TicketIndexer.Lucene.type.matches(TicketModel.Type.Bug.name()), milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, 1))});
        this.add(new Component[]{new BookmarkablePageLink("enhancementsQuery", TicketsPage.class, this.queryParameters(TicketIndexer.Lucene.type.matches(TicketModel.Type.Enhancement.name()), milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, 1))});
        this.add(new Component[]{new BookmarkablePageLink("tasksQuery", TicketsPage.class, this.queryParameters(TicketIndexer.Lucene.type.matches(TicketModel.Type.Task.name()), milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, 1))});
        this.add(new Component[]{new BookmarkablePageLink("questionsQuery", TicketsPage.class, this.queryParameters(TicketIndexer.Lucene.type.matches(TicketModel.Type.Question.name()), milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, 1))});
        this.add(new Component[]{new BookmarkablePageLink("maintenanceQuery", TicketsPage.class, this.queryParameters(TicketIndexer.Lucene.type.matches(TicketModel.Type.Maintenance.name()), milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, 1))});
        this.add(new Component[]{new BookmarkablePageLink("resetQuery", TicketsPage.class, this.queryParameters(null, milestoneParam, TicketsUI.openStatii, null, null, true, 1))});
        if (isAuthenticated) {
            this.add(new Component[]{new Label("userDivider")});
            this.add(new Component[]{new BookmarkablePageLink("createdQuery", TicketsPage.class, this.queryParameters(TicketIndexer.Lucene.createdby.matches(user.username), milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, 1))});
            this.add(new Component[]{new BookmarkablePageLink("watchedQuery", TicketsPage.class, this.queryParameters(TicketIndexer.Lucene.watchedby.matches(user.username), milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, 1))});
            this.add(new Component[]{new BookmarkablePageLink("mentionsQuery", TicketsPage.class, this.queryParameters(TicketIndexer.Lucene.mentions.matches(user.username), milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, 1))});
        } else {
            this.add(new Component[]{new Label("userDivider").setVisible(false)});
            this.add(new Component[]{new Label("createdQuery").setVisible(false)});
            this.add(new Component[]{new Label("watchedQuery").setVisible(false)});
            this.add(new Component[]{new Label("mentionsQuery").setVisible(false)});
        }
        TreeSet<TicketsUI.TicketQuery> dynamicQueries = new TreeSet<TicketsUI.TicketQuery>();
        for (TicketLabel label : this.app().tickets().getLabels(this.getRepositoryModel())) {
            q = QueryBuilder.q(TicketIndexer.Lucene.labels.matches(label.name)).build();
            dynamicQueries.add(new TicketsUI.TicketQuery(label.name, q).color(label.color));
        }
        for (QueryResult ticket : results) {
            if (!StringUtils.isEmpty(ticket.topic)) {
                q = QueryBuilder.q(TicketIndexer.Lucene.topic.matches(ticket.topic)).build();
                dynamicQueries.add(new TicketsUI.TicketQuery(ticket.topic, q));
            }
            if (ArrayUtils.isEmpty(ticket.labels)) continue;
            for (String label : ticket.labels) {
                String q4 = QueryBuilder.q(TicketIndexer.Lucene.labels.matches(label)).build();
                dynamicQueries.add(new TicketsUI.TicketQuery(label, q4));
            }
        }
        if (dynamicQueries.size() == 0) {
            this.add(new Component[]{new Label("dynamicQueries").setVisible(false)});
        } else {
            Fragment fragment = new Fragment("dynamicQueries", "dynamicQueriesFragment", (MarkupContainer)this);
            ListDataProvider dynamicQueriesDp = new ListDataProvider(new ArrayList(dynamicQueries));
            DataView<TicketsUI.TicketQuery> dynamicQueriesList = new DataView<TicketsUI.TicketQuery>("dynamicQuery", (IDataProvider)dynamicQueriesDp, (String[])statiiParam, assignedToParam, sortBy, desc, queryParam){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ String[] val$statiiParam;
                final /* synthetic */ String val$assignedToParam;
                final /* synthetic */ String val$sortBy;
                final /* synthetic */ boolean val$desc;
                final /* synthetic */ String val$queryParam;
                {
                    this.val$statiiParam = stringArray;
                    this.val$assignedToParam = string3;
                    this.val$sortBy = string4;
                    this.val$desc = bl;
                    this.val$queryParam = string5;
                    super(x0, x1);
                }

                public void populateItem(Item<TicketsUI.TicketQuery> item) {
                    TicketsUI.TicketQuery tq = (TicketsUI.TicketQuery)item.getModelObject();
                    Component swatch = new Label("swatch", "&nbsp;").setEscapeModelStrings(false);
                    if (StringUtils.isEmpty(tq.color)) {
                        tq.color = StringUtils.getColor(tq.name);
                    }
                    String background = MessageFormat.format("background-color:{0};", tq.color);
                    swatch.add(new IBehavior[]{new SimpleAttributeModifier("style", (CharSequence)background)});
                    item.add(new Component[]{swatch});
                    if (activeQuery.contains(tq.query)) {
                        String q = QueryBuilder.q(activeQuery).remove(tq.query).build();
                        PageParameters params = TicketsPage.this.queryParameters(q, milestoneParam, this.val$statiiParam, this.val$assignedToParam, this.val$sortBy, this.val$desc, 1);
                        item.add(new Component[]{new LinkPanel("link", "active", tq.name, TicketsPage.class, params).setRenderBodyOnly(true)});
                        Label checked = new Label("checked");
                        WicketUtils.setCssClass((Component)checked, "iconic-o-x");
                        item.add(new Component[]{checked});
                        item.add(new IBehavior[]{new SimpleAttributeModifier("style", (CharSequence)background)});
                    } else {
                        String q = QueryBuilder.q(this.val$queryParam).toSubquery().and(tq.query).build();
                        PageParameters params = TicketsPage.this.queryParameters(q, milestoneParam, this.val$statiiParam, this.val$assignedToParam, this.val$sortBy, this.val$desc, 1);
                        item.add(new Component[]{new LinkPanel("link", null, tq.name, TicketsPage.class, params).setRenderBodyOnly(true)});
                        item.add(new Component[]{new Label("checked").setVisible(false)});
                    }
                }
            };
            fragment.add(new Component[]{dynamicQueriesList});
            this.add(new Component[]{fragment});
        }
        if (ArrayUtils.isEmpty(statiiParam)) {
            this.add(new Component[]{new Label("selectedStatii", this.getString("gb.all"))});
        } else {
            this.add(new Component[]{new Label("selectedStatii", StringUtils.flattenStrings(Arrays.asList(statiiParam), ","))});
        }
        this.add(new Component[]{new BookmarkablePageLink("openTickets", TicketsPage.class, this.queryParameters(queryParam, milestoneParam, TicketsUI.openStatii, assignedToParam, sortBy, desc, 1))});
        this.add(new Component[]{new BookmarkablePageLink("closedTickets", TicketsPage.class, this.queryParameters(queryParam, milestoneParam, TicketsUI.closedStatii, assignedToParam, sortBy, desc, 1))});
        this.add(new Component[]{new BookmarkablePageLink("allTickets", TicketsPage.class, this.queryParameters(queryParam, milestoneParam, null, assignedToParam, sortBy, desc, 1))});
        ArrayList<TicketModel.Status> statii = new ArrayList<TicketModel.Status>(Arrays.asList(TicketModel.Status.values()));
        statii.remove((Object)TicketModel.Status.Closed);
        ListDataProvider resolutionsDp = new ListDataProvider(statii);
        DataView<TicketModel.Status> statiiLinks = new DataView<TicketModel.Status>("statii", (IDataProvider)resolutionsDp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<TicketModel.Status> item) {
                TicketModel.Status status = (TicketModel.Status)((Object)item.getModelObject());
                PageParameters p = TicketsPage.this.queryParameters(queryParam, milestoneParam, new String[]{status.name().toLowerCase()}, assignedToParam, sortBy, desc, 1);
                String css = TicketsUI.getStatusClass(status);
                item.add(new Component[]{new LinkPanel("statusLink", css, status.toString(), TicketsPage.class, p).setRenderBodyOnly(true)});
            }
        };
        this.add(new Component[]{statiiLinks});
        ArrayList<TicketResponsible> responsibles = new ArrayList<TicketResponsible>();
        for (RegistrantAccessPermission perm : this.app().repositories().getUserAccessPermissions(this.getRepositoryModel())) {
            if (!perm.permission.atLeast(Constants.AccessPermission.PUSH)) continue;
            UserModel userModel = this.app().users().getUserModel(perm.registrant);
            responsibles.add(new TicketResponsible(userModel));
        }
        Collections.sort(responsibles);
        responsibles.add(0, this.any);
        TicketResponsible currentResponsible = null;
        for (TicketResponsible ticketResponsible : responsibles) {
            if (!ticketResponsible.username.equals(assignedToParam)) continue;
            currentResponsible = ticketResponsible;
            break;
        }
        this.add(new Component[]{new Label("currentResponsible", currentResponsible == null ? "" : currentResponsible.displayname)});
        ListDataProvider responsibleDp = new ListDataProvider(responsibles);
        DataView<TicketResponsible> dataView = new DataView<TicketResponsible>("responsible", (IDataProvider)responsibleDp, (String[])statiiParam, sortBy, desc){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ String[] val$statiiParam;
            final /* synthetic */ String val$sortBy;
            final /* synthetic */ boolean val$desc;
            {
                this.val$statiiParam = stringArray;
                this.val$sortBy = string3;
                this.val$desc = bl;
                super(x0, x1);
            }

            public void populateItem(Item<TicketResponsible> item) {
                TicketResponsible u = (TicketResponsible)item.getModelObject();
                PageParameters params = TicketsPage.this.queryParameters(queryParam, milestoneParam, this.val$statiiParam, u.username, this.val$sortBy, this.val$desc, 1);
                item.add(new Component[]{new LinkPanel("responsibleLink", null, u.displayname, TicketsPage.class, params).setRenderBodyOnly(true)});
            }
        };
        this.add(new Component[]{dataView});
        PageParameters resetResponsibleParams = this.queryParameters(queryParam, milestoneParam, (String[])statiiParam, null, sortBy, desc, 1);
        this.add(new Component[]{new BookmarkablePageLink("resetResponsible", TicketsPage.class, resetResponsibleParams)});
        ArrayList<TicketsUI.TicketSort> sortChoices = new ArrayList<TicketsUI.TicketSort>();
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortNewest"), TicketIndexer.Lucene.created.name(), true));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortOldest"), TicketIndexer.Lucene.created.name(), false));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortMostRecentlyUpdated"), TicketIndexer.Lucene.updated.name(), true));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortLeastRecentlyUpdated"), TicketIndexer.Lucene.updated.name(), false));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortMostComments"), TicketIndexer.Lucene.comments.name(), true));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortLeastComments"), TicketIndexer.Lucene.comments.name(), false));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortMostPatchsetRevisions"), TicketIndexer.Lucene.patchsets.name(), true));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortLeastPatchsetRevisions"), TicketIndexer.Lucene.patchsets.name(), false));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortMostVotes"), TicketIndexer.Lucene.votes.name(), true));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortLeastVotes"), TicketIndexer.Lucene.votes.name(), false));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortHighestPriority"), TicketIndexer.Lucene.priority.name(), true));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortLowestPriority"), TicketIndexer.Lucene.priority.name(), false));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortHighestSeverity"), TicketIndexer.Lucene.severity.name(), true));
        sortChoices.add(new TicketsUI.TicketSort(this.getString("gb.sortLowestSeverity"), TicketIndexer.Lucene.severity.name(), false));
        TicketsUI.TicketSort currentSort = (TicketsUI.TicketSort)sortChoices.get(0);
        for (TicketsUI.TicketSort ts : sortChoices) {
            if (!ts.sortBy.equals(sortBy) || desc != ts.desc) continue;
            currentSort = ts;
            break;
        }
        this.add(new Component[]{new Label("currentSort", currentSort.name)});
        ListDataProvider sortChoicesDp = new ListDataProvider(sortChoices);
        DataView<TicketsUI.TicketSort> sortMenu = new DataView<TicketsUI.TicketSort>("sort", (IDataProvider)sortChoicesDp, (String[])statiiParam, assignedToParam){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ String[] val$statiiParam;
            final /* synthetic */ String val$assignedToParam;
            {
                this.val$statiiParam = stringArray;
                this.val$assignedToParam = string3;
                super(x0, x1);
            }

            public void populateItem(Item<TicketsUI.TicketSort> item) {
                TicketsUI.TicketSort ts = (TicketsUI.TicketSort)item.getModelObject();
                PageParameters params = TicketsPage.this.queryParameters(queryParam, milestoneParam, this.val$statiiParam, this.val$assignedToParam, ts.sortBy, ts.desc, 1);
                item.add(new Component[]{new LinkPanel("sortLink", null, ts.name, TicketsPage.class, params).setRenderBodyOnly(true)});
            }
        };
        this.add(new Component[]{sortMenu});
        this.buildPager(queryParam, milestoneParam, (String[])statiiParam, assignedToParam, sortBy, desc, page, pageSize, results.size(), totalResults);
        this.add(new Component[]{new TicketListPanel("ticketList", results, false, false)});
        RepositoryModel repositoryModel = this.getRepositoryModel();
        boolean bl = acceptingUpdates = this.app().tickets().isAcceptingTicketUpdates(repositoryModel) && user != null && user.canAdmin(this.getRepositoryModel());
        if (acceptingUpdates) {
            this.add(new Component[]{new LinkPanel("newMilestone", null, this.getString("gb.newMilestone"), NewMilestonePage.class, WicketUtils.newRepositoryParameter(this.repositoryName))});
        } else {
            this.add(new Component[]{new Label("newMilestone").setVisible(false)});
        }
        ArrayList<TicketMilestone> openMilestones = new ArrayList<TicketMilestone>();
        ArrayList<TicketMilestone> closedMilestones = new ArrayList<TicketMilestone>();
        for (TicketMilestone milestone : this.app().tickets().getMilestones(repositoryModel)) {
            if (milestone.isOpen()) {
                openMilestones.add(milestone);
                continue;
            }
            closedMilestones.add(milestone);
        }
        Collections.sort(openMilestones, new Comparator<TicketMilestone>(){

            @Override
            public int compare(TicketMilestone o1, TicketMilestone o2) {
                if (o1.due == null) {
                    return o2.due == null ? 0 : 1;
                }
                if (o2.due == null) {
                    return -1;
                }
                return o1.due.compareTo(o2.due);
            }
        });
        Collections.sort(closedMilestones, new Comparator<TicketMilestone>(){

            @Override
            public int compare(TicketMilestone o1, TicketMilestone o2) {
                if (o1.due == null) {
                    return o2.due == null ? 0 : 1;
                }
                if (o2.due == null) {
                    return -1;
                }
                return o1.due.compareTo(o2.due);
            }
        });
        DataView<TicketMilestone> openMilestonesList = this.milestoneList("openMilestonesList", openMilestones, acceptingUpdates);
        this.add(new Component[]{openMilestonesList});
        DataView<TicketMilestone> closedMilestonesList = this.milestoneList("closedMilestonesList", closedMilestones, acceptingUpdates);
        this.add(new Component[]{closedMilestonesList});
    }

    protected DataView<TicketMilestone> milestoneList(String wicketId, List<TicketMilestone> milestones, final boolean acceptingUpdates) {
        ListDataProvider milestonesDp = new ListDataProvider(milestones);
        DataView<TicketMilestone> milestonesList = new DataView<TicketMilestone>(wicketId, (IDataProvider)milestonesDp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<TicketMilestone> item) {
                String css;
                Fragment entryPanel = new Fragment("entryPanel", "milestoneListFragment", (MarkupContainer)this);
                item.add(new Component[]{entryPanel});
                TicketMilestone tm = (TicketMilestone)item.getModelObject();
                String[] states = tm.isOpen() ? TicketsUI.openStatii : TicketsUI.closedStatii;
                PageParameters params = TicketsPage.this.queryParameters(null, tm.name, states, null, null, true, 1);
                entryPanel.add(new Component[]{new LinkPanel("milestoneName", null, tm.name, TicketsPage.class, params).setRenderBodyOnly(true)});
                String status = tm.status.name();
                switch (tm.status) {
                    case Open: {
                        if (tm.isOverdue()) {
                            css = "aui-lozenge aui-lozenge-subtle aui-lozenge-error";
                            status = "overdue";
                            break;
                        }
                        css = "aui-lozenge aui-lozenge-subtle";
                        break;
                    }
                    default: {
                        css = "aui-lozenge";
                    }
                }
                Label stateLabel = new Label("milestoneState", status);
                WicketUtils.setCssClass((Component)stateLabel, css);
                entryPanel.add(new Component[]{stateLabel});
                if (tm.due == null) {
                    entryPanel.add(new Component[]{new Label("milestoneDue", this.getString("gb.notSpecified"))});
                } else {
                    entryPanel.add(new Component[]{WicketUtils.createDatestampLabel("milestoneDue", tm.due, TicketsPage.this.getTimeZone(), TicketsPage.this.getTimeUtils())});
                }
                if (acceptingUpdates) {
                    entryPanel.add(new Component[]{new LinkPanel("editMilestone", null, this.getString("gb.edit"), EditMilestonePage.class, WicketUtils.newObjectParameter(TicketsPage.this.repositoryName, tm.name))});
                } else {
                    entryPanel.add(new Component[]{new Label("editMilestone").setVisible(false)});
                }
                if (tm.isOpen()) {
                    TicketMilestone m = TicketsPage.this.app().tickets().getMilestone(TicketsPage.this.getRepositoryModel(), tm.name);
                    Fragment milestonePanel = new Fragment("milestonePanel", "openMilestoneFragment", (MarkupContainer)this);
                    Label label = new Label("progress");
                    WicketUtils.setCssStyle((Component)label, "width:" + m.getProgress() + "%;");
                    milestonePanel.add(new Component[]{label});
                    milestonePanel.add(new Component[]{new LinkPanel("openTickets", null, MessageFormat.format(this.getString("gb.nOpenTickets"), m.getOpenTickets()), TicketsPage.class, TicketsPage.this.queryParameters(null, tm.name, TicketsUI.openStatii, null, null, true, 1))});
                    milestonePanel.add(new Component[]{new LinkPanel("closedTickets", null, MessageFormat.format(this.getString("gb.nClosedTickets"), m.getClosedTickets()), TicketsPage.class, TicketsPage.this.queryParameters(null, tm.name, TicketsUI.closedStatii, null, null, true, 1))});
                    milestonePanel.add(new Component[]{new Label("totalTickets", MessageFormat.format(this.getString("gb.nTotalTickets"), m.getTotalTickets()))});
                    entryPanel.add(new Component[]{milestonePanel});
                } else {
                    entryPanel.add(new Component[]{new Label("milestonePanel").setVisible(false)});
                }
            }
        };
        return milestonesList;
    }

    protected PageParameters queryParameters(String query, String milestone, String[] states, String assignedTo, String sort, boolean descending, int page) {
        PageParameters params = WicketUtils.newRepositoryParameter(this.repositoryName);
        if (!StringUtils.isEmpty(query)) {
            params.add("q", query);
        }
        if (!StringUtils.isEmpty(milestone)) {
            params.add(TicketIndexer.Lucene.milestone.name(), milestone);
        }
        if (!ArrayUtils.isEmpty(states)) {
            for (String state : states) {
                params.add(TicketIndexer.Lucene.status.name(), state);
            }
        }
        if (!StringUtils.isEmpty(assignedTo)) {
            params.add(TicketIndexer.Lucene.responsible.name(), assignedTo);
        }
        if (!StringUtils.isEmpty(sort)) {
            params.add("sort", sort);
        }
        if (!descending) {
            params.add("direction", "asc");
        }
        if (page > 1) {
            params.add("pg", "" + page);
        }
        return params;
    }

    protected PageParameters newTicketParameter(QueryResult ticket) {
        return WicketUtils.newObjectParameter(this.repositoryName, "" + ticket.number);
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.tickets");
    }

    protected void buildPager(final String query, final String milestone, final String[] states, final String assignedTo, final String sort, final boolean desc, final int page, int pageSize, int count, int total) {
        int segments;
        boolean showNav = total > 2 * pageSize;
        boolean allowPrev = page > 1;
        boolean allowNext = pageSize * (page - 1) + count < total;
        this.add(new Component[]{new BookmarkablePageLink("prevLink", TicketsPage.class, this.queryParameters(query, milestone, states, assignedTo, sort, desc, page - 1)).setEnabled(allowPrev).setVisible(showNav)});
        this.add(new Component[]{new BookmarkablePageLink("nextLink", TicketsPage.class, this.queryParameters(query, milestone, states, assignedTo, sort, desc, page + 1)).setEnabled(allowNext).setVisible(showNav)});
        if (total <= pageSize) {
            this.add(new Component[]{new Label("pageLink").setVisible(false)});
            return;
        }
        int pages = count == 0 ? 0 : total / pageSize + (total % pageSize == 0 ? 0 : 1);
        if (pages < (segments = 5)) {
            segments = pages;
        }
        int minpage = Math.min(Math.max(1, page - 2), pages - (segments - 1));
        int maxpage = Math.min(pages, minpage + (segments - 1));
        ArrayList<Integer> sequence = new ArrayList<Integer>();
        for (int i = minpage; i <= maxpage; ++i) {
            sequence.add(i);
        }
        ListDataProvider pagesDp = new ListDataProvider(sequence);
        DataView<Integer> pagesView = new DataView<Integer>("pageLink", (IDataProvider)pagesDp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<Integer> item) {
                Integer i = (Integer)item.getModelObject();
                LinkPanel link = new LinkPanel("page", null, "" + i, TicketsPage.class, TicketsPage.this.queryParameters(query, milestone, states, assignedTo, sort, desc, i));
                link.setRenderBodyOnly(true);
                if (i == page) {
                    WicketUtils.setCssClass(item, "active");
                }
                item.add(new Component[]{link});
            }
        };
        this.add(new Component[]{pagesView});
    }
}

