/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.Constants;
import com.gitblit.models.Activity;
import com.gitblit.models.RepositoryCommit;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.CommitDiffPage;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.GitSearchPage;
import com.gitblit.wicket.pages.LogPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.panels.AvatarImage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.RefsPanel;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.eclipse.jgit.lib.Repository;

public class ActivityPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;

    public ActivityPanel(String wicketId, List<Activity> recentActivity) {
        super(wicketId);
        Collections.sort(recentActivity);
        final int shortHashLen = this.app().settings().getInteger("web.shortCommitIdLength", 6);
        DataView<Activity> activityView = new DataView<Activity>("activity", (IDataProvider)new ListDataProvider(recentActivity)){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<Activity> activityItem) {
                Activity entry = (Activity)activityItem.getModelObject();
                activityItem.add(new Component[]{WicketUtils.createDatestampLabel("title", entry.startDate, ActivityPanel.this.getTimeZone(), ActivityPanel.this.getTimeUtils())});
                DataView<RepositoryCommit> commits = new DataView<RepositoryCommit>("commit", (IDataProvider)new ListDataProvider(entry.getCommits())){
                    private static final long serialVersionUID = 1L;

                    public void populateItem(Item<RepositoryCommit> commitItem) {
                        String shortMessage;
                        RepositoryCommit commit = (RepositoryCommit)commitItem.getModelObject();
                        commitItem.add(new Component[]{WicketUtils.createTimeLabel("time", commit.getCommitterIdent().getWhen(), ActivityPanel.this.getTimeZone(), ActivityPanel.this.getTimeUtils())});
                        commitItem.add(new Component[]{new AvatarImage("avatar", commit.getAuthorIdent(), 40)});
                        if (commit.getParentCount() > 1) {
                            commitItem.add(new Component[]{WicketUtils.newImage("commitIcon", "commit_merge_16x16.png")});
                        } else {
                            commitItem.add(new Component[]{WicketUtils.newBlankImage("commitIcon").setVisible(false)});
                        }
                        String author = commit.getAuthorIdent().getName();
                        LinkPanel authorLink = new LinkPanel("author", "list", author, GitSearchPage.class, WicketUtils.newSearchParameter(commit.repository, null, author, Constants.SearchType.AUTHOR), true);
                        ActivityPanel.this.setPersonSearchTooltip((Component)authorLink, author, Constants.SearchType.AUTHOR);
                        commitItem.add(new Component[]{authorLink});
                        String repoName = StringUtils.stripDotGit(commit.repository);
                        LinkPanel repositoryLink = new LinkPanel("repository", null, repoName, SummaryPage.class, WicketUtils.newRepositoryParameter(commit.repository), true);
                        WicketUtils.setCssBackground((Component)repositoryLink, repoName);
                        commitItem.add(new Component[]{repositoryLink});
                        LinkPanel branchLink = new LinkPanel("branch", "list", Repository.shortenRefName((String)commit.branch), LogPage.class, WicketUtils.newObjectParameter(commit.repository, commit.branch), true);
                        WicketUtils.setCssStyle((Component)branchLink, "color: #008000;");
                        commitItem.add(new Component[]{branchLink});
                        LinkPanel commitid = new LinkPanel("commitid", "list subject", commit.getName().substring(0, shortHashLen), CommitPage.class, WicketUtils.newObjectParameter(commit.repository, commit.getName()), true);
                        commitItem.add(new Component[]{commitid});
                        String trimmedMessage = shortMessage = commit.getShortMessage();
                        trimmedMessage = commit.getRefs() != null && commit.getRefs().size() > 0 ? StringUtils.trimString(shortMessage, 60) : StringUtils.trimString(shortMessage, 78);
                        LinkPanel shortlog = new LinkPanel("message", "list subject", trimmedMessage, CommitPage.class, WicketUtils.newObjectParameter(commit.repository, commit.getName()), true);
                        if (!shortMessage.equals(trimmedMessage)) {
                            WicketUtils.setHtmlTooltip((Component)shortlog, shortMessage);
                        }
                        commitItem.add(new Component[]{shortlog});
                        commitItem.add(new Component[]{new RefsPanel("commitRefs", commit.repository, commit.getRefs())});
                        commitItem.add(new Component[]{new BookmarkablePageLink("diff", CommitDiffPage.class, WicketUtils.newObjectParameter(commit.repository, commit.getName())).setEnabled(commit.getParentCount() > 0)});
                        commitItem.add(new Component[]{new BookmarkablePageLink("tree", TreePage.class, WicketUtils.newObjectParameter(commit.repository, commit.getName()))});
                    }
                };
                activityItem.add(new Component[]{commits});
            }
        };
        this.add(new Component[]{activityView});
    }
}

