/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.Constants;
import com.gitblit.models.RefModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.servlet.RawServlet;
import com.gitblit.servlet.SyndicationServlet;
import com.gitblit.utils.CommitCache;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.RefLogUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BranchesPage;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.GitSearchPage;
import com.gitblit.wicket.pages.LogPage;
import com.gitblit.wicket.pages.MetricsPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.LinkPanel;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.request.target.basic.RedirectRequestTarget;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class BranchesPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private final boolean hasBranches;

    public BranchesPanel(String wicketId, final RepositoryModel model, Repository r, final int maxCount, boolean showAdmin) {
        super(wicketId);
        ArrayList<RefModel> branches = new ArrayList<RefModel>();
        UserModel user = GitBlitWebSession.get().getUser();
        if (user == null) {
            user = UserModel.ANONYMOUS;
        }
        List<RefModel> localBranches = JGitUtils.getLocalBranches(r, false, -1);
        for (RefModel refModel : localBranches) {
            if (!user.canView(model, refModel.reference.getName())) continue;
            branches.add(refModel);
        }
        if (model.showRemoteBranches) {
            List<RefModel> remoteBranches = JGitUtils.getRemoteBranches(r, false, -1);
            for (RefModel refModel : remoteBranches) {
                if (!user.canView(model, refModel.reference.getName())) continue;
                branches.add(refModel);
            }
        }
        Collections.sort(branches);
        Collections.reverse(branches);
        if (maxCount > 0 && branches.size() > maxCount) {
            branches = new ArrayList(branches.subList(0, maxCount));
        }
        if (maxCount > 0) {
            this.add(new Component[]{new LinkPanel("branches", "title", (IModel<String>)new StringResourceModel("gb.branches", (Component)this, null), BranchesPage.class, WicketUtils.newRepositoryParameter(model.name))});
        } else {
            this.add(new Component[]{new Label("branches", (IModel)new StringResourceModel("gb.branches", (Component)this, null))});
        }
        final boolean showDelete = showAdmin && branches.size() > 1;
        ListDataProvider branchesDp = new ListDataProvider(branches);
        DataView<RefModel> branchesView = new DataView<RefModel>("branch", (IDataProvider)branchesDp){
            private static final long serialVersionUID = 1L;
            int counter;

            public void populateItem(Item<RefModel> item) {
                RefModel entry = (RefModel)item.getModelObject();
                PageParameters shortUniqRef = WicketUtils.newObjectParameter(model.name, Repository.shortenRefName((String)entry.getName()));
                item.add(new Component[]{WicketUtils.createDateLabel("branchDate", entry.getDate(), BranchesPanel.this.getTimeZone(), BranchesPanel.this.getTimeUtils())});
                item.add(new Component[]{new LinkPanel("branchName", "list name", StringUtils.trimString(entry.displayName, 28), LogPage.class, shortUniqRef)});
                String author = entry.getAuthorIdent().getName();
                LinkPanel authorLink = new LinkPanel("branchAuthor", "list", author, GitSearchPage.class, WicketUtils.newSearchParameter(model.name, entry.getName(), author, Constants.SearchType.AUTHOR));
                BranchesPanel.this.setPersonSearchTooltip((Component)authorLink, author, Constants.SearchType.AUTHOR);
                item.add(new Component[]{authorLink});
                String shortMessage = entry.getShortMessage();
                String trimmedMessage = StringUtils.trimString(shortMessage, 78);
                LinkPanel shortlog = new LinkPanel("branchLog", "list subject", trimmedMessage, CommitPage.class, shortUniqRef);
                if (!shortMessage.equals(trimmedMessage)) {
                    shortlog.setTooltip(shortMessage);
                }
                item.add(new Component[]{shortlog});
                if (maxCount <= 0) {
                    Fragment fragment = new Fragment("branchLinks", showDelete ? "branchPageAdminLinks" : "branchPageLinks", (MarkupContainer)this);
                    fragment.add(new Component[]{new BookmarkablePageLink("log", LogPage.class, shortUniqRef)});
                    fragment.add(new Component[]{new BookmarkablePageLink("tree", TreePage.class, shortUniqRef)});
                    String rawUrl = RawServlet.asLink(BranchesPanel.this.getContextUrl(), model.name, Repository.shortenRefName((String)entry.getName()), null);
                    fragment.add(new Component[]{new ExternalLink("raw", rawUrl)});
                    fragment.add(new Component[]{new BookmarkablePageLink("metrics", MetricsPage.class, shortUniqRef)});
                    fragment.add(new Component[]{new ExternalLink("syndication", SyndicationServlet.asLink(this.getRequest().getRelativePathPrefixToContextRoot(), model.name, Repository.shortenRefName((String)entry.getName()), 0))});
                    if (showDelete) {
                        fragment.add(new Component[]{BranchesPanel.this.createDeleteBranchLink(model, entry)});
                    }
                    item.add(new Component[]{fragment});
                } else {
                    Fragment fragment = new Fragment("branchLinks", "branchPanelLinks", (MarkupContainer)this);
                    fragment.add(new Component[]{new BookmarkablePageLink("log", LogPage.class, shortUniqRef)});
                    fragment.add(new Component[]{new BookmarkablePageLink("tree", TreePage.class, shortUniqRef)});
                    String rawUrl = RawServlet.asLink(BranchesPanel.this.getContextUrl(), model.name, Repository.shortenRefName((String)entry.getName()), null);
                    fragment.add(new Component[]{new ExternalLink("raw", rawUrl)});
                    item.add(new Component[]{fragment});
                }
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{branchesView});
        if (branches.size() < maxCount || maxCount <= 0) {
            this.add(new Component[]{new Label("allBranches", "").setVisible(false)});
        } else {
            this.add(new Component[]{new LinkPanel("allBranches", "link", (IModel<String>)new StringResourceModel("gb.allBranches", (Component)this, null), BranchesPage.class, WicketUtils.newRepositoryParameter(model.name))});
        }
        this.hasBranches = branches.size() > 1 || branches.size() == 1 && !((RefModel)branches.get((int)0)).displayName.equalsIgnoreCase("master");
    }

    public BranchesPanel hideIfEmpty() {
        this.setVisible(this.hasBranches);
        return this;
    }

    private Link<Void> createDeleteBranchLink(final RepositoryModel repositoryModel, final RefModel entry) {
        Link<Void> deleteLink = new Link<Void>("deleteBranch"){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                Repository r = BranchesPanel.this.app().repositories().getRepository(repositoryModel.name);
                if (r == null) {
                    if (BranchesPanel.this.app().repositories().isCollectingGarbage(repositoryModel.name)) {
                        this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.busyCollectingGarbage"), repositoryModel.name)));
                    } else {
                        this.error((Serializable)((Object)MessageFormat.format("Failed to find repository {0}", repositoryModel.name)));
                    }
                    return;
                }
                String branch = entry.getName();
                Ref ref = null;
                try {
                    ref = r.getRef(branch);
                    if (ref == null && !branch.startsWith("refs/heads/")) {
                        ref = r.getRef("refs/heads/" + branch);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (ref != null) {
                    boolean success = JGitUtils.deleteBranchRef(r, ref.getName());
                    if (success) {
                        CommitCache.instance().clear(repositoryModel.name, branch);
                        if (RefLogUtils.hasRefLogBranch(r)) {
                            UserModel user = GitBlitWebSession.get().getUser();
                            RefLogUtils.deleteRef(user, r, ref);
                        }
                    }
                    if (success) {
                        this.info(MessageFormat.format("Branch \"{0}\" deleted", branch));
                    } else {
                        this.error((Serializable)((Object)MessageFormat.format("Failed to delete branch \"{0}\"", branch)));
                    }
                }
                r.close();
                PageParameters params = WicketUtils.newRepositoryParameter(repositoryModel.name);
                String relativeUrl = this.urlFor(this.getPage().getClass(), params).toString();
                String absoluteUrl = RequestUtils.toAbsolutePath((String)relativeUrl);
                this.getRequestCycle().setRequestTarget((IRequestTarget)new RedirectRequestTarget(absoluteUrl));
            }
        };
        deleteLink.add(new IBehavior[]{new BasePanel.JavascriptEventConfirmation("onclick", MessageFormat.format("Delete branch \"{0}\"?", entry.displayName))});
        return deleteLink;
    }
}

