/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TicketModel;
import com.gitblit.models.UserModel;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.MarkdownTextArea;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.request.target.basic.RedirectRequestTarget;

public class CommentPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    final UserModel user;
    final TicketModel ticket;
    final TicketModel.Change change;
    final Class<? extends BasePage> pageClass;
    private MarkdownTextArea markdownEditor;
    private Label markdownPreview;
    private String repositoryName;

    public CommentPanel(String id, UserModel user, TicketModel ticket, TicketModel.Change change, Class<? extends BasePage> pageClass) {
        super(id);
        this.user = user;
        this.ticket = ticket;
        this.change = change;
        this.pageClass = pageClass;
    }

    protected void onInitialize() {
        super.onInitialize();
        Form form = new Form("editorForm");
        this.add(new Component[]{form});
        form.add(new Component[]{new AjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("gb.comment"))), form){
            private static final long serialVersionUID = 1L;

            public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                String txt = CommentPanel.this.markdownEditor.getText();
                if (CommentPanel.this.change == null) {
                    TicketModel.Change newComment = new TicketModel.Change(CommentPanel.this.user.username);
                    newComment.comment(txt);
                    if (!CommentPanel.this.ticket.isWatching(CommentPanel.this.user.username)) {
                        newComment.watch(CommentPanel.this.user.username);
                    }
                    RepositoryModel repository = CommentPanel.this.app().repositories().getRepositoryModel(CommentPanel.this.ticket.repository);
                    TicketModel updatedTicket = CommentPanel.this.app().tickets().updateTicket(repository, CommentPanel.this.ticket.number, newComment);
                    if (updatedTicket != null) {
                        CommentPanel.this.app().tickets().createNotifier().sendMailing(updatedTicket);
                        this.redirectTo(CommentPanel.this.pageClass, WicketUtils.newObjectParameter(updatedTicket.repository, "" + CommentPanel.this.ticket.number));
                    } else {
                        this.error((Serializable)((Object)"Failed to add comment!"));
                    }
                }
            }

            private void redirectTo(Class<? extends BasePage> pageClass, PageParameters parameters) {
                String relativeUrl = this.urlFor(pageClass, parameters).toString();
                String canonicalUrl = RequestUtils.toAbsolutePath((String)relativeUrl);
                this.getRequestCycle().setRequestTarget((IRequestTarget)new RedirectRequestTarget(canonicalUrl));
            }
        }.setVisible(this.ticket != null && this.ticket.number > 0L)});
        Model markdownPreviewModel = Model.of();
        this.markdownPreview = new Label("markdownPreview", (IModel)markdownPreviewModel);
        this.markdownPreview.setEscapeModelStrings(false);
        this.markdownPreview.setOutputMarkupId(true);
        this.add(new Component[]{this.markdownPreview});
        this.markdownEditor = new MarkdownTextArea("markdownEditor", (IModel<String>)markdownPreviewModel, this.markdownPreview);
        this.markdownEditor.setRepository(this.repositoryName);
        WicketUtils.setInputPlaceholder((Component)this.markdownEditor, this.getString("gb.leaveComment"));
        this.add(new Component[]{this.markdownEditor});
    }

    public void setRepository(String repositoryName) {
        this.repositoryName = repositoryName;
        if (this.markdownEditor != null) {
            this.markdownEditor.setRepository(repositoryName);
        }
    }
}

