/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.models.DailyLogEntry;
import com.gitblit.models.RepositoryCommit;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.TimeUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.ComparePage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.pages.TagPage;
import com.gitblit.wicket.pages.TicketsPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.panels.AvatarImage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.LinkPanel;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.eclipse.jgit.lib.PersonIdent;

public class DigestsPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private final boolean hasChanges;
    private boolean hasMore;

    public DigestsPanel(String wicketId, List<DailyLogEntry> digests) {
        super(wicketId);
        this.hasChanges = digests.size() > 0;
        ListDataProvider dp = new ListDataProvider(digests);
        DataView<DailyLogEntry> pushView = new DataView<DailyLogEntry>("change", (IDataProvider)dp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<DailyLogEntry> logItem) {
                String what;
                String fullRefName;
                final DailyLogEntry change = (DailyLogEntry)logItem.getModelObject();
                String dateFormat = DigestsPanel.this.app().settings().getString("web.datestampLongFormat", "EEEE, MMMM d, yyyy");
                TimeZone timezone = DigestsPanel.this.getTimeZone();
                SimpleDateFormat df = new SimpleDateFormat(dateFormat);
                df.setTimeZone(timezone);
                String shortRefName = fullRefName = change.getChangedRefs().get(0);
                String ticketId = "";
                boolean isTag = false;
                boolean isTicket = false;
                if (shortRefName.startsWith("refs/heads/ticket/")) {
                    ticketId = shortRefName = shortRefName.substring("refs/heads/ticket/".length());
                    shortRefName = MessageFormat.format(this.getString("gb.ticketN"), ticketId);
                    isTicket = true;
                } else if (shortRefName.startsWith("refs/heads/")) {
                    shortRefName = shortRefName.substring("refs/heads/".length());
                } else if (shortRefName.startsWith("refs/tags/")) {
                    shortRefName = shortRefName.substring("refs/tags/".length());
                    isTag = true;
                }
                TimeUtils tu = DigestsPanel.this.getTimeUtils();
                Date pushDate = change.date;
                String fuzzydate = TimeUtils.isToday(pushDate, timezone) ? tu.today() : (TimeUtils.isYesterday(pushDate, timezone) ? tu.yesterday() : DigestsPanel.this.getTimeUtils().timeAgo(pushDate));
                logItem.add(new Component[]{new Label("whenChanged", fuzzydate + ", " + df.format(pushDate))});
                Label changeIcon = new Label("changeIcon");
                String color = StringUtils.getColor(StringUtils.stripDotGit(change.repository));
                WicketUtils.setCssStyle((Component)changeIcon, "color: " + color);
                if (isTag) {
                    WicketUtils.setCssClass((Component)changeIcon, "iconic-tag");
                } else if (isTicket) {
                    WicketUtils.setCssClass((Component)changeIcon, "fa fa-ticket");
                } else {
                    WicketUtils.setCssClass((Component)changeIcon, "iconic-loop");
                }
                logItem.add(new Component[]{changeIcon});
                if (isTag) {
                    PersonIdent ident = change.getCommits().get(0).getAuthorIdent();
                    if (!StringUtils.isEmpty(ident.getName())) {
                        logItem.add(new Component[]{new Label("whoChanged", ident.getName())});
                    } else {
                        logItem.add(new Component[]{new Label("whoChanged", ident.getEmailAddress())});
                    }
                } else {
                    logItem.add(new Component[]{new Label("whoChanged").setVisible(false)});
                }
                String preposition = "gb.of";
                boolean isDelete = false;
                String by = null;
                switch (change.getChangeType(fullRefName)) {
                    case CREATE: {
                        if (isTag) {
                            what = this.getString("gb.createdNewTag");
                            preposition = "gb.in";
                            break;
                        }
                        what = this.getString("gb.createdNewBranch");
                        preposition = "gb.in";
                        break;
                    }
                    case DELETE: {
                        isDelete = true;
                        what = isTag ? this.getString("gb.deletedTag") : this.getString("gb.deletedBranch");
                        preposition = "gb.from";
                        break;
                    }
                    default: {
                        what = MessageFormat.format(change.getCommitCount() > 1 ? this.getString("gb.commitsTo") : this.getString("gb.oneCommitTo"), change.getCommitCount());
                        by = change.getAuthorCount() == 1 ? MessageFormat.format(this.getString("gb.byOneAuthor"), change.getAuthorIdent().getName()) : MessageFormat.format(this.getString("gb.byNAuthors"), change.getAuthorCount());
                    }
                }
                logItem.add(new Component[]{new Label("whatChanged", what)});
                logItem.add(new Component[]{new Label("byAuthors", by).setVisible(!StringUtils.isEmpty(by))});
                if (isDelete) {
                    logItem.add(new Component[]{new Label("refChanged", shortRefName)});
                } else if (isTag) {
                    logItem.add(new Component[]{new LinkPanel("refChanged", null, shortRefName, TagPage.class, WicketUtils.newObjectParameter(change.repository, shortRefName))});
                } else if (isTicket) {
                    logItem.add(new Component[]{new LinkPanel("refChanged", null, shortRefName, TicketsPage.class, WicketUtils.newObjectParameter(change.repository, ticketId))});
                } else {
                    logItem.add(new Component[]{new LinkPanel("refChanged", null, shortRefName, TreePage.class, WicketUtils.newObjectParameter(change.repository, shortRefName))});
                }
                logItem.add(new Component[]{new Label("repoPreposition", this.getString(preposition))});
                String repoName = StringUtils.stripDotGit(change.repository);
                logItem.add(new Component[]{new LinkPanel("repoChanged", null, repoName, SummaryPage.class, WicketUtils.newRepositoryParameter(change.repository))});
                int maxCommitCount = 5;
                List<RepositoryCommit> commits = change.getCommits();
                if (commits.size() > maxCommitCount) {
                    commits = new ArrayList<RepositoryCommit>(commits.subList(0, maxCommitCount));
                }
                String compareLinkText = null;
                if (change.getCommitCount() <= maxCommitCount && change.getCommitCount() > 1) {
                    compareLinkText = MessageFormat.format(this.getString("gb.viewComparison"), commits.size());
                } else if (change.getCommitCount() > maxCommitCount) {
                    int diff = change.getCommitCount() - maxCommitCount;
                    compareLinkText = MessageFormat.format(diff > 1 ? this.getString("gb.nMoreCommits") : this.getString("gb.oneMoreCommit"), diff);
                }
                if (StringUtils.isEmpty(compareLinkText)) {
                    logItem.add(new Component[]{new Label("compareLink").setVisible(false)});
                } else {
                    String endRangeId = change.getNewId(fullRefName);
                    String startRangeId = change.getOldId(fullRefName);
                    logItem.add(new Component[]{new LinkPanel("compareLink", null, compareLinkText, ComparePage.class, WicketUtils.newRangeParameter(change.repository, startRangeId, endRangeId))});
                }
                final boolean showSwatch = DigestsPanel.this.app().settings().getBoolean("web.repositoryListSwatches", true);
                ListDataProvider cdp = new ListDataProvider(commits);
                DataView<RepositoryCommit> commitsView = new DataView<RepositoryCommit>("commit", (IDataProvider)cdp){
                    private static final long serialVersionUID = 1L;

                    public void populateItem(Item<RepositoryCommit> commitItem) {
                        String shortMessage;
                        RepositoryCommit commit = (RepositoryCommit)commitItem.getModelObject();
                        commitItem.add(new Component[]{new AvatarImage("commitAuthor", commit.getAuthorIdent(), null, 16, false)});
                        if (commit.getParentCount() > 1) {
                            commitItem.add(new Component[]{WicketUtils.newImage("commitIcon", "commit_merge_16x16.png")});
                        } else {
                            commitItem.add(new Component[]{WicketUtils.newBlankImage("commitIcon")});
                        }
                        String trimmedMessage = shortMessage = commit.getShortMessage();
                        trimmedMessage = commit.getRefs() != null && commit.getRefs().size() > 0 ? StringUtils.trimString(shortMessage, 60) : StringUtils.trimString(shortMessage, 78);
                        LinkPanel shortlog = new LinkPanel("commitShortMessage", "list", trimmedMessage, CommitPage.class, WicketUtils.newObjectParameter(change.repository, commit.getName()));
                        if (!shortMessage.equals(trimmedMessage)) {
                            WicketUtils.setHtmlTooltip((Component)shortlog, shortMessage);
                        }
                        commitItem.add(new Component[]{shortlog});
                        int hashLen = DigestsPanel.this.app().settings().getInteger("web.shortCommitIdLength", 6);
                        LinkPanel commitHash = new LinkPanel("hashLink", null, commit.getName().substring(0, hashLen), CommitPage.class, WicketUtils.newObjectParameter(change.repository, commit.getName()));
                        WicketUtils.setCssClass((Component)commitHash, "shortsha1");
                        WicketUtils.setHtmlTooltip((Component)commitHash, commit.getName());
                        commitItem.add(new Component[]{commitHash});
                        if (showSwatch) {
                            String color = StringUtils.getColor(StringUtils.stripDotGit(change.repository));
                            WicketUtils.setCssStyle(commitItem, MessageFormat.format("border-left: 2px solid {0};", color));
                        }
                    }
                };
                logItem.add(new Component[]{commitsView});
            }
        };
        this.add(new Component[]{pushView});
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public boolean hideIfEmpty() {
        this.setVisible(this.hasChanges);
        return this.hasChanges;
    }
}

