/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.models.Menu;
import com.gitblit.models.NavLink;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.panels.LinkPanel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;

public class DropDownMenu
extends Panel {
    private static final long serialVersionUID = 1L;

    public DropDownMenu(String id, String label, final NavLink.DropDownPageMenuNavLink menu) {
        super(id);
        this.add(new Component[]{new Label("label", label).setRenderBodyOnly(true)});
        ListDataProvider items = new ListDataProvider(menu.menuItems);
        DataView<Menu.MenuItem> view = new DataView<Menu.MenuItem>("menuItems", (IDataProvider)items){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<Menu.MenuItem> item) {
                Menu.MenuItem entry = (Menu.MenuItem)item.getModelObject();
                if (entry instanceof Menu.PageLinkMenuItem) {
                    Menu.PageLinkMenuItem pageLink = (Menu.PageLinkMenuItem)entry;
                    item.add(new Component[]{new LinkPanel("menuItem", null, null, pageLink.toString(), pageLink.getPageClass(), pageLink.getPageParameters(), false).setRenderBodyOnly(true)});
                } else if (entry instanceof Menu.ExternalLinkMenuItem) {
                    Menu.ExternalLinkMenuItem extLink = (Menu.ExternalLinkMenuItem)entry;
                    item.add(new Component[]{new LinkPanel("menuItem", null, extLink.toString(), extLink.getHref(), extLink.openInNewWindow()).setRenderBodyOnly(true)});
                } else if (entry instanceof Menu.MenuDivider) {
                    item.add(new Component[]{new Label("menuItem").setRenderBodyOnly(true)});
                    WicketUtils.setCssClass(item, "divider");
                } else {
                    Menu.ParameterMenuItem parameter = (Menu.ParameterMenuItem)entry;
                    String icon = null;
                    icon = parameter.isSelected() ? "icon-ok" : "icon-ok-white";
                    item.add(new Component[]{new LinkPanel("menuItem", icon, null, entry.toString(), (Class<? extends WebPage>)menu.pageClass, parameter.getPageParameters(), false).setRenderBodyOnly(true)});
                }
            }
        };
        this.add(new Component[]{view});
        this.setRenderBodyOnly(true);
    }

    public DropDownMenu(String id, String label, NavLink.DropDownMenuNavLink menu) {
        super(id);
        this.add(new Component[]{new Label("label", label).setRenderBodyOnly(true)});
        ListDataProvider items = new ListDataProvider(menu.menuItems);
        DataView<Menu.MenuItem> view = new DataView<Menu.MenuItem>("menuItems", (IDataProvider)items){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<Menu.MenuItem> item) {
                Menu.MenuItem entry = (Menu.MenuItem)item.getModelObject();
                if (entry instanceof Menu.PageLinkMenuItem) {
                    Menu.PageLinkMenuItem pageLink = (Menu.PageLinkMenuItem)entry;
                    item.add(new Component[]{new LinkPanel("menuItem", null, null, pageLink.toString(), pageLink.getPageClass(), pageLink.getPageParameters(), false).setRenderBodyOnly(true)});
                } else if (entry instanceof Menu.ExternalLinkMenuItem) {
                    Menu.ExternalLinkMenuItem extLink = (Menu.ExternalLinkMenuItem)entry;
                    item.add(new Component[]{new LinkPanel("menuItem", null, extLink.toString(), extLink.getHref(), extLink.openInNewWindow()).setRenderBodyOnly(true)});
                } else if (entry instanceof Menu.MenuDivider) {
                    item.add(new Component[]{new Label("menuItem").setRenderBodyOnly(true)});
                    WicketUtils.setCssClass(item, "divider");
                } else {
                    throw new IllegalArgumentException(String.format("Unexpected menuitem type %s", entry.getClass().getSimpleName()));
                }
            }
        };
        this.add(new Component[]{view});
        this.setRenderBodyOnly(true);
    }
}

