/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.models.FederationProposal;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.ReviewProposalPage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.LinkPanel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;

public class FederationProposalsPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private final boolean hasProposals;

    public FederationProposalsPanel(String wicketId) {
        super(wicketId);
        final List<FederationProposal> list = this.app().federation().getPendingFederationProposals();
        this.hasProposals = list.size() > 0;
        DataView<FederationProposal> dataView = new DataView<FederationProposal>("row", (IDataProvider)new ListDataProvider(list)){
            private static final long serialVersionUID = 1L;
            private int counter;

            protected void onBeforeRender() {
                super.onBeforeRender();
                this.counter = 0;
            }

            public void populateItem(Item<FederationProposal> item) {
                final FederationProposal entry = (FederationProposal)item.getModelObject();
                item.add(new Component[]{new LinkPanel("url", "list", entry.url, ReviewProposalPage.class, WicketUtils.newTokenParameter(entry.token))});
                item.add(new Component[]{WicketUtils.createDateLabel("received", entry.received, FederationProposalsPanel.this.getTimeZone(), FederationProposalsPanel.this.getTimeUtils())});
                item.add(new Component[]{new Label("tokenType", entry.tokenType.name())});
                item.add(new Component[]{new LinkPanel("token", "list", entry.token, ReviewProposalPage.class, WicketUtils.newTokenParameter(entry.token))});
                Link<Void> deleteLink = new Link<Void>("deleteProposal"){
                    private static final long serialVersionUID = 1L;

                    public void onClick() {
                        if (FederationProposalsPanel.this.app().federation().deletePendingFederationProposal(entry)) {
                            list.remove(entry);
                            this.info(MessageFormat.format("Proposal ''{0}'' deleted.", entry.name));
                        } else {
                            this.error((Serializable)((Object)MessageFormat.format("Failed to delete proposal ''{0}''!", entry.name)));
                        }
                    }
                };
                deleteLink.add(new IBehavior[]{new BasePanel.JavascriptEventConfirmation("onclick", MessageFormat.format("Delete proposal \"{0}\"?", entry.name))});
                item.add(new Component[]{deleteLink});
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{dataView});
    }

    public Component hideIfEmpty() {
        return super.setVisible(this.hasProposals);
    }
}

