/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.models.ProjectModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.freemarker.FreemarkerPanel;
import com.gitblit.wicket.ng.NgController;
import com.gitblit.wicket.panels.BasePanel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.basic.Label;

public class FilterableProjectList
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private final List<ProjectModel> projects;
    private String title;
    private String iconClass;

    public FilterableProjectList(String id, List<ProjectModel> projects) {
        super(id);
        this.projects = projects;
    }

    public void setTitle(String title, String iconClass) {
        this.title = title;
        this.iconClass = iconClass;
    }

    protected void onInitialize() {
        super.onInitialize();
        String id = this.getId();
        String ngCtrl = id + "Ctrl";
        String ngList = id + "List";
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("ngCtrl", ngCtrl);
        values.put("ngList", ngList);
        FreemarkerPanel panel = new FreemarkerPanel("listComponent", "FilterableProjectList.fm", values);
        panel.setParseGeneratedMarkup(true);
        panel.setRenderBodyOnly(true);
        this.add(new Component[]{panel});
        String listTitle = StringUtils.isEmpty(this.title) ? this.getString("gb.projects") : this.title;
        panel.add(new Component[]{new Label(ngList + "Title", MessageFormat.format("{0} ({1})", listTitle, this.projects.size()))});
        if (StringUtils.isEmpty(this.iconClass)) {
            panel.add(new Component[]{new Label(ngList + "Icon").setVisible(false)});
        } else {
            Label icon = new Label(ngList + "Icon");
            WicketUtils.setCssClass((Component)icon, this.iconClass);
            panel.add(new Component[]{icon});
        }
        String format = this.app().settings().getString("web.datestampShortFormat", "MM/dd/yy");
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(this.getTimeZone());
        Collections.sort(this.projects, new Comparator<ProjectModel>(){

            @Override
            public int compare(ProjectModel o1, ProjectModel o2) {
                return o2.lastChange.compareTo(o1.lastChange);
            }
        });
        ArrayList<ProjectListItem> list = new ArrayList<ProjectListItem>();
        for (ProjectModel proj : this.projects) {
            if (proj.isUserProject() || proj.repositories.isEmpty()) continue;
            ProjectListItem item = new ProjectListItem();
            item.p = proj.name;
            item.n = StringUtils.isEmpty(proj.title) ? proj.name : proj.title;
            item.i = proj.description;
            item.t = this.getTimeUtils().timeAgo(proj.lastChange);
            item.d = df.format(proj.lastChange);
            item.c = proj.repositories.size();
            list.add(item);
        }
        NgController ctrl = new NgController(ngCtrl);
        ctrl.addVariable(ngList, list);
        this.add(new IBehavior[]{new HeaderContributor((IHeaderContributor)ctrl)});
    }

    protected class ProjectListItem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String p;
        String n;
        String t;
        String d;
        String i;
        long c;

        protected ProjectListItem() {
        }
    }
}

