/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.Constants;
import com.gitblit.models.RefModel;
import com.gitblit.servlet.BranchGraphServlet;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.ExternalImage;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.CommitDiffPage;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.GitSearchPage;
import com.gitblit.wicket.pages.LogPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.RefsPanel;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class LogPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private boolean hasMore;

    public LogPanel(String wicketId, final String repositoryName, String objectId, Repository r, int limit, int pageOffset, boolean showRemoteRefs) {
        super(wicketId);
        boolean pageResults = limit <= 0;
        int itemsPerPage = this.app().settings().getInteger("web.itemsPerPage", 50);
        if (itemsPerPage <= 1) {
            itemsPerPage = 50;
        }
        final Map<ObjectId, List<RefModel>> allRefs = JGitUtils.getAllRefs(r, showRemoteRefs);
        List<RevCommit> commits = pageResults ? JGitUtils.getRevLog(r, objectId, pageOffset * itemsPerPage, itemsPerPage) : JGitUtils.getRevLog(r, objectId, 0, limit);
        this.hasMore = commits.size() >= itemsPerPage;
        String baseUrl = WicketUtils.getGitblitURL(this.getRequest());
        boolean showGraph = this.app().settings().getBoolean("web.showBranchGraph", true);
        WebMarkupContainer graph = new WebMarkupContainer("graph");
        this.add(new Component[]{graph});
        if (!showGraph || commits.isEmpty()) {
            graph.setVisible(false);
        } else {
            graph.add(new IBehavior[]{new SimpleAttributeModifier("rowspan", (CharSequence)("" + (commits.size() + 1)))});
            graph.add(new Component[]{new ExternalImage("image", BranchGraphServlet.asLink(baseUrl, repositoryName, commits.get(0).name(), commits.size()))});
        }
        if (pageResults) {
            this.add(new Component[]{new Label("header", objectId)});
        } else {
            this.add(new Component[]{new LinkPanel("header", "title", objectId, LogPage.class, WicketUtils.newRepositoryParameter(repositoryName))});
        }
        final int hashLen = this.app().settings().getInteger("web.shortCommitIdLength", 6);
        ListDataProvider dp = new ListDataProvider(commits);
        DataView<RevCommit> logView = new DataView<RevCommit>("commit", (IDataProvider)dp){
            private static final long serialVersionUID = 1L;
            int counter;

            public void populateItem(Item<RevCommit> item) {
                String shortMessage;
                RevCommit entry = (RevCommit)item.getModelObject();
                Date date = JGitUtils.getAuthorDate(entry);
                boolean isMerge = entry.getParentCount() > 1;
                item.add(new Component[]{WicketUtils.createDateLabel("commitDate", date, LogPanel.this.getTimeZone(), LogPanel.this.getTimeUtils())});
                String author = entry.getAuthorIdent().getName();
                LinkPanel authorLink = new LinkPanel("commitAuthor", "list", author, GitSearchPage.class, WicketUtils.newSearchParameter(repositoryName, null, author, Constants.SearchType.AUTHOR));
                LogPanel.this.setPersonSearchTooltip((Component)authorLink, author, Constants.SearchType.AUTHOR);
                item.add(new Component[]{authorLink});
                if (isMerge) {
                    item.add(new Component[]{WicketUtils.newImage("commitIcon", "commit_merge_16x16.png")});
                } else {
                    item.add(new Component[]{WicketUtils.newBlankImage("commitIcon")});
                }
                String trimmedMessage = shortMessage = entry.getShortMessage();
                trimmedMessage = allRefs.containsKey(entry.getId()) ? StringUtils.trimString(shortMessage, 60) : StringUtils.trimString(shortMessage, 78);
                LinkPanel shortlog = new LinkPanel("commitShortMessage", "list subject" + (isMerge ? " merge" : ""), trimmedMessage, CommitPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getName()));
                if (!shortMessage.equals(trimmedMessage)) {
                    WicketUtils.setHtmlTooltip((Component)shortlog, shortMessage);
                }
                item.add(new Component[]{shortlog});
                item.add(new Component[]{new RefsPanel("commitRefs", repositoryName, entry, allRefs)});
                LinkPanel commitHash = new LinkPanel("hashLink", null, entry.getName().substring(0, hashLen), CommitPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getName()));
                WicketUtils.setCssClass((Component)commitHash, "shortsha1");
                WicketUtils.setHtmlTooltip((Component)commitHash, entry.getName());
                item.add(new Component[]{commitHash});
                item.add(new Component[]{new BookmarkablePageLink("diff", CommitDiffPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getName())).setEnabled(entry.getParentCount() > 0)});
                item.add(new Component[]{new BookmarkablePageLink("tree", TreePage.class, WicketUtils.newObjectParameter(repositoryName, entry.getName()))});
                String clazz = this.counter % 2 == 0 ? "light commit" : "dark commit";
                WicketUtils.setCssClass(item, clazz);
                ++this.counter;
            }
        };
        this.add(new Component[]{logView});
        if (limit <= 0) {
            this.add(new Component[]{new Label("moreLogs", "").setVisible(false)});
        } else if (pageResults) {
            this.add(new Component[]{new Label("moreLogs", "").setVisible(false)});
        } else if (commits.size() == limit) {
            this.add(new Component[]{new LinkPanel("moreLogs", "link", (IModel<String>)new StringResourceModel("gb.moreLogs", (Component)this, null), LogPage.class, WicketUtils.newRepositoryParameter(repositoryName))});
        } else {
            this.add(new Component[]{new Label("moreLogs", "").setVisible(false)});
        }
    }

    public boolean hasMore() {
        return this.hasMore;
    }
}

