/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.models.NavLink;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.panels.DropDownMenu;
import com.gitblit.wicket.panels.LinkPanel;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;

public class NavigationPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public NavigationPanel(String id, final Class<? extends BasePage> pageClass, List<NavLink> navLinks) {
        super(id);
        ListDataProvider refsDp = new ListDataProvider(navLinks);
        DataView<NavLink> linksView = new DataView<NavLink>("navLink", (IDataProvider)refsDp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<NavLink> item) {
                NavLink navLink = (NavLink)item.getModelObject();
                String linkText = navLink.translationKey;
                try {
                    linkText = this.getString(navLink.translationKey);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (navLink.hiddenPhone) {
                    WicketUtils.setCssClass(item, "hidden-phone");
                }
                if (navLink instanceof NavLink.ExternalNavLink) {
                    NavLink.ExternalNavLink link = (NavLink.ExternalNavLink)navLink;
                    LinkPanel c = new LinkPanel("link", null, linkText, link.url);
                    c.setRenderBodyOnly(true);
                    item.add(new Component[]{c});
                } else if (navLink instanceof NavLink.DropDownPageMenuNavLink) {
                    NavLink.DropDownPageMenuNavLink reg = (NavLink.DropDownPageMenuNavLink)navLink;
                    DropDownMenu c = new DropDownMenu("link", linkText, reg);
                    c.setRenderBodyOnly(true);
                    item.add(new Component[]{c});
                    WicketUtils.setCssClass(item, "dropdown");
                } else if (navLink instanceof NavLink.DropDownMenuNavLink) {
                    NavLink.DropDownMenuNavLink reg = (NavLink.DropDownMenuNavLink)navLink;
                    DropDownMenu c = new DropDownMenu("link", linkText, reg);
                    c.setRenderBodyOnly(true);
                    item.add(new Component[]{c});
                    WicketUtils.setCssClass(item, "dropdown");
                } else if (navLink instanceof NavLink.PageNavLink) {
                    NavLink.PageNavLink reg = (NavLink.PageNavLink)navLink;
                    LinkPanel c = new LinkPanel("link", null, linkText, reg.pageClass, reg.params);
                    c.setRenderBodyOnly(true);
                    if (reg.pageClass.equals(pageClass)) {
                        WicketUtils.setCssClass(item, "active");
                    }
                    item.add(new Component[]{c});
                }
            }
        };
        this.add(new Component[]{linksView});
    }
}

